/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.builder.dialect.asm;

import org.drools.core.rule.builder.dialect.asm.ClassGenerator;
import org.kie.internal.utils.ChainedProperties;

public class ClassLevel {
    public static final String JAVA_LANG_LEVEL_PROPERTY = "drools.dialect.java.compiler.lnglevel";
    private static volatile int javaVersion = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getJavaVersion(ClassLoader classLoader) {
        if (javaVersion >= 0) return javaVersion;
        Class<ClassGenerator> clazz = ClassGenerator.class;
        synchronized (ClassGenerator.class) {
            if (javaVersion >= 0) return javaVersion;
            ClassLevel.findJavaVersion(classLoader);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return javaVersion;
        }
    }

    private static void findJavaVersion(ClassLoader classLoader) {
        ChainedProperties chainedProperties = new ChainedProperties("packagebuilder.conf", classLoader, true);
        if (chainedProperties.getProperty("drools.dialect.java", null) == null) {
            chainedProperties = new ChainedProperties("packagebuilder.conf", ClassGenerator.class.getClassLoader(), true);
        }
        javaVersion = ClassLevel.findJavaVersion(chainedProperties);
    }

    public static int findJavaVersion(ChainedProperties chainedProperties) {
        String level = chainedProperties.getProperty(JAVA_LANG_LEVEL_PROPERTY, System.getProperty("java.version"));
        if (level.startsWith("1.5")) {
            return 49;
        }
        if (level.startsWith("1.6")) {
            return 50;
        }
        if (level.startsWith("1.7")) {
            return 51;
        }
        return 51;
    }
}

