/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.jbpm.kie.services.impl.model.NodeInstanceDesc;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.kie.services.impl.model.VariableStateDesc;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.internal.deployment.DeployedAsset;

@ApplicationScoped
public class RuntimeDataServiceImpl
implements RuntimeDataService {
    private Set<ProcessAssetDesc> availableProcesses = new HashSet<ProcessAssetDesc>();
    @Inject
    private TransactionalCommandService commandService;
    @Inject
    private IdentityProvider identityProvider;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void indexOnDeploy(@Observes @Deploy DeploymentEvent event) {
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        for (DeployedAsset asset : assets) {
            if (!(asset instanceof ProcessAssetDesc)) continue;
            this.availableProcesses.add((ProcessAssetDesc)asset);
        }
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        this.availableProcesses.removeAll(outputCollection);
    }

    @Override
    public Collection<ProcessAssetDesc> getProcessesByDeploymentId(String deploymentId) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdPredicate(deploymentId, this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public ProcessAssetDesc getProcessesByDeploymentIdProcessId(String deploymentId, String processId) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdProcessIdPredicate(deploymentId, processId, this.identityProvider.getRoles()), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessAssetDesc)outputCollection.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ProcessAssetDesc> getProcessesByFilter(String filter) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new RegExPredicate("^.*" + filter + ".*$", this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public ProcessAssetDesc getProcessById(String processId) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByProcessIdPredicate(processId, this.identityProvider.getRoles()), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessAssetDesc)outputCollection.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ProcessAssetDesc> getProcesses() {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new SecurePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public Collection<String> getProcessIds(String deploymentId) {
        ArrayList<String> processIds = new ArrayList<String>(this.availableProcesses.size());
        if (deploymentId == null || deploymentId.isEmpty()) {
            return processIds;
        }
        for (ProcessAssetDesc procAssetDesc : this.availableProcesses) {
            if (!procAssetDesc.getDeploymentId().equals(deploymentId)) continue;
            processIds.add(procAssetDesc.getId());
        }
        return processIds;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances() {
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstances"));
        HashSet outputCollection = new HashSet();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatusAndInitiator", params));
        }
        HashSet outputCollection = new HashSet();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("externalId", deploymentId);
        params.put("states", states);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByDeploymentId", params));
        try {
            HashSet outputCollection = new HashSet();
            CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
            return Collections.unmodifiableCollection(outputCollection);
        }
        catch (ContextNotActiveException e) {
            return processInstances;
        }
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processDefId", processDefId);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessDefinition", params));
        HashSet outputCollection = new HashSet();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public ProcessInstanceDesc getProcessInstanceById(long processId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("processId", processId);
        params.put("maxResults", 1);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceById", params));
        HashSet outputCollection = new HashSet();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessInstanceDesc)outputCollection.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processId", processId + "%");
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatusAndInitiator", params));
        }
        HashSet outputCollection = new HashSet();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processName", processName + "%");
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatusAndInitiator", params));
        }
        HashSet outputCollection = new HashSet();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(String deploymentId, long processId) {
        return this.getProcessInstanceHistory(deploymentId, processId, false);
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(String deploymentId, long processId, boolean completed) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("externalId", deploymentId);
        if (completed) {
            params.put("type", 1);
        } else {
            params.put("type", 0);
        }
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceHistory", params));
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(String deploymentId, long processId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("externalId", deploymentId);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistory", params));
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceActiveNodes(String deploymentId, long processId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("externalId", deploymentId);
        List activeNodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceActiveNodes", params));
        return activeNodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceCompletedNodes(String deploymentId, long processId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("externalId", deploymentId);
        List completedNodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceCompletedNodes", params));
        return completedNodeInstances;
    }

    @Override
    public Collection<VariableStateDesc> getVariablesCurrentState(long processInstanceId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processInstanceId", processInstanceId);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariablesCurrentState", params));
        return variablesState;
    }

    @Override
    public Collection<VariableStateDesc> getVariableHistory(long processInstanceId, String variableId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("variableId", variableId);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariableHistory", params));
        return variablesState;
    }

    private class UnsecureByDeploymentIdPredicate
    implements Predicate {
        private String deploymentId;

        private UnsecureByDeploymentIdPredicate(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc;
            return object instanceof ProcessAssetDesc && (pDesc = (ProcessAssetDesc)object).getDeploymentId().equals(this.deploymentId);
        }
    }

    private class SecureInstancePredicate
    implements Predicate {
        private List<String> roles;

        private SecureInstancePredicate(List<String> roles) {
            this.roles = roles;
        }

        public boolean evaluate(Object object) {
            ProcessInstanceDesc pInstDesc = (ProcessInstanceDesc)object;
            ProcessAssetDesc pDesc = RuntimeDataServiceImpl.this.getProcessesByDeploymentIdProcessId(pInstDesc.getDeploymentId(), pInstDesc.getProcessId());
            if (this.roles == null || this.roles.isEmpty()) {
                return true;
            }
            return pDesc != null;
        }
    }

    private class SecurePredicate
    implements Predicate {
        private List<String> roles;

        private SecurePredicate(List<String> roles) {
            this.roles = roles;
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
            if (this.roles == null || this.roles.isEmpty() || pDesc.getRoles() == null || pDesc.getRoles().isEmpty()) {
                return true;
            }
            return CollectionUtils.containsAny(this.roles, pDesc.getRoles());
        }
    }

    private class ByDeploymentIdProcessIdPredicate
    extends SecurePredicate {
        private String processId;
        private String depoymentId;

        private ByDeploymentIdProcessIdPredicate(String depoymentId, String processId, List<String> roles) {
            super(roles);
            this.depoymentId = depoymentId;
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId) && pDesc.getDeploymentId().equals(this.depoymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByProcessIdPredicate
    extends SecurePredicate {
        private String processId;

        private ByProcessIdPredicate(String processId, List<String> roles) {
            super(roles);
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByDeploymentIdPredicate
    extends SecurePredicate {
        private String deploymentId;

        private ByDeploymentIdPredicate(String deploymentId, List<String> roles) {
            super(roles);
            this.deploymentId = deploymentId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getDeploymentId().equals(this.deploymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class RegExPredicate
    extends SecurePredicate {
        private String pattern;

        private RegExPredicate(String pattern, List<String> roles) {
            super(roles);
            this.pattern = pattern;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().matches(this.pattern) || pDesc.getName().matches(this.pattern)) {
                    return true;
                }
            }
            return false;
        }
    }
}

