/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.Date;
import java.util.List;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.commands.QueryStringCommand;
import org.jbpm.shared.services.impl.commands.RemoveObjectCommand;
import org.kie.api.command.Command;
import org.kie.internal.command.Context;
import org.kie.internal.executor.api.ExecutorAdminService;
import org.kie.internal.executor.api.STATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRequestAdminServiceImpl
implements ExecutorAdminService,
RequeueAware {
    private CommandService commandService;

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public int clearAllRequests() {
        List requests = (List)this.commandService.execute((Command)new QueryStringCommand("select r from RequestInfo r"));
        this.commandService.execute((Command)new RemoveObjectCommand(requests.toArray()));
        return requests.size();
    }

    public int clearAllErrors() {
        List errors = (List)this.commandService.execute((Command)new QueryStringCommand("select e from ErrorInfo e"));
        this.commandService.execute((Command)new RemoveObjectCommand(errors.toArray()));
        return errors.size();
    }

    @Override
    public void requeue(Long olderThan) {
        this.commandService.execute((Command)new RequeueRunningJobsCommand(olderThan));
    }

    @Override
    public void requeueById(Long requestId) {
        this.commandService.execute((Command)new RequeueRunningJobCommand(requestId));
    }

    private class RequeueRunningJobCommand
    implements GenericCommand<Void> {
        private Logger logger = LoggerFactory.getLogger(RequeueRunningJobCommand.class);
        private static final long serialVersionUID = 8670412133363766161L;
        private Long requestId;

        public RequeueRunningJobCommand(Long id) {
            this.requestId = id;
        }

        public Void execute(Context context) {
            List requests = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                requests = (List)ctx.queryInTransaction("RunningRequests", List.class);
                for (RequestInfo request : requests) {
                    if (request == null || request.getId() != this.requestId) continue;
                    this.logger.info("Requeing request with id : {}, key : {}, start time : {}", new Object[]{request.getId(), request.getKey(), request.getTime()});
                    request.setStatus(STATUS.QUEUED);
                    ctx.merge((Object)request);
                    break;
                }
            }
            catch (Exception e) {
                this.logger.warn("Error while trying to requeue jobs that runs for too long {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private class RequeueRunningJobsCommand
    implements GenericCommand<Void> {
        private Logger logger = LoggerFactory.getLogger(RequeueRunningJobsCommand.class);
        private static final long serialVersionUID = 8670412133363766161L;
        private Long upperLimitTime;

        public RequeueRunningJobsCommand(Long maxRunningTime) {
            this.upperLimitTime = System.currentTimeMillis() - maxRunningTime;
        }

        public Void execute(Context context) {
            List requests = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                requests = (List)ctx.queryInTransaction("RunningRequests", List.class);
                for (RequestInfo request : requests) {
                    if (request == null || !this.maxRunningTimeExceeded(request.getTime())) continue;
                    this.logger.info("Requeing request as the time exceeded for its running state id : {}, key : {}, start time : {}, max time {}", new Object[]{request.getId(), request.getKey(), request.getTime(), new Date(this.upperLimitTime)});
                    request.setStatus(STATUS.QUEUED);
                    ctx.merge((Object)request);
                }
            }
            catch (Exception e) {
                this.logger.warn("Error while trying to requeue jobs that runs for too long {}", (Object)e.getMessage());
            }
            return null;
        }

        private boolean maxRunningTimeExceeded(Date actualDate) {
            return actualDate.getTime() < this.upperLimitTime;
        }
    }
}

