/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jbpm.services.task.identity.AbstractUserGroupInfo;
import org.kie.api.task.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPUserGroupCallbackImpl
extends AbstractUserGroupInfo
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(LDAPUserGroupCallbackImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "classpath:/jbpm.usergroup.callback.properties";
    public static final String BIND_USER = "ldap.bind.user";
    public static final String BIND_PWD = "ldap.bind.pwd";
    public static final String USER_CTX = "ldap.user.ctx";
    public static final String ROLE_CTX = "ldap.role.ctx";
    public static final String USER_ROLES_CTX = "ldap.user.roles.ctx";
    public static final String USER_FILTER = "ldap.user.filter";
    public static final String ROLE_FILTER = "ldap.role.filter";
    public static final String USER_ROLES_FILTER = "ldap.user.roles.filter";
    public static final String USER_ATTR_ID = "ldap.user.attr.id";
    public static final String ROLE_ATTR_ID = "ldap.roles.attr.id";
    public static final String IS_USER_ID_DN = "ldap.user.id.dn";
    public static final String SEARCH_SCOPE = "ldap.search.scope";
    protected static final String[] requiredProperties = new String[]{"ldap.user.ctx", "ldap.role.ctx", "ldap.user.filter", "ldap.role.filter", "ldap.user.roles.filter"};
    private Properties config;

    public LDAPUserGroupCallbackImpl(boolean activate) {
        String propertiesLocation = System.getProperty("jbpm.usergroup.callback.properties");
        this.config = this.readProperties(propertiesLocation, DEFAULT_PROPERTIES_NAME);
        this.validate();
    }

    public LDAPUserGroupCallbackImpl(Properties config) {
        this.config = config;
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsUser(String userId) {
        InitialLdapContext ctx = null;
        boolean exists = false;
        try {
            NamingEnumeration<SearchResult> result;
            ctx = this.buildInitialLdapContext();
            String userContext = this.config.getProperty(USER_CTX);
            String userFilter = this.config.getProperty(USER_FILTER);
            String userAttrId = this.config.getProperty(USER_ATTR_ID, "uid");
            userFilter = userFilter.replaceAll("\\{0\\}", userId);
            logger.debug("Seaching for user existence with filter {} on context {}", (Object)userFilter, (Object)userContext);
            SearchControls constraints = new SearchControls();
            String searchScope = this.config.getProperty(SEARCH_SCOPE);
            if (searchScope != null) {
                constraints.setSearchScope(this.parseSearchScope(searchScope));
            }
            if ((result = ctx.search(userContext, userFilter, constraints)).hasMore()) {
                SearchResult sr = result.next();
                Attribute ldapUserId = sr.getAttributes().get(userAttrId);
                if (ldapUserId.contains(userId)) {
                    exists = true;
                }
                logger.debug("Entry in LDAP found and result of matching with given user id is {}", (Object)exists);
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsGroup(String groupId) {
        InitialLdapContext ctx = null;
        boolean exists = false;
        try {
            SearchResult sr;
            Attribute ldapUserId;
            NamingEnumeration<SearchResult> result;
            ctx = this.buildInitialLdapContext();
            String roleContext = this.config.getProperty(ROLE_CTX);
            String roleFilter = this.config.getProperty(ROLE_FILTER);
            String roleAttrId = this.config.getProperty(ROLE_ATTR_ID, "cn");
            roleFilter = roleFilter.replaceAll("\\{0\\}", groupId);
            SearchControls constraints = new SearchControls();
            String searchScope = this.config.getProperty(SEARCH_SCOPE);
            if (searchScope != null) {
                constraints.setSearchScope(this.parseSearchScope(searchScope));
            }
            if ((result = ctx.search(roleContext, roleFilter, constraints)).hasMore() && (ldapUserId = (sr = result.next()).getAttributes().get(roleAttrId)).contains(groupId)) {
                exists = true;
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        InitialLdapContext ctx = null;
        ArrayList<String> userGroups = new ArrayList<String>();
        try {
            ctx = this.buildInitialLdapContext();
            String userDN = null;
            if (!Boolean.parseBoolean(this.config.getProperty(IS_USER_ID_DN, "false"))) {
                logger.debug("User id is not DN, looking up user first...");
                String userContext = this.config.getProperty(USER_CTX);
                String userFilter = this.config.getProperty(USER_FILTER);
                userFilter = userFilter.replaceAll("\\{0\\}", userId);
                SearchControls constraints = new SearchControls();
                String searchScope = this.config.getProperty(SEARCH_SCOPE);
                if (searchScope != null) {
                    constraints.setSearchScope(this.parseSearchScope(searchScope));
                }
                logger.debug("Searching for user DN with filter {} on context {}", (Object)userFilter, (Object)userContext);
                NamingEnumeration<SearchResult> result = ctx.search(userContext, userFilter, constraints);
                if (result.hasMore()) {
                    SearchResult searchResult = (SearchResult)result.nextElement();
                    userDN = searchResult.getNameInNamespace();
                    logger.debug("User DN found, DN is {}", (Object)userDN);
                }
                result.close();
            }
            String roleContext = this.config.getProperty(USER_ROLES_CTX, this.config.getProperty(ROLE_CTX));
            String roleFilter = this.config.getProperty(USER_ROLES_FILTER);
            String roleAttrId = this.config.getProperty(ROLE_ATTR_ID, "cn");
            roleFilter = roleFilter.replaceAll("\\{0\\}", userDN != null ? userDN : userId);
            SearchControls constraints = new SearchControls();
            String searchScope = this.config.getProperty(SEARCH_SCOPE);
            if (searchScope != null) {
                constraints.setSearchScope(this.parseSearchScope(searchScope));
            }
            logger.debug("Searching for groups for user with filter {} on context {}", (Object)roleFilter, (Object)roleContext);
            NamingEnumeration<SearchResult> result = ctx.search(roleContext, roleFilter, constraints);
            if (result.hasMore()) {
                SearchResult searchResult = null;
                String name = null;
                while (result.hasMore()) {
                    searchResult = (SearchResult)result.nextElement();
                    name = (String)searchResult.getAttributes().get(roleAttrId).get();
                    logger.debug("Found group {}", (Object)name);
                    userGroups.add(name);
                }
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return userGroups;
    }

    protected void validate() {
        if (this.config == null) {
            throw new IllegalArgumentException("No configuration found for LDAPUserGroupCallbackImpl, aborting...");
        }
        StringBuffer missingRequiredProps = new StringBuffer();
        for (String requiredProp : requiredProperties) {
            if (this.config.containsKey(requiredProp)) continue;
            if (missingRequiredProps.length() > 0) {
                missingRequiredProps.append(", ");
            }
            missingRequiredProps.append(requiredProp);
        }
        if (missingRequiredProps.length() > 0) {
            logger.debug("Validation failed due to missing required properties: {}", (Object)missingRequiredProps.toString());
            throw new IllegalArgumentException("Missing required properties to configure LDAPUserGroupCallbackImpl: " + missingRequiredProps.toString());
        }
    }

    protected InitialLdapContext buildInitialLdapContext() throws NamingException {
        String binduser;
        String authType;
        String factoryName = this.config.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            this.config.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = this.config.getProperty("java.naming.security.authentication")) == null) {
            this.config.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = this.config.getProperty("java.naming.security.protocol");
        String providerURL = this.config.getProperty("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
            this.config.setProperty("java.naming.provider.url", providerURL);
        }
        if ((binduser = this.config.getProperty(BIND_USER)) != null) {
            this.config.setProperty("java.naming.security.principal", binduser);
        }
        String bindpwd = this.config.getProperty(BIND_PWD);
        if (binduser != null) {
            this.config.setProperty("java.naming.security.credentials", bindpwd);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using following InitialLdapContext properties:");
            logger.debug("Factory {}", (Object)this.config.getProperty("java.naming.factory.initial"));
            logger.debug("Authentication {}", (Object)this.config.getProperty("java.naming.security.authentication"));
            logger.debug("Protocol {}", (Object)this.config.getProperty("java.naming.security.protocol"));
            logger.debug("Provider URL {}", (Object)this.config.getProperty("java.naming.provider.url"));
        }
        return new InitialLdapContext(this.config, null);
    }

    protected int parseSearchScope(String searchScope) {
        logger.debug("Search scope: {}", (Object)searchScope);
        if ("OBJECT_SCOPE".equals(searchScope)) {
            return 0;
        }
        if ("ONELEVEL_SCOPE".equals(searchScope)) {
            return 1;
        }
        if ("SUBTREE_SCOPE".equals(searchScope)) {
            return 2;
        }
        return 0;
    }
}

