/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.defeasible;

import java.util.Arrays;
import org.drools.core.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.core.beliefsystem.defeasible.Defeater;
import org.drools.core.beliefsystem.defeasible.Defeats;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.LogicalDependency;
import org.drools.core.spi.Activation;
import org.drools.core.util.LinkedListEntry;

public class DefeasibleLogicalDependency
extends SimpleLogicalDependency {
    private static final String[] EMPTY_DEFEATS = new String[0];
    public static final String DEFEATS = Defeats.class.getSimpleName();
    public static final String DEFEATER = Defeater.class.getSimpleName();
    private DefeasibilityStatus status;
    private String[] defeats;
    private LinkedListEntry<DefeasibleLogicalDependency> rootDefeated;
    private LinkedListEntry<DefeasibleLogicalDependency> tailDefeated;
    private DefeasibleLogicalDependency defeatedBy;
    private boolean isDefeater;

    public DefeasibleLogicalDependency(Activation justifier, Object justified) {
        super(justifier, justified);
        this.initDefeats();
    }

    public DefeasibleLogicalDependency(Activation justifier, Object justified, Object object, Object value) {
        super(justifier, justified, object, value);
        this.initDefeats();
    }

    private void initDefeats() {
        Object o = this.getJustifier().getRule().getMetaData().get(DEFEATER);
        if (o != null && ((Boolean)o).booleanValue()) {
            this.isDefeater = true;
        }
        if ((o = this.getJustifier().getRule().getMetaData().get(DEFEATS)) != null) {
            if (o instanceof String) {
                this.defeats = new String[]{(String)o};
                Arrays.sort(this.defeats);
            } else if (o instanceof Object[]) {
                this.defeats = (String[])Arrays.copyOf((Object[])o, ((Object[])o).length, String[].class);
                Arrays.sort(this.defeats);
            }
        } else {
            this.defeats = EMPTY_DEFEATS;
        }
    }

    public void addDefeated(DefeasibleLogicalDependency defeated) {
        defeated.setDefeatedBy(this);
        LinkedListEntry<LogicalDependency> def = defeated.getJustifierEntry();
        if (this.rootDefeated == null) {
            this.rootDefeated = def;
        } else {
            this.tailDefeated.setNext((DefeasibleLogicalDependency)((Object)def));
            def.setPrevious((LogicalDependency)((Object)this.rootDefeated));
        }
        this.tailDefeated = def;
    }

    public void removeDefeated(DefeasibleLogicalDependency defeated) {
        defeated.setDefeatedBy(null);
        if (this.rootDefeated.getObject() == defeated) {
            this.removeFirst();
        } else if (this.tailDefeated.getObject() == defeated) {
            this.removeLast();
        } else {
            LinkedListEntry entry = this.rootDefeated;
            while (entry.getObject() != defeated) {
                entry = (LinkedListEntry)entry.getNext();
            }
            ((LinkedListEntry)entry.getPrevious()).setNext(entry.getNext());
            ((LinkedListEntry)entry.getNext()).setPrevious(entry.getPrevious());
            entry.nullPrevNext();
        }
    }

    public DefeasibleLogicalDependency removeFirst() {
        if (this.rootDefeated == null) {
            return null;
        }
        LinkedListEntry<DefeasibleLogicalDependency> node = this.rootDefeated;
        this.rootDefeated = (LinkedListEntry)node.getNext();
        node.setNext(null);
        if (this.rootDefeated != null) {
            this.rootDefeated.setPrevious(null);
        } else {
            this.tailDefeated = null;
        }
        return node.getObject();
    }

    public DefeasibleLogicalDependency removeLast() {
        if (this.tailDefeated == null) {
            return null;
        }
        LinkedListEntry<DefeasibleLogicalDependency> node = this.tailDefeated;
        this.tailDefeated = (LinkedListEntry)node.getPrevious();
        node.setPrevious(null);
        if (this.tailDefeated != null) {
            this.tailDefeated.setNext(null);
        } else {
            this.rootDefeated = this.tailDefeated;
        }
        return node.getObject();
    }

    public LinkedListEntry<DefeasibleLogicalDependency> getRootDefeated() {
        return this.rootDefeated;
    }

    public LinkedListEntry<DefeasibleLogicalDependency> getTailDefeated() {
        return this.tailDefeated;
    }

    public String[] getDefeats() {
        return this.defeats;
    }

    public DefeasibleLogicalDependency getDefeatedBy() {
        return this.defeatedBy;
    }

    public void setDefeatedBy(DefeasibleLogicalDependency defeatedBy) {
        this.defeatedBy = defeatedBy;
    }

    public DefeasibilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(DefeasibilityStatus status) {
        this.status = status;
    }

    public boolean isDefeater() {
        return this.isDefeater;
    }

    public void setDefeater(boolean defeater) {
        this.isDefeater = defeater;
    }

    public void clearDefeated() {
        this.rootDefeated = null;
        this.tailDefeated = null;
    }
}

