/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;
import org.kie.api.runtime.manager.RegisterableItemsFactory;

public class DefaultRuntimeEnvironment
extends SimpleRuntimeEnvironment {
    public DefaultRuntimeEnvironment() {
        this(null, DefaultRuntimeEnvironment.discoverSchedulerService());
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf) {
        this(emf, DefaultRuntimeEnvironment.discoverSchedulerService());
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, GlobalSchedulerService globalSchedulerService) {
        super((RegisterableItemsFactory)new DefaultRegisterableItemsFactory());
        this.emf = emf;
        this.schedulerService = globalSchedulerService;
        this.usePersistence = true;
        this.userGroupCallback = new MvelUserGroupCallbackImpl(true);
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, boolean usePersistence) {
        this(emf, null);
        this.usePersistence = usePersistence;
        this.emf = emf;
        this.userGroupCallback = new MvelUserGroupCallbackImpl(true);
    }

    @Override
    public void init() {
        if (this.emf == null && this.getEnvironmentTemplate().get("org.kie.api.persistence.jpa.CmdScopedEntityManager") == null) {
            this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        }
        this.addToEnvironment("org.kie.api.persistence.jpa.EntityManagerFactory", this.emf);
        if (this.mapper == null) {
            this.mapper = this.usePersistence ? new JPAMapper(this.emf) : new InMemoryMapper();
        }
    }

    protected static GlobalSchedulerService discoverSchedulerService() {
        if (System.getProperty("org.quartz.properties") != null) {
            return new QuartzSchedulerService();
        }
        return new ThreadPoolSchedulerService(3);
    }
}

