/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.audit;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.kie.services.api.RequestScopedBackupIdentityProvider;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.event.AuditEvent;
import org.jbpm.process.audit.event.DefaultAuditEventBuilderImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesAwareAuditEventBuilder
extends DefaultAuditEventBuilderImpl {
    private static final Logger logger = LoggerFactory.getLogger(ServicesAwareAuditEventBuilder.class);
    private IdentityProvider identityProvider;
    private BeanManager beanManager = null;
    private String deploymentUnitId;

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public AuditEvent buildEvent(ProcessStartedEvent pse) {
        ProcessInstanceLog log = (ProcessInstanceLog)super.buildEvent(pse);
        log.setIdentity(this.getIdentityName());
        log.setExternalId(this.deploymentUnitId);
        return log;
    }

    public AuditEvent buildEvent(ProcessCompletedEvent pce, Object log) {
        ProcessInstanceLog instanceLog = (ProcessInstanceLog)super.buildEvent(pce, log);
        instanceLog.setExternalId(this.deploymentUnitId);
        return instanceLog;
    }

    public AuditEvent buildEvent(ProcessNodeTriggeredEvent pnte) {
        NodeInstanceLog nodeInstanceLog = (NodeInstanceLog)super.buildEvent(pnte);
        nodeInstanceLog.setExternalId(this.deploymentUnitId);
        return nodeInstanceLog;
    }

    public AuditEvent buildEvent(ProcessNodeLeftEvent pnle, Object log) {
        NodeInstanceLog nodeInstanceLog = (NodeInstanceLog)super.buildEvent(pnle, log);
        nodeInstanceLog.setExternalId(this.deploymentUnitId);
        return nodeInstanceLog;
    }

    public AuditEvent buildEvent(ProcessVariableChangedEvent pvce) {
        VariableInstanceLog variableLog = (VariableInstanceLog)super.buildEvent(pvce);
        variableLog.setExternalId(this.deploymentUnitId);
        return variableLog;
    }

    public String getDeploymentUnitId() {
        return this.deploymentUnitId;
    }

    public void setDeploymentUnitId(String deploymentUnitId) {
        this.deploymentUnitId = deploymentUnitId;
    }

    protected String getIdentityName() {
        String name = "unknown";
        try {
            name = this.identityProvider.getName();
            logger.debug("Used original identity provider with user: {}", (Object)name);
        }
        catch (ContextNotActiveException e) {
            try {
                RequestScopedBackupIdentityProvider provider = this.getBackupIdentityProvider();
                if (provider != null) {
                    name = provider.getName();
                    logger.debug("Used debug identity provider with user: {}", (Object)name);
                }
            }
            catch (ContextNotActiveException ex) {
                name = "unknown";
            }
        }
        return name;
    }

    public void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected RequestScopedBackupIdentityProvider getBackupIdentityProvider() {
        Class<RequestScopedBackupIdentityProvider> type = RequestScopedBackupIdentityProvider.class;
        logger.debug("Retrieving {} bean", (Object)type.getSimpleName());
        if (this.beanManager != null) {
            Bean bean = this.beanManager.resolve(this.beanManager.getBeans(type, new Annotation[0]));
            if (bean == null) {
                return null;
            }
            CreationalContext cc = this.beanManager.createCreationalContext(null);
            return (RequestScopedBackupIdentityProvider)this.beanManager.getReference(bean, type, cc);
        }
        return null;
    }
}

