/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.WeldAnnotation;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.MetadataMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.slf4j.cal10n.LocLogger;

public abstract class AnnotationModel<T extends Annotation> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private WeldAnnotation<T> annotatedAnnotation;
    protected boolean valid;

    public AnnotationModel(Class<T> type, ClassTransformer transformer) {
        this.annotatedAnnotation = transformer.loadAnnotation(type);
        this.init();
    }

    protected void init() {
        this.initType();
        this.initValid();
        this.check();
    }

    protected void initType() {
        if (!Annotation.class.isAssignableFrom(this.getRawType())) {
            throw new DefinitionException(MetadataMessage.META_ANNOTATION_ON_WRONG_TYPE, this.getMetaAnnotationTypes(), this.getRawType());
        }
    }

    protected void initValid() {
        this.valid = false;
        for (Class<Annotation> annotationType : this.getMetaAnnotationTypes()) {
            if (!this.annotatedAnnotation.isAnnotationPresent(annotationType)) continue;
            this.valid = true;
        }
    }

    protected void check() {
        if (this.valid && (!this.annotatedAnnotation.isAnnotationPresent(Retention.class) || this.annotatedAnnotation.isAnnotationPresent(Retention.class) && !((Retention)this.annotatedAnnotation.getAnnotation(Retention.class)).value().equals((Object)RetentionPolicy.RUNTIME))) {
            this.valid = false;
            log.debug((Enum)ReflectionMessage.MISSING_RETENTION, new Object[]{this.annotatedAnnotation});
        }
    }

    public Class<T> getRawType() {
        return this.annotatedAnnotation.getJavaClass();
    }

    protected abstract Set<Class<? extends Annotation>> getMetaAnnotationTypes();

    public boolean isValid() {
        return this.valid;
    }

    public WeldAnnotation<T> getAnnotatedAnnotation() {
        return this.annotatedAnnotation;
    }

    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " annotation model for " + this.getRawType();
    }
}

