/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.exceptions;

import java.util.HashMap;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ScriptTaskExceptionExample {
    public static final void main(String[] args) {
        ScriptTaskExceptionExample.runExample();
    }

    public static void runExample() {
        KieSession ksession = ScriptTaskExceptionExample.createKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        String varName = "var1";
        params.put(varName, "valueOne");
        try {
            ProcessInstance processInstance = ksession.startProcess("ExceptionScriptTask", params);
        }
        catch (WorkflowRuntimeException wfre) {
            String msg = "An exception happened in process instance [" + wfre.getProcessInstanceId() + "] of process [" + wfre.getProcessId() + "] in node [id: " + wfre.getNodeId() + ", name: " + wfre.getNodeName() + "] and variable " + varName + " had the value [" + wfre.getVariables().get(varName) + "]";
            System.out.println(msg);
        }
    }

    private static KieSession createKieSession() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"exceptions/ScriptTaskException.bpmn2"), ResourceType.BPMN2);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        return kbase.newKieSession();
    }
}

