/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.VariableDesc;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.query.QueryContext;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.InternalTaskService;

public class RuntimeDataServiceImpl
implements RuntimeDataService,
DeploymentEventListener {
    protected Set<ProcessDefinition> availableProcesses = new HashSet<ProcessDefinition>();
    private TransactionalCommandService commandService;
    private IdentityProvider identityProvider;
    private TaskService taskService;

    public RuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/Servicesorm.xml");
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void onDeploy(DeploymentEvent event) {
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        for (DeployedAsset asset : assets) {
            if (!(asset instanceof ProcessAssetDesc)) continue;
            this.availableProcesses.add((ProcessAssetDesc)asset);
        }
    }

    public void onUnDeploy(DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        this.availableProcesses.removeAll(outputCollection);
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected <T> Collection<T> applyPagnition(List<T> input, QueryContext queryContext) {
        if (queryContext != null) {
            int start = queryContext.getOffset();
            int end = start + queryContext.getCount();
            if (input.size() < start) {
                return new ArrayList();
            }
            if (input.size() >= end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, end)));
            }
            if (input.size() < end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, input.size())));
            }
        }
        return Collections.unmodifiableCollection(input);
    }

    protected void applySorting(List<ProcessDefinition> input, final QueryContext queryContext) {
        if (queryContext != null && queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
            Collections.sort(input, new Comparator<ProcessDefinition>(){

                @Override
                public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                    if ("ProcessName".equals(queryContext.getOrderBy())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    if ("ProcessVersion".equals(queryContext.getOrderBy())) {
                        return o1.getVersion().compareTo(o2.getVersion());
                    }
                    return 0;
                }
            });
            if (!queryContext.isAscending().booleanValue()) {
                Collections.reverse(input);
            }
        }
    }

    public Collection<ProcessDefinition> getProcessesByDeploymentId(String deploymentId, QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdPredicate(deploymentId, this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPagnition(outputCollection, queryContext);
    }

    public ProcessDefinition getProcessesByDeploymentIdProcessId(String deploymentId, String processId) {
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdProcessIdPredicate(deploymentId, processId, this.identityProvider.getRoles()), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessDefinition)outputCollection.iterator().next();
        }
        return null;
    }

    public Collection<ProcessDefinition> getProcessesByFilter(String filter, QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new RegExPredicate("^.*" + filter + ".*$", this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPagnition(outputCollection, queryContext);
    }

    public ProcessDefinition getProcessById(String processId) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByProcessIdPredicate(processId, this.identityProvider.getRoles()), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessDefinition)outputCollection.iterator().next();
        }
        return null;
    }

    public Collection<ProcessDefinition> getProcesses(QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new SecurePredicate(this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPagnition(outputCollection, queryContext);
    }

    public Collection<String> getProcessIds(String deploymentId, QueryContext queryContext) {
        ArrayList<String> processIds = new ArrayList<String>(this.availableProcesses.size());
        if (deploymentId == null || deploymentId.isEmpty()) {
            return processIds;
        }
        for (ProcessDefinition procAssetDesc : this.availableProcesses) {
            if (!((ProcessAssetDesc)procAssetDesc).getDeploymentId().equals(deploymentId)) continue;
            processIds.add(procAssetDesc.getId());
        }
        return this.applyPagnition(processIds, queryContext);
    }

    public Collection<ProcessInstanceDesc> getProcessInstances(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstances", params));
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    public Collection<ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatusAndInitiator", params));
        }
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("externalId", deploymentId);
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByDeploymentId", params));
        try {
            ArrayList outputCollection = new ArrayList();
            CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
            return Collections.unmodifiableCollection(outputCollection);
        }
        catch (IllegalStateException e) {
            return processInstances;
        }
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processDefId", processDefId);
        this.applyQueryContext(params, queryContext);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessDefinition", params));
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    public ProcessInstanceDesc getProcessInstanceById(long processId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("processId", processId);
        params.put("maxResults", 1);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceById", params));
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessInstanceDesc)outputCollection.iterator().next();
        }
        return null;
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processId", processId + "%");
        this.applyQueryContext(params, queryContext);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatusAndInitiator", params));
        }
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processName", processName + "%");
        this.applyQueryContext(params, queryContext);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatusAndInitiator", params));
        }
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select((Collection)processInstances, (Predicate)new SecureInstancePredicate(this.identityProvider.getRoles()), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    public Collection<NodeInstanceDesc> getProcessInstanceHistoryActive(long processId, QueryContext queryContext) {
        return this.getProcessInstanceHistory(processId, false, queryContext);
    }

    public Collection<NodeInstanceDesc> getProcessInstanceHistoryCompleted(long processId, QueryContext queryContext) {
        return this.getProcessInstanceHistory(processId, true, queryContext);
    }

    protected Collection<NodeInstanceDesc> getProcessInstanceHistory(long processId, boolean completed, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = Collections.emptyList();
        nodeInstances = completed ? (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceCompletedNodes", params)) : (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceActiveNodes", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(long processId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistory", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceFullHistoryByType(long processId, RuntimeDataService.EntryType type, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("type", type.getValue());
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistoryByType", params));
        return nodeInstances;
    }

    public NodeInstanceDesc getNodeInstanceForWorkItem(Long workItemId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("workItemId", workItemId);
        params.put("maxResults", 1);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getNodeInstanceForWorkItem", params));
        if (!nodeInstances.isEmpty()) {
            return (NodeInstanceDesc)nodeInstances.iterator().next();
        }
        return null;
    }

    public Collection<VariableDesc> getVariablesCurrentState(long processInstanceId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processInstanceId", processInstanceId);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariablesCurrentState", params));
        return variablesState;
    }

    public Collection<VariableDesc> getVariableHistory(long processInstanceId, String variableId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("variableId", variableId);
        this.applyQueryContext(params, queryContext);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariableHistory", params));
        return variablesState;
    }

    public UserTaskInstanceDesc getTaskByWorkItemId(Long workItemId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("workItemId", workItemId);
        params.put("maxResults", 1);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstanceByWorkItemId", params));
        if (!tasks.isEmpty()) {
            return (UserTaskInstanceDesc)tasks.iterator().next();
        }
        return null;
    }

    public UserTaskInstanceDesc getTaskById(Long taskId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("taskId", taskId);
        params.put("maxResults", 1);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstanceById", params));
        if (!tasks.isEmpty()) {
            return (UserTaskInstanceDesc)tasks.iterator().next();
        }
        return null;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, QueryFilter filter) {
        return this.taskService.getTasksAssignedAsBusinessAdministrator(userId, filter.getLanguage());
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, null, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, groupIds, null, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, groupIds, status, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, QueryFilter filter) {
        return this.taskService.getTasksAssignedAsPotentialOwnerByStatus(userId, status, filter.getLanguage());
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> status, Date from, QueryFilter filter) {
        List taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilter qf = new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, status, qf);
        } else {
            QueryFilter qf = new QueryFilter(filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, status, qf);
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> strStatuses, Date from, QueryFilter filter) {
        List taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilter qf = new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksOwned(userId, null, qf);
        } else {
            QueryFilter qf = new QueryFilter(filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksOwned(userId, null, qf);
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwned(String userId, QueryFilter filter) {
        return this.taskService.getTasksOwned(userId, filter.getLanguage());
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status, QueryFilter filter) {
        return this.taskService.getTasksOwnedByStatus(userId, status, filter.getLanguage());
    }

    public List<Long> getTasksByProcessInstanceId(Long processInstanceId) {
        return this.taskService.getTasksByProcessInstanceId(processInstanceId.longValue());
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(Long processInstanceId, List<Status> status, QueryFilter filter) {
        return this.taskService.getTasksByStatusByProcessInstanceId(processInstanceId.longValue(), status, filter.getLanguage());
    }

    private class UnsecureByDeploymentIdPredicate
    implements Predicate {
        private String deploymentId;

        private UnsecureByDeploymentIdPredicate(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc;
            return object instanceof ProcessAssetDesc && (pDesc = (ProcessAssetDesc)object).getDeploymentId().equals(this.deploymentId);
        }
    }

    private class SecureInstancePredicate
    implements Predicate {
        private List<String> roles;

        private SecureInstancePredicate(List<String> roles) {
            this.roles = roles;
        }

        public boolean evaluate(Object object) {
            ProcessInstanceDesc pInstDesc = (ProcessInstanceDesc)object;
            ProcessDefinition pDesc = RuntimeDataServiceImpl.this.getProcessesByDeploymentIdProcessId(pInstDesc.getDeploymentId(), pInstDesc.getProcessId());
            if (this.roles == null || this.roles.isEmpty()) {
                return true;
            }
            return pDesc != null;
        }
    }

    private class SecurePredicate
    implements Predicate {
        private List<String> roles;

        private SecurePredicate(List<String> roles) {
            this.roles = roles;
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
            if (this.roles == null || this.roles.isEmpty() || pDesc.getRoles() == null || pDesc.getRoles().isEmpty()) {
                return true;
            }
            return CollectionUtils.containsAny(this.roles, pDesc.getRoles());
        }
    }

    private class ByDeploymentIdProcessIdPredicate
    extends SecurePredicate {
        private String processId;
        private String depoymentId;

        private ByDeploymentIdProcessIdPredicate(String depoymentId, String processId, List<String> roles) {
            super(roles);
            this.depoymentId = depoymentId;
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId) && pDesc.getDeploymentId().equals(this.depoymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByProcessIdPredicate
    extends SecurePredicate {
        private String processId;

        private ByProcessIdPredicate(String processId, List<String> roles) {
            super(roles);
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByDeploymentIdPredicate
    extends SecurePredicate {
        private String deploymentId;

        private ByDeploymentIdPredicate(String deploymentId, List<String> roles) {
            super(roles);
            this.deploymentId = deploymentId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getDeploymentId().equals(this.deploymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class RegExPredicate
    extends SecurePredicate {
        private String pattern;

        private RegExPredicate(String pattern, List<String> roles) {
            super(roles);
            this.pattern = pattern;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().matches(this.pattern) || pDesc.getName().matches(this.pattern)) {
                    return true;
                }
            }
            return false;
        }
    }
}

