/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.processor.aggregate.AggregationStrategyMethodInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStrategyBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationStrategyBeanInfo.class);
    private final CamelContext camelContext;
    private final Class<?> type;
    private final Method method;

    public AggregationStrategyBeanInfo(CamelContext camelContext, Class<?> type, Method method) {
        this.camelContext = camelContext;
        this.type = type;
        this.method = method;
    }

    protected AggregationStrategyMethodInfo createMethodInfo() {
        ParameterInfo info;
        int i;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int size = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: {} method: {} having {} parameters", new Object[]{this.type, this.method, size});
        }
        if (size < 2) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have at least two parameters, has: " + size);
        }
        if (size % 2 != 0) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have equal number of parameters, has: " + size);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            Class<?> type = parameterTypes[i2];
            if (type.getAnnotations().length <= 0) continue;
            throw new IllegalArgumentException("Parameter annotations at index " + i2 + " is not supported on method: " + this.method);
        }
        ArrayList<ParameterInfo> oldParameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> newParameters = new ArrayList<ParameterInfo>();
        for (i = 0; i < size / 2; ++i) {
            Class<?> oldType = parameterTypes[i];
            if (oldParameters.size() == 0) {
                Expression oldBody = ExpressionBuilder.mandatoryBodyExpression(oldType);
                info = new ParameterInfo(i, oldType, null, oldBody);
                oldParameters.add(info);
                continue;
            }
            if (oldParameters.size() == 1) {
                Expression oldHeaders = ExpressionBuilder.headersExpression();
                info = new ParameterInfo(i, oldType, null, oldHeaders);
                oldParameters.add(info);
                continue;
            }
            if (oldParameters.size() != 2) continue;
            Expression oldProperties = ExpressionBuilder.propertiesExpression();
            info = new ParameterInfo(i, oldType, null, oldProperties);
            oldParameters.add(info);
        }
        for (i = size / 2; i < size; ++i) {
            Class<?> newType = parameterTypes[i];
            if (newParameters.size() == 0) {
                Expression newBody = ExpressionBuilder.mandatoryBodyExpression(newType);
                info = new ParameterInfo(i, newType, null, newBody);
                newParameters.add(info);
                continue;
            }
            if (newParameters.size() == 1) {
                Expression newHeaders = ExpressionBuilder.headersExpression();
                info = new ParameterInfo(i, newType, null, newHeaders);
                newParameters.add(info);
                continue;
            }
            if (newParameters.size() != 2) continue;
            Expression newProperties = ExpressionBuilder.propertiesExpression();
            info = new ParameterInfo(i, newType, null, newProperties);
            newParameters.add(info);
        }
        return new AggregationStrategyMethodInfo(this.camelContext, this.type, this.method, oldParameters, newParameters);
    }
}

