/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.store;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jbpm.kie.services.impl.store.DeploymentStoreEntry;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentStore {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentStore.class);
    private final XStream xstream = new XStream();
    private TransactionalCommandService commandService;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public Collection<DeploymentUnit> getEnabledDeploymentUnits() {
        ArrayList<DeploymentUnit> activeDeployments = new ArrayList<DeploymentUnit>();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("state", 1);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnitsByState", params));
        for (DeploymentStoreEntry entry : deployments) {
            DeploymentUnit unit = (DeploymentUnit)this.xstream.fromXML(entry.getDeploymentUnit());
            activeDeployments.add(unit);
        }
        return activeDeployments;
    }

    public void getDeploymentUnitsByDate(Date date, Collection<DeploymentUnit> enabled, Collection<DeploymentUnit> disabled) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("ludate", date);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnitsByDate", params));
        for (DeploymentStoreEntry entry : deployments) {
            DeploymentUnit unit = (DeploymentUnit)this.xstream.fromXML(entry.getDeploymentUnit());
            if (entry.getState() == 1) {
                enabled.add(unit);
                continue;
            }
            if (entry.getState() == 0) {
                disabled.add(unit);
                continue;
            }
            logger.warn("Unknown state of deployment store entry {} for entry {} will be ignored", (Object)entry.getId(), (Object)entry);
        }
    }

    public void enableDeploymentUnit(DeploymentUnit unit) {
        String unitContent = this.xstream.toXML((Object)unit);
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null) {
            entry.setState(1);
            entry.setUpdateDate(new Date());
            entry.setDeploymentUnit(unitContent);
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
            return;
        }
        entry = new DeploymentStoreEntry();
        entry.setDeploymentId(unit.getIdentifier());
        entry.setState(1);
        entry.setUpdateDate(new Date());
        entry.setDeploymentUnit(unitContent);
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{entry}));
    }

    public void disableDeploymentUnit(DeploymentUnit unit) {
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null) {
            entry.setState(0);
            entry.setUpdateDate(new Date());
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
        }
    }

    public void markDeploymentUnitAsObsolete(DeploymentUnit unit) {
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null) {
            entry.setState(-1);
            entry.setUpdateDate(new Date());
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
        }
    }

    public DeploymentStoreEntry findDeploymentStoreByDeploymentId(String deploymentId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("maxResults", 1);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnit", params));
        if (!deployments.isEmpty()) {
            return (DeploymentStoreEntry)deployments.get(0);
        }
        return null;
    }
}

