/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity.adapter;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeblogicUserGroupAdapter
implements UserGroupAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WeblogicUserGroupAdapter.class);
    private Class<?> webLogicSecurity;

    public WeblogicUserGroupAdapter() {
        try {
            this.webLogicSecurity = Class.forName("weblogic.security.Security");
        }
        catch (Exception e) {
            logger.info("Unable to find weblogic.security.Security, disabling weblogic adapter");
        }
    }

    @Override
    public List<String> getGroupsForUser(String userId) {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.webLogicSecurity == null || userId == null || userId.isEmpty()) {
            return roles;
        }
        try {
            Method method = this.webLogicSecurity.getMethod("getCurrentSubject", new Class[0]);
            Subject wlsSubject = (Subject)method.invoke(null, new Object[0]);
            if (wlsSubject != null) {
                for (Principal p : wlsSubject.getPrincipals()) {
                    if (p.getClass().getName().indexOf("WLSGroup") == -1) continue;
                    roles.add(p.getName());
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to get roles for user {} from subject due to {}", new Object[]{userId, e.getMessage(), e});
        }
        return roles;
    }
}

