/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.impl;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DefinitionServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBRemote;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.impl.identity.EJBContextIdentityProvider;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.identity.IdentityProvider;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@Lock(value=LockType.WRITE)
public class DeploymentServiceEJBImpl
extends KModuleDeploymentService
implements ListenerSupport,
DeploymentService,
DeploymentServiceEJBLocal,
DeploymentServiceEJBRemote {
    @Inject
    private Instance<IdentityProvider> identityProvider;
    private EJBContext context;

    @PostConstruct
    public void onInit() {
        if (this.identityProvider.isUnsatisfied()) {
            this.setIdentityProvider(new EJBContextIdentityProvider(this.context));
        } else {
            this.setIdentityProvider((IdentityProvider)this.identityProvider.get());
        }
        this.setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        super.onInit();
    }

    @Resource
    public void setContext(EJBContext context) {
        this.context = context;
    }

    @PersistenceUnit(name="org.jbpm.domain")
    public void setEmf(EntityManagerFactory emf) {
        super.setEmf(emf);
    }

    @EJB(beanInterface=DefinitionServiceEJBLocal.class)
    public void setBpmn2Service(DefinitionService bpmn2Service) {
        super.setBpmn2Service(bpmn2Service);
    }

    @EJB(beanInterface=RuntimeDataServiceEJBLocal.class)
    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        super.setRuntimeDataService(runtimeDataService);
        super.addListener((DeploymentEventListener)runtimeDataService);
    }

    public void deploy(String groupId, String artifactId, String version) {
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version);
        super.deploy((DeploymentUnit)unit);
    }

    public void deploy(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version, kbaseName, ksessionName);
        super.deploy((DeploymentUnit)unit);
    }

    public void deploy(String groupId, String artifactId, String version, String kbaseName, String ksessionName, String strategy) {
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version, kbaseName, ksessionName, strategy);
        super.deploy((DeploymentUnit)unit);
    }

    public void undeploy(String deploymentId) {
        DeployedUnit deployed = this.getDeployedUnit(deploymentId);
        if (deployed != null) {
            super.undeploy(deployed.getDeploymentUnit());
        }
    }
}

