/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.List;
import org.drools.core.command.CommandService;
import org.jbpm.services.task.commands.TaskQueryDataCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.AbstractQueryBuilderImpl;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.query.data.QueryData;
import org.kie.internal.task.query.TaskQueryBuilder;

public class TaskQueryBuilderImpl
extends AbstractQueryBuilderImpl<TaskQueryBuilder>
implements TaskQueryBuilder {
    private final CommandService executor;
    private final String userId;

    public TaskQueryBuilderImpl(String userId, CommandService taskCmdService) {
        this.executor = taskCmdService;
        this.userId = userId;
        this.queryData.getQueryContext().setAscending(Boolean.valueOf(true));
        this.queryData.getQueryContext().setOrderBy("Id");
    }

    public TaskQueryBuilder workItemId(long ... workItemId) {
        this.addLongParameter(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "work item id", workItemId);
        return this;
    }

    public TaskQueryBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public TaskQueryBuilder processInstanceId(long ... processInstanceId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return this;
    }

    public TaskQueryBuilder initiator(String ... createdById) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_BY_LIST, "created by id", createdById);
        return this;
    }

    public TaskQueryBuilder stakeHolder(String ... stakeHolderId) {
        this.addObjectParameter(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, "stakeholder id", stakeHolderId);
        return this;
    }

    public TaskQueryBuilder potentialOwner(String ... potentialOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, "potential owner id", potentialOwnerId);
        return this;
    }

    public TaskQueryBuilder taskOwner(String ... taskOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, "task owner id", taskOwnerId);
        return this;
    }

    public TaskQueryBuilder businessAdmin(String ... businessAdminId) {
        this.addObjectParameter(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, "business administrator id", businessAdminId);
        return this;
    }

    public TaskQueryBuilder status(Status ... status) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_STATUS_LIST, "status", status);
        return this;
    }

    public TaskQueryBuilder deploymentId(String ... deploymentId) {
        this.addObjectParameter(QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, "deployment id", deploymentId);
        return this;
    }

    public TaskQueryBuilder language(String language) {
        if (language == null || language.isEmpty()) {
            StringBuilder msg = new StringBuilder(language == null ? "A null" : "An empty");
            throw new IllegalArgumentException(msg.append(" language criteria is invalid.").toString());
        }
        List languages = this.queryData.getAppropriateParamList(QueryParameterIdentifiers.LANGUAGE, (Object)language, 1);
        if (languages.isEmpty()) {
            languages.add(language);
        } else {
            languages.set(0, language);
        }
        return this;
    }

    public TaskQueryBuilder orderBy(TaskQueryBuilder.OrderBy orderBy) {
        String orderByString;
        if (orderBy == null) {
            throw new IllegalArgumentException("A null order by criteria is invalid.");
        }
        switch (orderBy) {
            case taskId: {
                orderByString = "t.id";
                break;
            }
            case processInstanceId: {
                orderByString = "t.taskData.processInstanceId";
                break;
            }
            case taskName: {
                orderByString = "t.name";
                break;
            }
            case taskStatus: {
                orderByString = "t.taskData.status";
                break;
            }
            case createdOn: {
                orderByString = "t.taskData.createdOn";
                break;
            }
            case createdBy: {
                orderByString = "t.taskData.createdBy.id";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported order by arqument: " + orderBy.toString());
            }
        }
        this.queryData.getQueryContext().setOrderBy(orderByString);
        return this;
    }

    public TaskQueryBuilder clear() {
        super.clear();
        this.getQueryData().getQueryContext().setAscending(Boolean.valueOf(true));
        this.getQueryData().getQueryContext().setOrderBy("Id");
        return this;
    }

    public ParametrizedQuery<TaskSummary> buildQuery() {
        return new ParametrizedQuery<TaskSummary>(){
            private QueryData queryData;
            {
                this.queryData = new QueryData(TaskQueryBuilderImpl.this.getQueryData());
            }

            public List<TaskSummary> getResultList() {
                TaskQueryDataCommand cmd = new TaskQueryDataCommand(this.queryData);
                cmd.setUserId(TaskQueryBuilderImpl.this.userId);
                return (List)TaskQueryBuilderImpl.this.executor.execute((Command)cmd);
            }
        };
    }
}

