/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBacklogDebuggerMBean;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed BacklogDebugger")
public class ManagedBacklogDebugger
implements ManagedBacklogDebuggerMBean {
    private final CamelContext camelContext;
    private final BacklogDebugger backlogDebugger;

    public ManagedBacklogDebugger(CamelContext camelContext, BacklogDebugger backlogDebugger) {
        this.camelContext = camelContext;
        this.backlogDebugger = backlogDebugger;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public BacklogDebugger getBacklogDebugger() {
        return this.backlogDebugger;
    }

    @Override
    public String getCamelId() {
        return this.camelContext.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    @Override
    public String getLoggingLevel() {
        return this.backlogDebugger.getLoggingLevel();
    }

    @Override
    public void setLoggingLevel(String level) {
        this.backlogDebugger.setLoggingLevel(level);
    }

    @Override
    public boolean isEnabled() {
        return this.backlogDebugger.isEnabled();
    }

    @Override
    public void enableDebugger() {
        this.backlogDebugger.enableDebugger();
    }

    @Override
    public void disableDebugger() {
        this.backlogDebugger.disableDebugger();
    }

    @Override
    public void addBreakpoint(String nodeId) {
        this.backlogDebugger.addBreakpoint(nodeId);
    }

    @Override
    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        this.backlogDebugger.addConditionalBreakpoint(nodeId, language, predicate);
    }

    @Override
    public void removeBreakpoint(String nodeId) {
        this.backlogDebugger.removeBreakpoint(nodeId);
    }

    @Override
    public void removeAllBreakpoints() {
        this.backlogDebugger.removeAllBreakpoints();
    }

    @Override
    public Set<String> getBreakpoints() {
        return this.backlogDebugger.getBreakpoints();
    }

    @Override
    public void resumeBreakpoint(String nodeId) {
        this.backlogDebugger.resumeBreakpoint(nodeId);
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body);
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body, String type) {
        try {
            Class<?> classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body, classType);
        }
        catch (ClassNotFoundException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void removeMessageBodyOnBreakpoint(String nodeId) {
        this.backlogDebugger.removeMessageBodyOnBreakpoint(nodeId);
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) {
        try {
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value);
        }
        catch (NoTypeConversionAvailableException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, String type) {
        try {
            Class<?> classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value, classType);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        this.backlogDebugger.removeMessageHeaderOnBreakpoint(nodeId, headerName);
    }

    @Override
    public void resumeAll() {
        this.backlogDebugger.resumeAll();
    }

    @Override
    public void stepBreakpoint(String nodeId) {
        this.backlogDebugger.stepBreakpoint(nodeId);
    }

    @Override
    public boolean isSingleStepMode() {
        return this.backlogDebugger.isSingleStepMode();
    }

    @Override
    public void step() {
        this.backlogDebugger.step();
    }

    @Override
    public Set<String> getSuspendedBreakpointNodeIds() {
        return this.backlogDebugger.getSuspendedBreakpointNodeIds();
    }

    @Override
    public void disableBreakpoint(String nodeId) {
        this.backlogDebugger.disableBreakpoint(nodeId);
    }

    @Override
    public void enableBreakpoint(String nodeId) {
        this.backlogDebugger.enableBreakpoint(nodeId);
    }

    @Override
    public int getBodyMaxChars() {
        return this.backlogDebugger.getBodyMaxChars();
    }

    @Override
    public void setBodyMaxChars(int bodyMaxChars) {
        this.backlogDebugger.setBodyMaxChars(bodyMaxChars);
    }

    @Override
    public boolean isBodyIncludeStreams() {
        return this.backlogDebugger.isBodyIncludeStreams();
    }

    @Override
    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.backlogDebugger.setBodyIncludeStreams(bodyIncludeStreams);
    }

    @Override
    public boolean isBodyIncludeFiles() {
        return this.backlogDebugger.isBodyIncludeFiles();
    }

    @Override
    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.backlogDebugger.setBodyIncludeFiles(bodyIncludeFiles);
    }

    @Override
    public String dumpTracedMessagesAsXml(String nodeId) {
        return this.backlogDebugger.dumpTracedMessagesAsXml(nodeId);
    }

    @Override
    public long getDebugCounter() {
        return this.backlogDebugger.getDebugCounter();
    }

    @Override
    public void resetDebugCounter() {
        this.backlogDebugger.resetDebugCounter();
    }

    @Override
    public String validateConditionalBreakpoint(String language, String predicate) {
        Language lan = null;
        try {
            lan = this.camelContext.resolveLanguage(language);
            lan.createPredicate(predicate);
            return null;
        }
        catch (Exception e) {
            if (lan == null) {
                return e.getMessage();
            }
            return "Invalid syntax " + predicate + " due: " + e.getMessage();
        }
    }
}

