--db2
alter table SessionInfo alter column id set data type bigint;
alter table AuditTaskImpl alter column processSessionId set data type bigint;
alter table ContextMappingInfo alter column KSESSION_ID set data type bigint;
alter table Task alter column processSessionId set data type bigint;

reorg table SessionInfo;
reorg table AuditTaskImpl;
reorg table ContextMappingInfo;
reorg table Task;

create table DeploymentStore (
    id bigint generated by default as identity,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit clob(65535),
    state integer,
    updateDate timestamp,
    primary key (id)
);

create unique index UK_DeploymentStore_1 on DeploymentStore (DEPLOYMENT_ID);

alter table ProcessInstanceLog add processInstanceDescription varchar(255); 
alter table RequestInfo add owner varchar(255);
alter table Task add description varchar(255);
alter table Task add name varchar(255);
alter table Task add subject varchar(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

--derby
alter table SessionInfo alter column id set data type bigint;
alter table AuditTaskImpl alter column processSessionId set data type bigint;
alter table ContextMappingInfo alter column KSESSION_ID set data type bigint;
alter table Task alter column processSessionId set data type bigint;

create table DeploymentStore (
    id bigint generated by default as identity,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit clob(65535),
    state integer,
    updateDate timestamp,
    primary key (id)
);

create unique index UK_DeploymentStore_1 on DeploymentStore (DEPLOYMENT_ID);

alter table ProcessInstanceLog add column processInstanceDescription varchar(255); 
alter table RequestInfo add column owner varchar(255);
alter table Task add column description varchar(255);
alter table Task add column name varchar(255);
alter table Task add column subject varchar(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

-- h2
ALTER TABLE SessionInfo ALTER COLUMN id bigint;
ALTER TABLE AuditTaskImpl ALTER COLUMN processSessionId bigint;
ALTER TABLE ContextMappingInfo ALTER COLUMN KSESSION_ID bigint;
ALTER TABLE Task ALTER COLUMN processSessionId bigint;

create table DeploymentStore (
    id bigint generated by default as identity,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit clob,
    state integer,
    updateDate timestamp,
    primary key (id)
);

alter table DeploymentStore 
        add constraint UK_DeploymentStore_1 unique (DEPLOYMENT_ID);

ALTER TABLE ProcessInstanceLog ADD processInstanceDescription varchar(255);
ALTER TABLE RequestInfo ADD owner varchar(255);
ALTER TABLE Task ADD description varchar(255);
ALTER TABLE Task ADD name varchar(255);
ALTER TABLE Task ADD subject varchar(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

-- hsqldb
ALTER TABLE SessionInfo ALTER COLUMN id bigint;
ALTER TABLE AuditTaskImpl ALTER COLUMN processSessionId bigint;
ALTER TABLE ContextMappingInfo ALTER COLUMN KSESSION_ID bigint;
ALTER TABLE Task ALTER COLUMN processSessionId bigint;

create table DeploymentStore (
    id bigint generated by default as identity (start with 1),
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit longvarchar,
    state integer,
    updateDate timestamp,
    primary key (id)
);

 alter table DeploymentStore add constraint UK_DeploymentStore_1 unique (DEPLOYMENT_ID);
        
ALTER TABLE ProcessInstanceLog ADD COLUMN processInstanceDescription VARCHAR(255);
ALTER TABLE RequestInfo ADD COLUMN owner VARCHAR(255);
ALTER TABLE Task ADD COLUMN description VARCHAR(255);
ALTER TABLE Task ADD COLUMN name VARCHAR(255);
ALTER TABLE Task ADD COLUMN subject VARCHAR(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

-- mysql
ALTER TABLE SessionInfo MODIFY id BIGINT;
ALTER TABLE AuditTaskImpl MODIFY processSessionId BIGINT;
ALTER TABLE ContextMappingInfo MODIFY KSESSION_ID BIGINT;
ALTER TABLE Task MODIFY processSessionId BIGINT;

create table DeploymentStore (
    id bigint not null auto_increment,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit longtext,
    state integer,
    updateDate datetime,
    primary key (id)
);

-- for InnoDB
create table DeploymentStore (
    id bigint not null auto_increment,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit longtext,
    state integer,
    updateDate datetime,
    primary key (id)
) ENGINE=InnoDB;
-- end for InnoDB

alter table DeploymentStore add constraint UK_DeploymentStore_1 unique (DEPLOYMENT_ID);

ALTER TABLE ProcessInstanceLog ADD COLUMN processInstanceDescription VARCHAR(255);
ALTER TABLE RequestInfo ADD COLUMN owner VARCHAR(255);
ALTER TABLE Task ADD COLUMN description VARCHAR(255);
ALTER TABLE Task ADD COLUMN name VARCHAR(255);
ALTER TABLE Task ADD COLUMN subject VARCHAR(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);
        
INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

-- oracle
alter table SessionInfo modify ( id number(19,0) );
alter table AuditTaskImpl modify ( processSessionId number(19,0) );
alter table ContextMappingInfo modify ( KSESSION_ID number(19,0) );
alter table Task modify ( processSessionId number(19,0) );

create table DeploymentStore (
    id number(19,0) not null,
    attributes varchar2(255 char),
    DEPLOYMENT_ID varchar2(255 char),
    deploymentUnit clob,
    state number(10,0),
    updateDate timestamp,
    primary key (id)
);
alter table DeploymentStore add constraint UK_DeploymentStore_1 unique (DEPLOYMENT_ID);
create sequence DEPLOY_STORE_ID_SEQ;

alter table ProcessInstanceLog add processInstanceDescription varchar2(255 char);
alter table RequestInfo add owner varchar2(255 char);
alter table Task add (
	description varchar2(255 char),
	name varchar2(255 char),
	subject varchar2(255 char)
	);
	
-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);	

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;
        
-- postgres
ALTER TABLE sessioninfo ALTER COLUMN id TYPE bigint;
ALTER TABLE AuditTaskImpl ALTER COLUMN processSessionId TYPE bigint;
ALTER TABLE ContextMappingInfo ALTER COLUMN KSESSION_ID TYPE bigint;
ALTER TABLE Task ALTER COLUMN processSessionId TYPE bigint;

create table DeploymentStore (
    id int8 not null,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit text,
    state int4,
    updateDate timestamp,
    primary key (id)
);

alter table DeploymentStore add constraint UK_DeploymentStore_1 unique (DEPLOYMENT_ID);
create sequence DEPLOY_STORE_ID_SEQ;

ALTER TABLE ProcessInstanceLog ADD COLUMN processInstanceDescription varchar(255);
ALTER TABLE RequestInfo ADD COLUMN owner varchar(255);
ALTER TABLE Task ADD COLUMN description varchar(255);
ALTER TABLE Task ADD COLUMN name varchar(255);
ALTER TABLE Task ADD COLUMN subject varchar(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

--sql server
ALTER TABLE SessionInfo ALTER COLUMN id numeric(19,0);
ALTER TABLE AuditTaskImpl ALTER COLUMN processSessionId numeric(19,0);
ALTER TABLE ContextMappingInfo ALTER COLUMN KSESSION_ID numeric(19,0);
ALTER TABLE Task ALTER COLUMN processSessionId numeric(19,0);

create table DeploymentStore (
    id bigint identity not null,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit varchar(MAX),
    state int,
    updateDate datetime2,
    primary key (id)
);

alter table DeploymentStore add constraint UK_DeploymentStore_1 unique (DEPLOYMENT_ID);

ALTER TABLE ProcessInstanceLog ADD processInstanceDescription varchar(255);
ALTER TABLE RequestInfo ADD owner varchar(255);
ALTER TABLE Task ADD description varchar(255);
ALTER TABLE Task ADD name varchar(255);
ALTER TABLE Task ADD subject varchar(255);

-- update all tasks with its name, subject and description
update task t set name = (select shorttext from I18NText where task_names_id = t.id);
update task t set subject = (select shorttext from I18NText where task_subjects_id = t.id);
update task t set description = (select shorttext from I18NText where task_descriptions_id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;
