/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.store;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentSynchronizer
implements DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentSynchronizer.class);
    public static final String DEPLOY_SYNC_INTERVAL = System.getProperty("org.jbpm.deploy.sync.int", "3");
    public static final boolean DEPLOY_SYNC_ENABLED = Boolean.parseBoolean(System.getProperty("org.jbpm.deploy.sync.enabled", "true"));
    private final Map<String, DeploymentUnit> entries = new ConcurrentHashMap<String, DeploymentUnit>();
    private DeploymentStore deploymentStore;
    private DeploymentService deploymentService;
    private Date lastSync = null;
    protected Class<?> targetExceptionClass;

    public DeploymentSynchronizer() {
        String clazz = System.getProperty("org.kie.constviol.exclass", "org.hibernate.exception.ConstraintViolationException");
        try {
            this.targetExceptionClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error("Optimistic locking exception class not found {}", (Object)clazz, (Object)e);
        }
    }

    public boolean isActive() {
        return true;
    }

    public void setDeploymentStore(DeploymentStore deploymentStore) {
        this.deploymentStore = deploymentStore;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        ((ListenerSupport)this.deploymentService).addListener((DeploymentEventListener)this);
    }

    public synchronized void synchronize() {
        try {
            DeployedUnit deployed;
            HashSet<DeploymentUnit> enabledSet = new HashSet();
            HashSet<DeploymentUnit> disabledSet = new HashSet<DeploymentUnit>();
            HashSet<DeploymentUnit> activatedSet = new HashSet<DeploymentUnit>();
            HashSet<DeploymentUnit> deactivatedSet = new HashSet();
            if (this.lastSync == null) {
                enabledSet = this.deploymentStore.getEnabledDeploymentUnits();
                deactivatedSet = this.deploymentStore.getDeactivatedDeploymentUnits();
            } else {
                this.deploymentStore.getDeploymentUnitsByDate(this.lastSync, enabledSet, disabledSet, activatedSet, deactivatedSet);
            }
            logger.debug("About to synchronize deployment units, found new enabled {}, found new disabled {}", enabledSet, disabledSet);
            if (enabledSet != null) {
                for (DeploymentUnit unit : enabledSet) {
                    if (this.entries.containsKey(unit.getIdentifier()) || this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) continue;
                    try {
                        logger.debug("New deployment unit to be deployed {}", (Object)unit);
                        this.entries.put(unit.getIdentifier(), unit);
                        this.deploymentService.deploy(unit);
                    }
                    catch (Exception e) {
                        this.entries.remove(unit.getIdentifier());
                        logger.warn("Deployment unit {} failed to deploy: {}", (Object)unit.getIdentifier(), (Object)e.getMessage());
                    }
                }
            }
            if (disabledSet != null) {
                for (DeploymentUnit unit : disabledSet) {
                    if (!this.entries.containsKey(unit.getIdentifier()) || this.deploymentService.getDeployedUnit(unit.getIdentifier()) == null) continue;
                    try {
                        logger.debug("Existing deployment unit {} to be undeployed", (Object)unit.getIdentifier());
                        this.entries.remove(unit.getIdentifier());
                        this.deploymentService.undeploy(unit);
                    }
                    catch (Exception e) {
                        logger.warn("Deployment unit {} failed to undeploy: {}", new Object[]{unit.getIdentifier(), e.getMessage(), e});
                        this.entries.put(unit.getIdentifier(), unit);
                        this.deploymentStore.markDeploymentUnitAsObsolete(unit);
                    }
                }
            }
            logger.debug("About to synchronize deployment units, found new activated {}, found new deactivated {}", activatedSet, deactivatedSet);
            if (activatedSet != null) {
                for (DeploymentUnit unit : activatedSet) {
                    deployed = this.deploymentService.getDeployedUnit(unit.getIdentifier());
                    if (deployed == null || deployed.isActive()) continue;
                    this.deploymentService.activate(unit.getIdentifier());
                }
            }
            if (deactivatedSet != null) {
                for (DeploymentUnit unit : deactivatedSet) {
                    deployed = this.deploymentService.getDeployedUnit(unit.getIdentifier());
                    if (deployed == null || !deployed.isActive()) continue;
                    this.deploymentService.deactivate(unit.getIdentifier());
                }
            }
        }
        catch (Throwable e) {
            logger.error("Error while synchronizing deployments: {}", (Object)e.getMessage(), (Object)e);
        }
        this.lastSync = new Date();
    }

    public void onDeploy(DeploymentEvent event) {
        if (event == null || event.getDeployedUnit() == null) {
            return;
        }
        DeploymentUnit unit = event.getDeployedUnit().getDeploymentUnit();
        if (!this.entries.containsKey(unit.getIdentifier())) {
            try {
                this.deploymentStore.enableDeploymentUnit(unit);
                this.entries.put(unit.getIdentifier(), unit);
                logger.info("Deployment unit {} stored successfully", (Object)unit.getIdentifier());
            }
            catch (Exception e) {
                if (this.isCausedByConstraintViolation(e)) {
                    logger.info("Deployment {} already stored in deployment store", (Object)unit);
                }
                logger.error("Unable to store deployment {} in deployment store due to {}", (Object)unit, (Object)e.getMessage());
            }
        }
    }

    public void onUnDeploy(DeploymentEvent event) {
        if (event != null && event.getDeployedUnit() != null) {
            DeploymentUnit unit = event.getDeployedUnit().getDeploymentUnit();
            this.deploymentStore.disableDeploymentUnit(unit);
            this.entries.remove(unit.getIdentifier());
            logger.info("Deployment unit {} removed successfully", (Object)unit.getIdentifier());
        }
    }

    public void onActivate(DeploymentEvent event) {
        if (event != null && event.getDeployedUnit() != null) {
            DeploymentUnit unit = event.getDeployedUnit().getDeploymentUnit();
            this.deploymentStore.activateDeploymentUnit(unit);
            logger.info("Deployment unit {} activated successfully", (Object)unit.getIdentifier());
        }
    }

    public void onDeactivate(DeploymentEvent event) {
        if (event != null && event.getDeployedUnit() != null) {
            DeploymentUnit unit = event.getDeployedUnit().getDeploymentUnit();
            this.deploymentStore.deactivateDeploymentUnit(unit);
            logger.info("Deployment unit {} deactivated successfully", (Object)unit.getIdentifier());
        }
    }

    protected boolean isCausedByConstraintViolation(Throwable throwable) {
        if (this.targetExceptionClass == null) {
            return false;
        }
        while (throwable != null) {
            if (this.targetExceptionClass.isAssignableFrom(throwable.getClass()) || SQLIntegrityConstraintViolationException.class.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

