/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessGetInformationHandler
extends ProcessHandler {
    private ProcessDescriptionRepository repository;
    private BPMN2DataServiceSemanticModule module;

    public ProcessGetInformationHandler() {
    }

    public ProcessGetInformationHandler(BPMN2DataServiceSemanticModule module) {
        this.module = module;
        this.repository = module.getRepo();
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        RuleFlowProcess process = (RuleFlowProcess)super.start(uri, localName, attrs, parser);
        ProcessDescRepoHelper value = new ProcessDescRepoHelper();
        ProcessAssetDesc definition = new ProcessAssetDesc(process.getId(), process.getName(), process.getVersion(), process.getPackageName(), process.getType(), process.getKnowledgeType().name(), process.getNamespace(), "");
        value.setProcess(definition);
        this.repository.addProcessDescription(definition.getId(), value);
        this.module.getRepoHelper().setProcess(value.getProcess());
        return process;
    }

    public void setRepository(ProcessDescriptionRepository repository) {
        this.repository = repository;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        this.module.getRepoHelper().clear();
        return super.end(uri, localName, parser);
    }
}

