/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.RequeueAware;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ErrorInfo;
import org.kie.internal.executor.api.Executor;
import org.kie.internal.executor.api.ExecutorAdminService;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.executor.api.RequestInfo;
import org.kie.internal.executor.api.STATUS;
import org.kie.internal.query.QueryContext;

public class ExecutorServiceImpl
implements ExecutorService,
RequeueAware {
    private TimeUnit timeunit = TimeUnit.valueOf(System.getProperty("org.kie.executor.timeunit", "SECONDS"));
    private long maxRunningTime = Long.parseLong(System.getProperty("org.kie.executor.running.max", "600"));
    private Executor executor;
    private boolean executorStarted = false;
    private ExecutorQueryService queryService;
    private ExecutorAdminService adminService;

    public ExecutorServiceImpl(Executor executor) {
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public ExecutorQueryService getQueryService() {
        return this.queryService;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public ExecutorAdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(ExecutorAdminService adminService) {
        this.adminService = adminService;
    }

    public List<RequestInfo> getRequestsByBusinessKey(String businessKey, QueryContext queryContext) {
        return this.queryService.getRequestByBusinessKey(businessKey, queryContext);
    }

    public List<RequestInfo> getRequestsByCommand(String command, QueryContext queryContext) {
        return this.queryService.getRequestByCommand(command, queryContext);
    }

    public List<RequestInfo> getQueuedRequests(QueryContext queryContext) {
        return this.queryService.getQueuedRequests(queryContext);
    }

    public List<RequestInfo> getCompletedRequests(QueryContext queryContext) {
        return this.queryService.getCompletedRequests(queryContext);
    }

    public List<RequestInfo> getInErrorRequests(QueryContext queryContext) {
        return this.queryService.getInErrorRequests(queryContext);
    }

    public List<RequestInfo> getCancelledRequests(QueryContext queryContext) {
        return this.queryService.getCancelledRequests(queryContext);
    }

    public List<ErrorInfo> getAllErrors(QueryContext queryContext) {
        return this.queryService.getAllErrors(queryContext);
    }

    public List<RequestInfo> getAllRequests(QueryContext queryContext) {
        return this.queryService.getAllRequests(queryContext);
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses, QueryContext queryContext) {
        return this.queryService.getRequestsByStatus(statuses, queryContext);
    }

    public List<RequestInfo> getPendingRequests(QueryContext queryContext) {
        return this.queryService.getPendingRequests(queryContext);
    }

    public List<RequestInfo> getRunningRequests(QueryContext queryContext) {
        return this.queryService.getRunningRequests(queryContext);
    }

    public List<RequestInfo> getFutureQueuedRequests(QueryContext queryContext) {
        return this.queryService.getFutureQueuedRequests(queryContext);
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        return this.queryService.getFutureQueuedRequests();
    }

    public List<RequestInfo> getQueuedRequests() {
        return this.queryService.getQueuedRequests();
    }

    public List<RequestInfo> getCompletedRequests() {
        return this.queryService.getCompletedRequests();
    }

    public List<RequestInfo> getInErrorRequests() {
        return this.queryService.getInErrorRequests();
    }

    public List<RequestInfo> getCancelledRequests() {
        return this.queryService.getCancelledRequests();
    }

    public List<ErrorInfo> getAllErrors() {
        return this.queryService.getAllErrors();
    }

    public List<RequestInfo> getAllRequests() {
        return this.queryService.getAllRequests();
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return this.queryService.getRequestsByStatus(statuses);
    }

    public int clearAllRequests() {
        return this.adminService.clearAllRequests();
    }

    public int clearAllErrors() {
        return this.adminService.clearAllErrors();
    }

    public Long scheduleRequest(String commandName, CommandContext ctx) {
        return this.executor.scheduleRequest(commandName, ctx);
    }

    public void cancelRequest(Long requestId) {
        this.executor.cancelRequest(requestId);
    }

    public void init() {
        if (!this.executorStarted) {
            if (this.maxRunningTime > -1L) {
                this.requeue(this.maxRunningTime);
            }
            this.executor.init();
            this.executorStarted = true;
        }
    }

    public void destroy() {
        if (this.executorStarted) {
            ExecutorServiceFactory.resetExecutorService(this);
            this.executorStarted = false;
            this.executor.destroy();
        }
    }

    public boolean isActive() {
        return this.executorStarted;
    }

    public int getInterval() {
        return this.executor.getInterval();
    }

    public void setInterval(int waitTime) {
        this.executor.setInterval(waitTime);
    }

    public int getRetries() {
        return this.executor.getRetries();
    }

    public void setRetries(int defaultNroOfRetries) {
        this.executor.setRetries(defaultNroOfRetries);
    }

    public int getThreadPoolSize() {
        return this.executor.getThreadPoolSize();
    }

    public void setThreadPoolSize(int nroOfThreads) {
        this.executor.setThreadPoolSize(nroOfThreads);
    }

    public TimeUnit getTimeunit() {
        return this.executor.getTimeunit();
    }

    public void setTimeunit(TimeUnit timeunit) {
        this.executor.setTimeunit(timeunit);
    }

    public List<RequestInfo> getPendingRequests() {
        return this.queryService.getPendingRequests();
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        return this.queryService.getPendingRequestById(id);
    }

    public Long scheduleRequest(String commandId, Date date, CommandContext ctx) {
        return this.executor.scheduleRequest(commandId, date, ctx);
    }

    public List<RequestInfo> getRunningRequests() {
        return this.queryService.getRunningRequests();
    }

    public RequestInfo getRequestById(Long requestId) {
        return this.queryService.getRequestById(requestId);
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        return this.queryService.getErrorsByRequestId(requestId);
    }

    public List<RequestInfo> getRequestsByBusinessKey(String businessKey) {
        return this.queryService.getRequestByBusinessKey(businessKey);
    }

    @Override
    public void requeue(Long olderThan) {
        if (this.adminService instanceof RequeueAware) {
            if (olderThan == null) {
                olderThan = this.maxRunningTime;
            }
            ((RequeueAware)this.adminService).requeue(this.timeunit.convert(olderThan, TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void requeueById(Long requestId) {
        if (this.adminService instanceof RequeueAware) {
            ((RequeueAware)this.adminService).requeueById(requestId);
        }
    }
}

