/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.commands.FindObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.internal.command.Context;
import org.kie.internal.executor.api.ErrorInfo;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.executor.api.STATUS;
import org.kie.internal.query.QueryContext;

public class ExecutorQueryServiceImpl
implements ExecutorQueryService {
    private CommandService commandService;

    public ExecutorQueryServiceImpl(boolean active) {
        QueryManager.get().addNamedQueries("META-INF/Executor-orm.xml");
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRequestByBusinessKey(String businessKey, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessKey", businessKey);
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByBusinessKey", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRequestByCommand(String command, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByCommand", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getQueuedRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("QueuedRequests", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getCompletedRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("CompletedRequests", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getInErrorRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("InErrorRequests", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getCancelledRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("CancelledRequests", params));
    }

    public List<ErrorInfo> getAllErrors(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetAllErrors", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getAllRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetAllRequests", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRunningRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("RunningRequests", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getFutureQueuedRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        params.put("now", new Date());
        return (List)this.commandService.execute((Command)new QueryNameCommand("FutureQueuedRequests", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRequestsByStatus(List<STATUS> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        params.put("statuses", statuses);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByStatus", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getPendingRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        params.put("now", new Date());
        return (List)this.commandService.execute((Command)new QueryNameCommand("PendingRequests", params));
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    public List<org.kie.internal.executor.api.RequestInfo> getPendingRequests() {
        return this.getPendingRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getPendingRequestById(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", id);
        return (List)this.commandService.execute((Command)new QueryNameCommand("PendingRequestById", params));
    }

    public org.kie.internal.executor.api.RequestInfo getRequestById(Long id) {
        return (org.kie.internal.executor.api.RequestInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, RequestInfo.class));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRunningRequests() {
        return this.getRunningRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getQueuedRequests() {
        return this.getQueuedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getFutureQueuedRequests() {
        return this.getFutureQueuedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getCompletedRequests() {
        return this.getCompletedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getInErrorRequests() {
        return this.getInErrorRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getCancelledRequests() {
        return this.getCancelledRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<ErrorInfo> getAllErrors() {
        return this.getAllErrors(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", requestId);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetErrorsByRequestId", params));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getAllRequests() {
        return this.getAllRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return this.getRequestsByStatus(statuses, new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.internal.executor.api.RequestInfo> getRequestByBusinessKey(String businessKey) {
        return this.getRequestByBusinessKey(businessKey, new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public org.kie.internal.executor.api.RequestInfo getRequestForProcessing() {
        org.kie.internal.executor.api.RequestInfo request = (org.kie.internal.executor.api.RequestInfo)this.commandService.execute((Command)new LockAndUpdateRequestInfoCommand());
        return request;
    }

    private class LockAndUpdateRequestInfoCommand
    implements GenericCommand<org.kie.internal.executor.api.RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;

        private LockAndUpdateRequestInfoCommand() {
        }

        public org.kie.internal.executor.api.RequestInfo execute(Context context) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("now", new Date());
            params.put("firstResult", 0);
            params.put("maxResults", 1);
            params.put("owner", ExecutorService.EXECUTOR_ID);
            org.kie.internal.executor.api.RequestInfo request = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                request = (org.kie.internal.executor.api.RequestInfo)ctx.queryAndLockWithParametersInTransaction("PendingRequestsForProcessing", params, true, org.kie.internal.executor.api.RequestInfo.class);
                if (request != null) {
                    request.setStatus(STATUS.RUNNING);
                    ((RequestInfo)request).setTime(new Date());
                    ctx.merge((Object)request);
                }
            }
            catch (NoResultException e) {
                // empty catch block
            }
            return request;
        }
    }
}

