/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.impl;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.ejb.TaskServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBRemote;
import org.jbpm.services.ejb.impl.identity.EJBContextIdentityProvider;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.task.TaskService;
import org.kie.internal.identity.IdentityProvider;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@Lock(value=LockType.READ)
public class RuntimeDataServiceEJBImpl
extends RuntimeDataServiceImpl
implements DeploymentEventListener,
RuntimeDataService,
RuntimeDataServiceEJBLocal,
RuntimeDataServiceEJBRemote {
    @Inject
    private Instance<IdentityProvider> identityProvider;
    @Resource
    private EJBContext context;

    @PostConstruct
    public void configure() {
        if (this.identityProvider.isUnsatisfied()) {
            this.setIdentityProvider(new EJBContextIdentityProvider(this.context));
        } else {
            this.setIdentityProvider((IdentityProvider)this.identityProvider.get());
        }
    }

    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    public void setCommandService(TransactionalCommandService commandService) {
        super.setCommandService(commandService);
    }

    @EJB(beanInterface=TaskServiceEJBLocal.class)
    public void setTaskService(TaskService taskService) {
        super.setTaskService(taskService);
    }

    @Lock(value=LockType.WRITE)
    public void onDeploy(DeploymentEvent event) {
        super.onDeploy(event);
    }

    @Lock(value=LockType.WRITE)
    public void onUnDeploy(DeploymentEvent event) {
        super.onUnDeploy(event);
    }

    @Lock(value=LockType.WRITE)
    public void onActivate(DeploymentEvent event) {
        super.onActivate(event);
    }

    @Lock(value=LockType.WRITE)
    public void onDeactivate(DeploymentEvent event) {
        super.onDeactivate(event);
    }
}

