/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.cdi.CDIUtils;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.kie.internal.executor.api.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequeueRunningJobsCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(RequeueRunningJobsCommand.class);

    public ExecutionResults execute(CommandContext ctx) {
        BeanManager manager = CDIUtils.lookUpBeanManager(ctx);
        Long olderThan = (Long)ctx.getData("MaxRunningTime");
        Long requestId = (Long)ctx.getData("RequestId");
        try {
            ExecutorService executorService = CDIUtils.createBean(ExecutorService.class, manager, new Annotation[0]);
            if (executorService instanceof RequeueAware) {
                if (requestId != null) {
                    logger.info("Requeue jobs by id {}", (Object)requestId);
                    ((RequeueAware)executorService).requeueById(requestId);
                } else {
                    logger.info("Requeue jobs older than {}", (Object)olderThan);
                    ((RequeueAware)executorService).requeue(olderThan);
                }
            } else {
                logger.info("Executor Service is not capable of jobs requeue");
            }
        }
        catch (Exception e) {
            logger.error("Error while creating CDI bean from jbpm executor", (Throwable)e);
        }
        logger.info("Command executed on executor with data {}", (Object)ctx.getData());
        ExecutionResults executionResults = new ExecutionResults();
        return executionResults;
    }
}

