/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.drools.core.time.JobHandle;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.services.ejb.timer.EjbGlobalJobHandle;
import org.jbpm.services.ejb.timer.EjbTimerJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@Lock(value=LockType.READ)
public class EJBTimerScheduler {
    private static final Logger logger = LoggerFactory.getLogger(EJBTimerScheduler.class);
    private static final Integer OVERDUE_WAIT_TIME = Integer.parseInt(System.getProperty("org.jbpm.overdue.timer.wait", "10000"));
    @Resource
    private TimerService timerService;

    @Timeout
    public void executeTimerJob(Timer timer) {
        EjbTimerJob timerJob = (EjbTimerJob)timer.getInfo();
        logger.debug("About to execute timer for job {}", (Object)timerJob);
        TimerJobInstance timerJobInstance = timerJob.getTimerJobInstance();
        String timerServiceId = ((EjbGlobalJobHandle)timerJobInstance.getJobHandle()).getDeploymentId();
        long time = 0L;
        while (TimerServiceRegistry.getInstance().get(timerServiceId) == null) {
            logger.debug("waiting for timer service to be available, elapsed time {} ms", (Object)time);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((time += 500L) <= (long)OVERDUE_WAIT_TIME.intValue()) continue;
            logger.debug("No timer service found after waiting {} ms", (Object)time);
            break;
        }
        try {
            ((Callable)timerJobInstance).call();
        }
        catch (Exception e) {
            logger.warn("Execution of time failed due to {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        TimerConfig config = new TimerConfig((Serializable)new EjbTimerJob(timerJobInstance), true);
        Date expirationTime = timerJobInstance.getTrigger().nextFireTime();
        if (expirationTime != null) {
            this.timerService.createSingleActionTimer(expirationTime, config);
            logger.debug("Timer scheduled {} on {} scheduler service", (Object)timerJobInstance);
        } else {
            logger.info("Timer that was to be scheduled has already expired");
        }
    }

    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        EjbGlobalJobHandle ejbHandle = (EjbGlobalJobHandle)jobHandle;
        for (Timer timer : this.timerService.getTimers()) {
            EjbTimerJob job;
            EjbGlobalJobHandle handle;
            Serializable info = timer.getInfo();
            if (!(info instanceof EjbTimerJob) || !(handle = (EjbGlobalJobHandle)(job = (EjbTimerJob)info).getTimerJobInstance().getJobHandle()).getUuid().equals(ejbHandle.getUuid())) continue;
            logger.debug("Job handle {} does match timer", (Object)jobHandle);
            return true;
        }
        logger.debug("Job handle {} is not valid on {} scheduler service", (Object)jobHandle, (Object)this);
        return false;
    }

    public boolean removeJob(JobHandle jobHandle) {
        EjbGlobalJobHandle ejbHandle = (EjbGlobalJobHandle)jobHandle;
        for (Timer timer : this.timerService.getTimers()) {
            EjbTimerJob job;
            EjbGlobalJobHandle handle;
            Serializable info = timer.getInfo();
            if (!(info instanceof EjbTimerJob) || !(handle = (EjbGlobalJobHandle)(job = (EjbTimerJob)info).getTimerJobInstance().getJobHandle()).getUuid().equals(ejbHandle.getUuid())) continue;
            logger.debug("Job handle {} does match timer and is going to be canceled", (Object)jobHandle);
            timer.cancel();
            return true;
        }
        logger.debug("Job handle {} does not match any timer on {} scheduler service", (Object)jobHandle, (Object)this);
        return false;
    }

    public TimerJobInstance getTimerByName(String jobName) {
        for (Timer timer : this.timerService.getTimers()) {
            EjbTimerJob job;
            EjbGlobalJobHandle handle;
            Serializable info = timer.getInfo();
            if (!(info instanceof EjbTimerJob) || !(handle = (EjbGlobalJobHandle)(job = (EjbTimerJob)info).getTimerJobInstance().getJobHandle()).getUuid().equals(jobName)) continue;
            logger.debug("Job  {} does match timer and is going to be returned", (Object)jobName);
            return handle.getTimerJobInstance();
        }
        return null;
    }
}

