/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.query.NodeInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.NodeInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.query.ProcInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.ProcessInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.query.VarInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.VarInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.strategy.PersistenceStrategy;
import org.jbpm.process.audit.strategy.PersistenceStrategyType;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.kie.api.runtime.Environment;
import org.kie.internal.query.QueryAndParameterAppender;
import org.kie.internal.query.QueryModificationService;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.query.data.QueryData;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAAuditLogService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(JPAAuditLogService.class);
    protected PersistenceStrategy persistenceStrategy;
    private String persistenceUnitName = "org.jbpm.persistence.jpa";
    public static String NODE_INSTANCE_LOG_QUERY = "SELECT l FROM NodeInstanceLog l\n";
    public static String VARIABLE_INSTANCE_LOG_QUERY = "SELECT l FROM VariableInstanceLog l\n";
    public static String PROCESS_INSTANCE_LOG_QUERY = "SELECT l FROM ProcessInstanceLog l\n";
    public static String NODE_INSTANCE_LOG_DELETE = "DELETE FROM NodeInstanceLog l\n";
    public static String VARIABLE_INSTANCE_LOG_DELETE = "DELETE FROM VariableInstanceLog l\n";
    public static String PROCESS_INSTANCE_LOG_DELETE = "DELETE FROM ProcessInstanceLog l\n";
    public static Map<String, String> criteriaFields = new ConcurrentHashMap<String, String>();
    public static Map<String, Class<?>> criteriaFieldClasses = new ConcurrentHashMap();

    public JPAAuditLogService() {
        EntityManagerFactory emf = null;
        try {
            emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
        }
        catch (Exception e) {
            logger.info("The '" + this.persistenceUnitName + "' peristence unit is not available, no persistence strategy set for " + this.getClass().getSimpleName());
        }
        if (emf != null) {
            this.persistenceStrategy = new StandaloneJtaStrategy(emf);
        }
    }

    public JPAAuditLogService(Environment env, PersistenceStrategyType type) {
        this.persistenceStrategy = PersistenceStrategyType.getPersistenceStrategy(type, env);
    }

    public JPAAuditLogService(Environment env) {
        EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.persistenceStrategy = emf != null ? new StandaloneJtaStrategy(emf) : new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)this.persistenceUnitName));
    }

    public JPAAuditLogService(EntityManagerFactory emf) {
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
    }

    public JPAAuditLogService(EntityManagerFactory emf, PersistenceStrategyType type) {
        this.persistenceStrategy = PersistenceStrategyType.getPersistenceStrategy(type, emf);
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceStrategy = new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)persistenceUnitName));
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog");
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.end is null");
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId);
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId);
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInstanceLog findProcessInstance(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            ProcessInstanceLog processInstanceLog = (ProcessInstanceLog)em.createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
            return processInstanceLog;
        }
        catch (NoResultException e) {
            ProcessInstanceLog processInstanceLog = null;
            return processInstanceLog;
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    @Override
    public List<ProcessInstanceLog> findSubProcessInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.parentProcessInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId);
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId);
        return this.executeQuery(query, em, NodeInstanceLog.class);
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId);
        return this.executeQuery(query, em, NodeInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByName(String variableId, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND p.end is null ORDER BY v.date");
        query.setParameter("variableId", (Object)variableId);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByNameAndValue(String variableId, String value, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId AND v.value = :value ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND v.value = :value AND p.end is null ORDER BY v.date");
        query.setParameter("variableId", (Object)variableId).setParameter("value", (Object)value);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            List processInstances = em.createQuery("FROM ProcessInstanceLog").getResultList();
            for (ProcessInstanceLog processInstance : processInstances) {
                em.remove((Object)processInstance);
            }
            List nodeInstances = em.createQuery("FROM NodeInstanceLog").getResultList();
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                em.remove((Object)nodeInstance);
            }
            List variableInstances = em.createQuery("FROM VariableInstanceLog").getResultList();
            for (VariableInstanceLog variableInstance : variableInstances) {
                em.remove((Object)variableInstance);
            }
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    public void dispose() {
        this.persistenceStrategy.dispose();
    }

    private EntityManager getEntityManager() {
        return this.persistenceStrategy.getEntityManager();
    }

    private Object joinTransaction(EntityManager em) {
        return this.persistenceStrategy.joinTransaction(em);
    }

    private void closeEntityManager(EntityManager em, Object transaction) {
        this.persistenceStrategy.leaveTransaction(em, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> executeQuery(Query query, EntityManager em, Class<T> type) {
        List result;
        Object newTx = this.joinTransaction(em);
        try {
            result = query.getResultList();
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
        return result;
    }

    @Override
    public NodeInstanceLogQueryBuilder nodeInstanceLogQuery() {
        return new NodeInstLogQueryBuilderImpl(this);
    }

    @Override
    public VariableInstanceLogQueryBuilder variableInstanceLogQuery() {
        return new VarInstLogQueryBuilderImpl(this);
    }

    @Override
    public ProcessInstanceLogQueryBuilder processInstanceLogQuery() {
        return new ProcInstLogQueryBuilderImpl(this);
    }

    @Override
    public ProcessInstanceLogDeleteBuilder processInstanceLogDelete() {
        return new ProcessInstanceLogDeleteBuilderImpl(this);
    }

    @Override
    public NodeInstanceLogDeleteBuilder nodeInstanceLogDelete() {
        return new NodeInstanceLogDeleteBuilderImpl(this);
    }

    @Override
    public VariableInstanceLogDeleteBuilder variableInstanceLogDelete() {
        return new VarInstanceLogDeleteBuilderImpl(this);
    }

    @Override
    public List<org.kie.api.runtime.manager.audit.NodeInstanceLog> queryNodeInstanceLogs(QueryData queryData) {
        List<NodeInstanceLog> results = this.doQuery(queryData, NodeInstanceLog.class);
        return this.convertListToInterfaceList(results, org.kie.api.runtime.manager.audit.NodeInstanceLog.class);
    }

    @Override
    public List<org.kie.api.runtime.manager.audit.VariableInstanceLog> queryVariableInstanceLogs(QueryData queryData) {
        List<VariableInstanceLog> results = this.doQuery(queryData, VariableInstanceLog.class);
        return this.convertListToInterfaceList(results, org.kie.api.runtime.manager.audit.VariableInstanceLog.class);
    }

    @Override
    public List<org.kie.api.runtime.manager.audit.ProcessInstanceLog> queryProcessInstanceLogs(QueryData queryData) {
        List<ProcessInstanceLog> results = this.doQuery(queryData, ProcessInstanceLog.class);
        return this.convertListToInterfaceList(results, org.kie.api.runtime.manager.audit.ProcessInstanceLog.class);
    }

    protected <C, I> List<I> convertListToInterfaceList(List<C> internalResult, Class<I> interfaceType) {
        ArrayList<C> result = new ArrayList<C>(internalResult.size());
        for (C element : internalResult) {
            result.add(element);
        }
        return result;
    }

    protected static void addCriteria(String listId, String fieldName, Class type) {
        criteriaFields.put(listId, fieldName);
        criteriaFieldClasses.put(listId, type);
    }

    public <T> List<T> doQuery(QueryData queryData, Class<T> resultType) {
        String queryBase;
        if (ProcessInstanceLog.class.equals(resultType)) {
            queryBase = PROCESS_INSTANCE_LOG_QUERY;
        } else if (VariableInstanceLog.class.equals(resultType)) {
            queryBase = VARIABLE_INSTANCE_LOG_QUERY;
        } else if (NodeInstanceLog.class.equals(resultType)) {
            queryBase = NODE_INSTANCE_LOG_QUERY;
        } else {
            throw new IllegalStateException("Unsupported result type: " + resultType.getName());
        }
        return this.doQuery(queryBase, queryData, resultType);
    }

    public <T> List<T> doQuery(String queryBase, QueryData queryData, Class<T> resultType) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        String queryString = JPAAuditLogService.createQuery(queryBase, queryData, queryParams);
        logger.debug("QUERY:\n {}", (Object)queryString);
        if (logger.isDebugEnabled()) {
            StringBuilder paramsStr = new StringBuilder("PARAMS:");
            TreeMap<String, Object> orderedParams = new TreeMap<String, Object>(queryParams);
            for (Map.Entry entry : orderedParams.entrySet()) {
                paramsStr.append("\n " + (String)entry.getKey() + " : '" + entry.getValue() + "'");
            }
            logger.debug(paramsStr.toString());
        }
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        Query query = em.createQuery(queryString);
        queryParams.put("firstResult", queryData.getQueryContext().getOffset());
        queryParams.put("maxResults", queryData.getQueryContext().getCount());
        List<T> result = this.queryWithParameters(queryParams, LockModeType.NONE, resultType, query);
        this.closeEntityManager(em, newTx);
        return result;
    }

    public int doDelete(QueryData queryData, Class<?> resultType) {
        String queryBase;
        if (ProcessInstanceLog.class.equals(resultType)) {
            queryBase = PROCESS_INSTANCE_LOG_DELETE;
        } else if (VariableInstanceLog.class.equals(resultType)) {
            queryBase = VARIABLE_INSTANCE_LOG_DELETE;
        } else if (NodeInstanceLog.class.equals(resultType)) {
            queryBase = NODE_INSTANCE_LOG_DELETE;
        } else {
            throw new IllegalStateException("Unsupported entity type: " + resultType.getName());
        }
        return this.doDelete(queryBase, queryData, resultType);
    }

    public int doDelete(String queryBase, QueryData queryData, Class<?> resultType) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        String queryString = JPAAuditLogService.createQuery(queryBase, queryData, queryParams, true);
        logger.debug("DELETE statement:\n {}", (Object)queryString);
        if (logger.isDebugEnabled()) {
            StringBuilder paramsStr = new StringBuilder("PARAMS:");
            TreeMap<String, Object> orderedParams = new TreeMap<String, Object>(queryParams);
            for (Map.Entry entry : orderedParams.entrySet()) {
                paramsStr.append("\n " + (String)entry.getKey() + " : '" + entry.getValue() + "'");
            }
            logger.debug(paramsStr.toString());
        }
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        Query query = em.createQuery(queryString);
        int result = this.executeWithParameters(queryParams, query);
        this.closeEntityManager(em, newTx);
        return result;
    }

    private static String createQuery(String queryBase, QueryData queryData, Map<String, Object> queryParams) {
        return JPAAuditLogService.createQuery(queryBase, queryData, queryParams, false);
    }

    private static String createQuery(String queryBase, QueryData queryData, Map<String, Object> queryParams, boolean skipMetaParams) {
        boolean addWhereClause;
        String listId;
        StringBuilder queryBuilder = new StringBuilder(queryBase);
        QueryAndParameterAppender queryAppender = new QueryAndParameterAppender(queryBuilder, queryParams, true);
        ServiceLoader<QueryModificationService> queryModServiceLdr = ServiceLoader.load(QueryModificationService.class);
        for (QueryModificationService queryModService : queryModServiceLdr) {
            queryModService.addTablesToQuery(queryBuilder, queryData);
        }
        for (QueryModificationService queryModService : queryModServiceLdr) {
            queryModService.addCriteriaToQuery(queryBuilder, queryData, queryAppender);
        }
        boolean addLastCriteria = false;
        ArrayList<Object[]> varValCriteriaList = new ArrayList<Object[]>();
        if (!queryData.unionParametersAreEmpty()) {
            JPAAuditLogService.checkVarValCriteria((List)queryData.getUnionParameters().remove(QueryParameterIdentifiers.VAR_VALUE_ID_LIST), true, false, varValCriteriaList);
            if (queryData.getUnionParameters().remove(QueryParameterIdentifiers.LAST_VARIABLE_LIST) != null) {
                addLastCriteria = true;
            }
            for (Map.Entry paramsEntry : queryData.getUnionParameters().entrySet()) {
                listId = (String)paramsEntry.getKey();
                queryAppender.addQueryParameters((List)paramsEntry.getValue(), listId, criteriaFieldClasses.get(listId), criteriaFields.get(listId), true);
            }
        }
        if (!queryData.intersectParametersAreEmpty()) {
            JPAAuditLogService.checkVarValCriteria((List)queryData.getIntersectParameters().remove(QueryParameterIdentifiers.VAR_VALUE_ID_LIST), false, false, varValCriteriaList);
            if (queryData.getIntersectParameters().remove(QueryParameterIdentifiers.LAST_VARIABLE_LIST) != null) {
                addLastCriteria = true;
            }
            for (Map.Entry paramsEntry : queryData.getIntersectParameters().entrySet()) {
                listId = (String)paramsEntry.getKey();
                queryAppender.addQueryParameters((List)paramsEntry.getValue(), listId, criteriaFieldClasses.get(listId), criteriaFields.get(listId), false);
            }
        }
        if (!queryData.unionRangeParametersAreEmpty()) {
            for (Map.Entry paramsEntry : queryData.getUnionRangeParameters().entrySet()) {
                listId = (String)paramsEntry.getKey();
                queryAppender.addRangeQueryParameters((List)paramsEntry.getValue(), listId, criteriaFieldClasses.get(listId), criteriaFields.get(listId), true);
            }
        }
        if (!queryData.intersectRangeParametersAreEmpty()) {
            for (Map.Entry paramsEntry : queryData.getIntersectRangeParameters().entrySet()) {
                listId = (String)paramsEntry.getKey();
                queryAppender.addRangeQueryParameters((List)paramsEntry.getValue(), listId, criteriaFieldClasses.get(listId), criteriaFields.get(listId), false);
            }
        }
        if (!queryData.unionRegexParametersAreEmpty()) {
            JPAAuditLogService.checkVarValCriteria((List)queryData.getUnionRegexParameters().remove(QueryParameterIdentifiers.VAR_VALUE_ID_LIST), true, true, varValCriteriaList);
            for (Map.Entry paramsEntry : queryData.getUnionRegexParameters().entrySet()) {
                listId = (String)paramsEntry.getKey();
                queryAppender.addRegexQueryParameters((List)paramsEntry.getValue(), listId, criteriaFields.get(listId), true);
            }
        }
        if (!queryData.intersectRegexParametersAreEmpty()) {
            JPAAuditLogService.checkVarValCriteria((List)queryData.getIntersectRegexParameters().remove(QueryParameterIdentifiers.VAR_VALUE_ID_LIST), false, true, varValCriteriaList);
            for (Map.Entry paramsEntry : queryData.getIntersectRegexParameters().entrySet()) {
                listId = (String)paramsEntry.getKey();
                queryAppender.addRegexQueryParameters((List)paramsEntry.getValue(), listId, criteriaFields.get(listId), false);
            }
        }
        if (queryAppender.hasBeenUsed()) {
            queryBuilder.append(")");
        }
        boolean bl = addWhereClause = !queryAppender.hasBeenUsed();
        if (!varValCriteriaList.isEmpty()) {
            JPAAuditLogService.addVarValCriteria(addWhereClause, queryBuilder, queryAppender, "l", varValCriteriaList);
            addWhereClause = false;
        }
        if (addLastCriteria) {
            JPAAuditLogService.addLastInstanceCriteria(addWhereClause, queryBuilder);
        }
        if (!skipMetaParams) {
            JPAAuditLogService.applyMetaCriteria(queryBuilder, queryData);
        }
        return queryBuilder.toString();
    }

    public static void checkVarValCriteria(List<String> varValList, boolean union, boolean regex, List<Object[]> varValCriteriaList) {
        if (varValList == null || varValList.isEmpty()) {
            return;
        }
        for (String varVal : varValList) {
            String[] parts = varVal.split(":", 2);
            String varId = parts[1].substring(0, Integer.parseInt(parts[0]));
            String val = parts[1].substring(Integer.parseInt(parts[0]) + 1);
            int type = (union ? 0 : 1) + (regex ? 2 : 0);
            Object[] varValCrit = new Object[]{type, varId, val};
            varValCriteriaList.add(varValCrit);
        }
    }

    public static void addVarValCriteria(boolean addWhereClause, StringBuilder queryBuilder, QueryAndParameterAppender queryAppender, String tableId, List<Object[]> varValCriteriaList) {
        if (!addWhereClause) {
            queryBuilder.append("\n");
        }
        for (Object[] varValCriteria : varValCriteriaList) {
            String val;
            String andOr = null;
            if (addWhereClause) {
                queryBuilder.append("WHERE");
                addWhereClause = false;
            } else {
                andOr = (Integer)varValCriteria[0] % 2 == 1 ? "AND" : "OR";
                queryBuilder.append(andOr);
            }
            String varIdQueryParamName = queryAppender.generateParamName();
            queryAppender.addNamedQueryParam(varIdQueryParamName, varValCriteria[1]);
            queryBuilder.append(" ( ").append(tableId).append(".variableId = :").append(varIdQueryParamName).append(" ");
            queryBuilder.append("AND ").append(tableId).append(".value ");
            String valQueryParamName = queryAppender.generateParamName();
            if ((Integer)varValCriteria[0] >= 2) {
                val = ((String)varValCriteria[2]).replace('*', '%').replace('.', '_');
                queryBuilder.append("like :").append(valQueryParamName);
            } else {
                val = (String)varValCriteria[2];
                queryBuilder.append("= :").append(valQueryParamName);
            }
            queryBuilder.append(" ) ");
            queryAppender.addNamedQueryParam(valQueryParamName, (Object)val);
        }
    }

    private static void addLastInstanceCriteria(boolean whereAnd, StringBuilder queryBuilder) {
        queryBuilder.append("\n").append(whereAnd ? "WHERE" : "AND").append(" (l.id IN (SELECT MAX(ll.id) FROM VariableInstanceLog ll ").append("GROUP BY ll.variableId, ll.processInstanceId))");
    }

    private static void applyMetaCriteria(StringBuilder queryBuilder, QueryData queryData) {
        queryBuilder.append(" \n ORDER by ").append(JPAAuditLogService.adaptOrderBy(queryData.getQueryContext().getOrderBy()));
        Boolean ascending = queryData.getQueryContext().isAscending();
        if (ascending == null || ascending.booleanValue()) {
            queryBuilder.append(" ").append("ASC");
        } else {
            queryBuilder.append(" ").append("DESC");
        }
    }

    private static String adaptOrderBy(String orderBy) {
        if ("processInstanceId".equals(orderBy)) {
            return "l.processInstanceId";
        }
        if ("processId".equals(orderBy)) {
            return "l.processId";
        }
        if (orderBy == null) {
            return "l.id";
        }
        throw new IllegalArgumentException("Unknown order by parameter: '" + orderBy + "'");
    }

    private void applyMetaQueryParameters(Map<String, Object> params, Query query) {
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                Object paramVal = params.get(name);
                if (paramVal == null) continue;
                if ("firstResult".equals(name)) {
                    if ((Integer)paramVal <= 0) continue;
                    query.setFirstResult(((Integer)params.get(name)).intValue());
                    continue;
                }
                if ("maxResults".equals(name)) {
                    if ((Integer)paramVal <= 0) continue;
                    query.setMaxResults(((Integer)params.get(name)).intValue());
                    continue;
                }
                if ("flushMode".equals(name)) {
                    query.setFlushMode(FlushModeType.valueOf((String)((String)params.get(name))));
                    continue;
                }
                if ("orderType".equals(name) || "orderby".equals(name) || "filter".equals(name)) continue;
                query.setParameter(name, params.get(name));
            }
        }
    }

    private <T> List<T> queryWithParameters(Map<String, Object> params, LockModeType lockMode, Class<T> clazz, Query query) {
        if (lockMode != null) {
            query.setLockMode(lockMode);
        }
        this.applyMetaQueryParameters(params, query);
        return query.getResultList();
    }

    private int executeWithParameters(Map<String, Object> params, Query query) {
        this.applyMetaQueryParameters(params, query);
        return query.executeUpdate();
    }

    static {
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "l.processInstanceId", Long.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_ID_LIST, "l.processId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "l.workItemId", Long.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.EXTERNAL_ID_LIST, "l.externalId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.START_DATE_LIST, "l.start", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.DURATION_LIST, "l.duration", Long.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.END_DATE_LIST, "l.end", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.IDENTITY_LIST, "l.identity", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_NAME_LIST, "l.processName", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_VERSION_LIST, "l.processVersion", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST, "l.status", Integer.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.OUTCOME_LIST, "l.outcome", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_ID_LIST, "l.nodeId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_INSTANCE_ID_LIST, "l.nodeInstanceId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_NAME_LIST, "l.nodeName", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_TYPE_LIST, "l.nodeType", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.DATE_LIST, "l.date", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.OLD_VALUE_LIST, "l.oldValue", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.VALUE_LIST, "l.value", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.VARIABLE_ID_LIST, "l.variableId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.VARIABLE_INSTANCE_ID_LIST, "l.variableInstanceId", String.class);
    }
}

