/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.JaxbAttachment;
import org.jbpm.services.task.impl.model.xml.JaxbComment;
import org.jbpm.services.task.impl.model.xml.JaxbDeadlines;
import org.jbpm.services.task.impl.model.xml.JaxbI18NText;
import org.jbpm.services.task.impl.model.xml.JaxbPeopleAssignments;
import org.jbpm.services.task.impl.model.xml.JaxbTaskData;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Delegation;
import org.kie.internal.task.api.model.InternalAttachment;
import org.kie.internal.task.api.model.InternalComment;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="task")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"archived", "deadlines"})
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbTask
implements InternalTask {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="int")
    private Integer priority;
    @XmlElement
    @XmlSchemaType(name="int")
    private Integer version;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean archived;
    @XmlElement(name="task-type")
    @XmlSchemaType(name="string")
    private String taskType;
    @XmlElement
    @XmlSchemaType(name="string")
    private String name;
    @XmlElement
    @XmlSchemaType(name="string")
    private String subject;
    @XmlElement
    @XmlSchemaType(name="string")
    private String description;
    @XmlElement
    private List<JaxbI18NText> names;
    @XmlElement
    private List<JaxbI18NText> subjects;
    @XmlElement
    private List<JaxbI18NText> descriptions;
    @XmlElement(name="people-assignments")
    private JaxbPeopleAssignments peopleAssignments;
    @XmlElement
    private SubTasksStrategy subTasksStrategy;
    @XmlElement
    private JaxbTaskData taskData;
    @XmlElement
    private JaxbDeadlines deadlines = new JaxbDeadlines();
    @XmlElement(name="form-name")
    @XmlSchemaType(name="string")
    private String formName;

    public JaxbTask() {
    }

    public JaxbTask(Task task) {
        this.initialize(task);
    }

    public void initialize(Task task) {
        if (task == null) {
            return;
        }
        this.id = task.getId();
        this.priority = task.getPriority();
        this.subTasksStrategy = ((InternalTask)task).getSubTaskStrategy();
        this.peopleAssignments = new JaxbPeopleAssignments(task.getPeopleAssignments());
        this.names = AbstractJaxbTaskObject.convertListFromInterfaceToJaxbImpl(task.getNames(), I18NText.class, JaxbI18NText.class);
        this.name = ((InternalTask)task).getName();
        this.subjects = AbstractJaxbTaskObject.convertListFromInterfaceToJaxbImpl(task.getSubjects(), I18NText.class, JaxbI18NText.class);
        this.subject = ((InternalTask)task).getSubject();
        this.descriptions = AbstractJaxbTaskObject.convertListFromInterfaceToJaxbImpl(task.getDescriptions(), I18NText.class, JaxbI18NText.class);
        this.description = ((InternalTask)task).getDescription();
        this.taskType = task.getTaskType();
        this.formName = ((InternalTask)task).getFormName();
        this.taskData = new JaxbTaskData(task.getTaskData());
    }

    public Task getTask() {
        List<Attachment> jaxbAttachments;
        I18NText text;
        InternalTask taskImpl = (InternalTask)TaskModelProvider.getFactory().newTask();
        if (this.getId() != null) {
            taskImpl.setId(this.getId().longValue());
        }
        if (this.priority != null) {
            taskImpl.setPriority(this.getPriority());
        }
        JaxbPeopleAssignments jaxbPeopleAssignments = this.peopleAssignments;
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)TaskModelProvider.getFactory().newPeopleAssignments();
        if (jaxbPeopleAssignments.getTaskInitiator() != null) {
            User user = this.createUser(this.getPeopleAssignments().getTaskInitiator().getId());
            peopleAssignments.setTaskInitiator(user);
        }
        List<OrganizationalEntity> potentialOwners = this.copyOrganizationalEntityList(jaxbPeopleAssignments.getPotentialOwners());
        peopleAssignments.setPotentialOwners(potentialOwners);
        List<OrganizationalEntity> businessAdmins = this.copyOrganizationalEntityList(jaxbPeopleAssignments.getBusinessAdministrators());
        peopleAssignments.setBusinessAdministrators(businessAdmins);
        List<OrganizationalEntity> exclOwners = this.copyOrganizationalEntityList(jaxbPeopleAssignments.getExcludedOwners());
        peopleAssignments.setExcludedOwners(exclOwners);
        List<OrganizationalEntity> taskStake = this.copyOrganizationalEntityList(jaxbPeopleAssignments.getTaskStakeholders());
        peopleAssignments.setTaskStakeholders(taskStake);
        List<OrganizationalEntity> recipients = this.copyOrganizationalEntityList(jaxbPeopleAssignments.getRecipients());
        peopleAssignments.setRecipients(recipients);
        taskImpl.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        taskImpl.setSubTaskStrategy(this.getSubTaskStrategy());
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        for (I18NText n : this.getNames()) {
            text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        taskImpl.setNames(names);
        if (this.getName() != null) {
            taskImpl.setName(this.getName());
        } else if (!this.getNames().isEmpty()) {
            taskImpl.setName(this.getNames().get(0).getText());
        }
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        for (I18NText n : this.getSubjects()) {
            text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            subjects.add(text);
        }
        taskImpl.setSubjects(subjects);
        if (this.getSubject() != null) {
            taskImpl.setSubject(this.getSubject());
        } else if (!this.getSubjects().isEmpty()) {
            taskImpl.setSubject(this.getSubjects().get(0).getText());
        }
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        for (I18NText n : this.getDescriptions()) {
            text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            descriptions.add(text);
        }
        taskImpl.setDescriptions(descriptions);
        if (this.getDescription() != null) {
            taskImpl.setDescription(this.getDescription());
        } else if (!this.getDescriptions().isEmpty()) {
            taskImpl.setDescription(this.getDescriptions().get(0).getText());
        }
        taskImpl.setTaskType(this.getTaskType());
        taskImpl.setFormName(this.getFormName());
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        JaxbTaskData jaxbTaskData = (JaxbTaskData)this.getTaskData();
        taskData.setStatus(jaxbTaskData.getStatus());
        taskData.setPreviousStatus(jaxbTaskData.getPreviousStatus());
        taskData.setActualOwner(this.createUser(jaxbTaskData.getActualOwnerId()));
        taskData.setCreatedBy(this.createUser(jaxbTaskData.getCreatedById()));
        taskData.setCreatedOn(jaxbTaskData.getCreatedOn());
        taskData.setActivationTime(jaxbTaskData.getActivationTime());
        taskData.setExpirationTime(jaxbTaskData.getExpirationTime());
        taskData.setSkipable(jaxbTaskData.isSkipable());
        taskData.setWorkItemId(jaxbTaskData.getWorkItemId());
        taskData.setProcessInstanceId(jaxbTaskData.getProcessInstanceId());
        taskData.setDocumentContentId(jaxbTaskData.getDocumentContentId());
        taskData.setDocumentAccessType(jaxbTaskData.getDocumentAccessType());
        taskData.setDocumentType(jaxbTaskData.getDocumentType());
        taskData.setOutputAccessType(jaxbTaskData.getOutputAccessType());
        taskData.setOutputType(jaxbTaskData.getOutputType());
        taskData.setOutputContentId(jaxbTaskData.getOutputContentId());
        taskData.setFaultName(jaxbTaskData.getFaultName());
        taskData.setFaultAccessType(jaxbTaskData.getFaultAccessType());
        taskData.setFaultType(jaxbTaskData.getFaultType());
        taskData.setFaultContentId(jaxbTaskData.getFaultContentId());
        taskData.setParentId(jaxbTaskData.getParentId());
        taskData.setProcessId(jaxbTaskData.getProcessId());
        taskData.setProcessSessionId(jaxbTaskData.getProcessSessionId());
        List<Comment> jaxbComments = jaxbTaskData.getComments();
        if (jaxbComments != null) {
            ArrayList<InternalComment> comments = new ArrayList<InternalComment>(jaxbComments.size());
            for (Comment jaxbComment : jaxbComments) {
                InternalComment comment = (InternalComment)TaskModelProvider.getFactory().newComment();
                if (jaxbComment.getId() != null) {
                    comment.setId(jaxbComment.getId().longValue());
                }
                comment.setAddedAt(jaxbComment.getAddedAt());
                comment.setAddedBy(this.createUser(((JaxbComment)jaxbComment).getAddedById()));
                comment.setText(jaxbComment.getText());
                comments.add(comment);
            }
            taskData.setComments(comments);
        }
        if ((jaxbAttachments = jaxbTaskData.getAttachments()) != null) {
            ArrayList<InternalAttachment> attachments = new ArrayList<InternalAttachment>(jaxbAttachments.size());
            for (Attachment jaxbAttach : jaxbAttachments) {
                InternalAttachment attach = (InternalAttachment)TaskModelProvider.getFactory().newAttachment();
                if (jaxbAttach.getId() != null) {
                    attach.setId(jaxbAttach.getId().longValue());
                }
                attach.setName(jaxbAttach.getName());
                attach.setContentType(jaxbAttach.getContentType());
                attach.setAttachedAt(jaxbAttach.getAttachedAt());
                attach.setAttachedBy(this.createUser(((JaxbAttachment)jaxbAttach).getAttachedById()));
                attach.setSize(jaxbAttach.getSize());
                attach.setAttachmentContentId(jaxbAttach.getAttachmentContentId());
                attachments.add(attach);
            }
            taskData.setAttachments(attachments);
        }
        taskData.setDeploymentId(jaxbTaskData.getDeploymentId());
        taskImpl.setTaskData((TaskData)taskData);
        return taskImpl;
    }

    private User createUser(String userId) {
        if (userId == null) {
            return null;
        }
        return TaskModelProvider.getFactory().newUser(userId);
    }

    private Group createGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        return TaskModelProvider.getFactory().newGroup(groupId);
    }

    private List<OrganizationalEntity> copyOrganizationalEntityList(List<OrganizationalEntity> jaxbOrgEntList) {
        if (jaxbOrgEntList == null) {
            return null;
        }
        ArrayList<OrganizationalEntity> orgEntList = new ArrayList<OrganizationalEntity>(jaxbOrgEntList.size());
        for (OrganizationalEntity jaxbOrgEnt : jaxbOrgEntList) {
            if (jaxbOrgEnt instanceof User) {
                User user = this.createUser(jaxbOrgEnt.getId());
                orgEntList.add((OrganizationalEntity)user);
                continue;
            }
            if (!(jaxbOrgEnt instanceof Group)) continue;
            Group group = this.createGroup(jaxbOrgEnt.getId());
            orgEntList.add((OrganizationalEntity)group);
        }
        return orgEntList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPriority() {
        return AbstractJaxbTaskObject.whenNull(this.priority, 0);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<I18NText> getNames() {
        if (this.names == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.names));
    }

    public void setNames(List<I18NText> names) {
        this.names = AbstractJaxbTaskObject.convertListFromInterfaceToJaxbImpl(names, I18NText.class, JaxbI18NText.class);
    }

    public List<I18NText> getSubjects() {
        if (this.subjects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.subjects));
    }

    public void setSubjects(List<I18NText> subjects) {
        this.subjects = AbstractJaxbTaskObject.convertListFromInterfaceToJaxbImpl(subjects, I18NText.class, JaxbI18NText.class);
    }

    public List<I18NText> getDescriptions() {
        if (this.descriptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.descriptions));
    }

    public void setDescriptions(List<I18NText> descriptions) {
        this.descriptions = AbstractJaxbTaskObject.convertListFromInterfaceToJaxbImpl(descriptions, I18NText.class, JaxbI18NText.class);
    }

    public PeopleAssignments getPeopleAssignments() {
        return this.peopleAssignments;
    }

    public void setPeopleAssignments(PeopleAssignments peopleAssignments) {
        this.peopleAssignments = peopleAssignments instanceof JaxbPeopleAssignments ? (JaxbPeopleAssignments)peopleAssignments : new JaxbPeopleAssignments(peopleAssignments);
    }

    public TaskData getTaskData() {
        return this.taskData;
    }

    public void setTaskData(TaskData taskData) {
        this.taskData = taskData instanceof JaxbTaskData ? (JaxbTaskData)taskData : new JaxbTaskData(taskData);
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Deadlines getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(Deadlines deadlines) {
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getFormName() {
        return this.formName;
    }

    public Boolean isArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public void setVersion(Integer version) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public int getVersion() {
        return (Integer)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public Delegation getDelegation() {
        return (Delegation)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setDelegation(Delegation delegation) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public SubTasksStrategy getSubTaskStrategy() {
        return this.subTasksStrategy;
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        this.subTasksStrategy = subTaskStrategy;
    }

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }
}

