/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit;

import java.util.Date;
import java.util.Map;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPATaskLifeCycleEventListener
implements TaskLifeCycleEventListener {
    private static final Logger logger = LoggerFactory.getLogger(JPATaskLifeCycleEventListener.class);

    public JPATaskLifeCycleEventListener(boolean flag) {
    }

    public void afterTaskStartedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STARTED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ACTIVATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        auditTaskImpl.setDescription(ti.getDescription());
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.CLAIMED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        auditTaskImpl.setDescription(ti.getDescription());
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SKIPPED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        auditTaskImpl.setDescription(ti.getDescription());
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STOPPED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.COMPLETED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FAILED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getProcessId() != null) {
            userId = ti.getTaskData().getProcessId();
        } else if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        AuditTaskImpl auditTaskImpl = new AuditTaskImpl(ti.getId(), ti.getName(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ti.getTaskData().getActualOwner() != null ? ti.getTaskData().getActualOwner().getId() : "", ti.getDescription(), ti.getPriority(), ti.getTaskData().getCreatedBy() != null ? ti.getTaskData().getCreatedBy().getId() : "", ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getDeploymentId(), ti.getTaskData().getParentId());
        persistenceContext.persist((Object)auditTaskImpl);
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ADDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.EXITED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner("");
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskResumedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RESUMED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SUSPENDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FORWARDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.DELEGATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskNominatedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.NOMINATED, userId, new Date()));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    protected AuditTaskImpl getAuditTask(TaskEvent event, TaskPersistenceContext persistenceContext, Task ti) {
        AuditTaskImpl auditTaskImpl = (AuditTaskImpl)persistenceContext.queryWithParametersInTransaction("getAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(AuditTaskImpl.class));
        return auditTaskImpl;
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RELEASED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
        auditTaskImpl.setActualOwner(userId);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof JPATaskLifeCycleEventListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().getName().hashCode();
        return result;
    }

    public void beforeTaskUpdatedEvent(TaskEvent event) {
    }

    public void afterTaskUpdatedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
            return;
        }
        auditTaskImpl.setDescription(ti.getDescription());
        auditTaskImpl.setName(ti.getName());
        auditTaskImpl.setPriority(ti.getPriority());
        auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
        persistenceContext.merge((Object)auditTaskImpl);
    }
}

