/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import org.hibernate.engine.spi.CompositeOwner;

public class CompositeOwnerTracker {
    private String[] names = new String[1];
    private CompositeOwner[] owners = new CompositeOwner[1];
    private int size = 0;

    public void add(String name, CompositeOwner owner) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].equals(name)) continue;
            this.owners[i] = owner;
            return;
        }
        if (this.size >= this.names.length) {
            String[] tmpNames = new String[this.size + 1];
            System.arraycopy(this.names, 0, tmpNames, 0, this.size);
            this.names = tmpNames;
            CompositeOwner[] tmpOwners = new CompositeOwner[this.size + 1];
            System.arraycopy(this.owners, 0, tmpOwners, 0, this.size);
            this.owners = tmpOwners;
        }
        this.names[this.size] = name;
        this.owners[this.size] = owner;
        ++this.size;
    }

    public void callOwner(String fieldName) {
        for (int i = 0; i < this.size; ++i) {
            this.owners[i].$$_hibernate_trackChange(this.names[i] + fieldName);
        }
    }

    public void removeOwner(String name) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].equals(name) || i >= this.size) continue;
            for (int j = i; j < this.size - 1; ++j) {
                this.names[j] = this.names[j + 1];
                this.owners[j] = this.owners[j + 1];
            }
            this.names[this.size - 1] = null;
            this.owners[this.size - 1] = null;
            --this.size;
        }
    }
}

