/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.LeftTupleSetsImpl;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.util.AtomicBitwiseLong;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMemory
extends LinkedList<SegmentMemory>
implements LinkedListNode<SegmentMemory> {
    protected static final Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    private NetworkNode rootNode;
    private NetworkNode tipNode;
    private LinkedList<Memory> nodeMemories;
    private AtomicBitwiseLong linkedNodeMask;
    private AtomicBitwiseLong dirtyNodeMask;
    private long allLinkedMaskTest;
    private List<PathMemory> pathMemories;
    private long segmentPosMaskBit;
    private int pos;
    private volatile LeftTupleSets stagedLeftTuples;
    private boolean active;
    private SegmentMemory previous;
    private SegmentMemory next;
    private transient PathMemory firstDataDrivenPathMemory;

    public SegmentMemory(NetworkNode rootNode) {
        this.rootNode = rootNode;
        this.linkedNodeMask = new AtomicBitwiseLong();
        this.dirtyNodeMask = new AtomicBitwiseLong();
        this.pathMemories = new ArrayList<PathMemory>(1);
        this.nodeMemories = new LinkedList();
        this.stagedLeftTuples = new LeftTupleSetsImpl();
    }

    public NetworkNode getRootNode() {
        return this.rootNode;
    }

    public NetworkNode getTipNode() {
        return this.tipNode;
    }

    public void setTipNode(NetworkNode tipNode) {
        this.tipNode = tipNode;
    }

    public LeftTupleSink getSinkFactory() {
        return (LeftTupleSink)this.rootNode;
    }

    public Memory createNodeMemory(MemoryFactory memoryFactory, InternalWorkingMemory wm) {
        Memory memory = wm.getNodeMemory(memoryFactory);
        this.nodeMemories.add(memory);
        return memory;
    }

    public LinkedList<Memory> getNodeMemories() {
        return this.nodeMemories;
    }

    public long getLinkedNodeMask() {
        return this.linkedNodeMask.get();
    }

    public void setLinkedNodeMask(long linkedNodeMask) {
        this.linkedNodeMask.set(linkedNodeMask);
    }

    public long getDirtyNodeMask() {
        return this.dirtyNodeMask.get();
    }

    public void resetDirtyNodeMask() {
        this.dirtyNodeMask.set(0L);
    }

    public void updateDirtyNodeMask(long mask) {
        this.dirtyNodeMask.getAndBitwiseOr(mask);
    }

    public void updateCleanNodeMask(long mask) {
        this.dirtyNodeMask.getAndBitwiseReset(mask);
    }

    public String getRuleNames() {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.pathMemories.size(); ++i) {
            if (i > 0) {
                sbuilder.append(", ");
            }
            sbuilder.append(this.pathMemories.get(i));
        }
        return sbuilder.toString();
    }

    public void linkNode(long mask, InternalWorkingMemory wm) {
        this.linkedNodeMask.getAndBitwiseOr(mask);
        if (isLogTraceEnabled) {
            log.trace("LinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        this.notifyRuleLinkSegment(wm);
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask.getAndBitwiseOr(mask);
        if (isLogTraceEnabled) {
            log.trace("LinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).linkNodeWithoutRuleNotify(this.segmentPosMaskBit);
            }
        }
    }

    public void notifyRuleLinkSegment(InternalWorkingMemory wm, long mask) {
        this.dirtyNodeMask.getAndBitwiseOr(mask);
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).linkSegment(this.segmentPosMaskBit, wm);
            }
        }
    }

    public void notifyRuleLinkSegment(InternalWorkingMemory wm) {
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).linkSegment(this.segmentPosMaskBit, wm);
            }
        }
    }

    public void unlinkNode(long mask, InternalWorkingMemory wm) {
        boolean linked = this.isSegmentLinked();
        this.linkedNodeMask.getAndBitwiseXor(mask);
        this.dirtyNodeMask.getAndBitwiseOr(mask);
        if (isLogTraceEnabled) {
            log.trace("UnlinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        if (linked && !this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).unlinkedSegment(this.segmentPosMaskBit, wm);
            }
        } else {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                if (!this.pathMemories.get(i).isRuleLinked()) continue;
                this.pathMemories.get(i).doLinkRule(wm);
            }
        }
    }

    public void unlinkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask.getAndBitwiseXor(mask);
        if (isLogTraceEnabled) {
            log.trace("UnlinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public boolean isSegmentLinked() {
        return (this.linkedNodeMask.get() & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public List<PathMemory> getPathMemories() {
        return this.pathMemories;
    }

    public void addPathMemory(PathMemory pathMemory) {
        this.pathMemories.add(pathMemory);
        if (this.firstDataDrivenPathMemory == null && pathMemory.isDataDriven()) {
            this.firstDataDrivenPathMemory = pathMemory;
        }
    }

    public void mergePathMemories(SegmentMemory segmentMemory) {
        this.pathMemories.addAll(segmentMemory.getPathMemories());
        if (this.firstDataDrivenPathMemory == null) {
            this.firstDataDrivenPathMemory = segmentMemory.getFirstDataDrivenPathMemory();
        }
    }

    public void removePathMemory(PathMemory pathMemory) {
        this.pathMemories.remove(pathMemory);
        if (this.firstDataDrivenPathMemory != null && this.firstDataDrivenPathMemory.equals(pathMemory)) {
            this.firstDataDrivenPathMemory = null;
            for (PathMemory pmem : this.pathMemories) {
                if (!pmem.isDataDriven()) continue;
                this.firstDataDrivenPathMemory = pmem;
                break;
            }
        }
    }

    public PathMemory getFirstDataDrivenPathMemory() {
        return this.firstDataDrivenPathMemory;
    }

    public long getSegmentPosMaskBit() {
        return this.segmentPosMaskBit;
    }

    public void setSegmentPosMaskBit(long nodeSegmenMask) {
        this.segmentPosMaskBit = nodeSegmenMask;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean evaluating) {
        this.active = evaluating;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public LeftTupleSets getStagedLeftTuples() {
        return this.stagedLeftTuples;
    }

    public void setStagedTuples(LeftTupleSets stagedTuples) {
        this.stagedLeftTuples = stagedTuples;
    }

    @Override
    public SegmentMemory getNext() {
        return this.next;
    }

    @Override
    public void setNext(SegmentMemory next) {
        this.next = next;
    }

    @Override
    public SegmentMemory getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(SegmentMemory previous) {
        this.previous = previous;
    }

    @Override
    public void nullPrevNext() {
        this.previous = null;
        this.next = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * this.rootNode.getId();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentMemory other = (SegmentMemory)obj;
        return !(this.rootNode == null ? other.rootNode != null : this.rootNode.getId() != other.rootNode.getId());
    }

    public Prototype asPrototype() {
        return new Prototype(this);
    }

    public List<NetworkNode> getNodesInSegment() {
        java.util.LinkedList<NetworkNode> nodes = new java.util.LinkedList<NetworkNode>();
        NetworkNode currentNode = this.tipNode;
        while (currentNode != this.rootNode) {
            nodes.add(0, currentNode);
            currentNode = ((LeftTupleSinkNode)currentNode).getLeftTupleSource();
        }
        nodes.add(0, currentNode);
        return nodes;
    }

    public void reset(Prototype prototype) {
        this.dirtyNodeMask.set(0L);
        this.linkedNodeMask.set(prototype != null ? prototype.linkedNodeMask : 0L);
        this.stagedLeftTuples.resetAll();
    }

    public static class FromMemoryPrototype
    extends MemoryPrototype {
        private final BetaMemoryPrototype betaProto;

        private FromMemoryPrototype(FromNode.FromMemory fromMemory) {
            this.betaProto = new BetaMemoryPrototype(fromMemory.getBetaMemory());
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory fromMemory) {
            this.betaProto.populateMemory(wm, ((FromNode.FromMemory)fromMemory).getBetaMemory());
        }
    }

    public static class AccumulateMemoryPrototype
    extends MemoryPrototype {
        private final BetaMemoryPrototype betaProto;

        private AccumulateMemoryPrototype(AccumulateNode.AccumulateMemory accMemory) {
            this.betaProto = new BetaMemoryPrototype(accMemory.getBetaMemory());
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory accMemory) {
            this.betaProto.populateMemory(wm, ((AccumulateNode.AccumulateMemory)accMemory).getBetaMemory());
        }
    }

    public static class TimerMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        private TimerMemoryPrototype(TimerNode.TimerNodeMemory timerMemory) {
            this.nodePosMaskBit = timerMemory.getNodePosMaskBit();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory mem) {
            TimerNode.TimerNodeMemory tmem = (TimerNode.TimerNodeMemory)mem;
            tmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class QueryMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;
        private final QueryElementNode queryNode;

        private QueryMemoryPrototype(QueryElementNode.QueryElementNodeMemory queryMemory) {
            this.nodePosMaskBit = queryMemory.getNodePosMaskBit();
            this.queryNode = queryMemory.getNode();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory mem) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)mem;
            SegmentMemory querySmem = SegmentUtilities.getQuerySegmentMemory(wm, (LeftTupleSource)qmem.getSegmentMemory().getRootNode(), this.queryNode);
            qmem.setQuerySegmentMemory(querySmem);
            qmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class LiaMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        private LiaMemoryPrototype(LeftInputAdapterNode.LiaNodeMemory liaMemory) {
            this.nodePosMaskBit = liaMemory.getNodePosMaskBit();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory liaMemory) {
            ((LeftInputAdapterNode.LiaNodeMemory)liaMemory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class BetaMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;
        private RightInputAdapterNode riaNode;

        private BetaMemoryPrototype(BetaMemory betaMemory) {
            this.nodePosMaskBit = betaMemory.getNodePosMaskBit();
            if (betaMemory.getRiaRuleMemory() != null) {
                this.riaNode = betaMemory.getRiaRuleMemory().getRightInputAdapterNode();
            }
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory memory) {
            BetaMemory betaMemory = (BetaMemory)memory;
            betaMemory.setNodePosMaskBit(this.nodePosMaskBit);
            if (this.riaNode != null) {
                RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory(this.riaNode);
                betaMemory.setRiaRuleMemory(riaMem.getRiaPathMemory());
            }
        }
    }

    public static abstract class MemoryPrototype {
        public static MemoryPrototype get(Memory memory) {
            if (memory instanceof BetaMemory) {
                return new BetaMemoryPrototype((BetaMemory)memory);
            }
            if (memory instanceof LeftInputAdapterNode.LiaNodeMemory) {
                return new LiaMemoryPrototype((LeftInputAdapterNode.LiaNodeMemory)memory);
            }
            if (memory instanceof QueryElementNode.QueryElementNodeMemory) {
                return new QueryMemoryPrototype((QueryElementNode.QueryElementNodeMemory)memory);
            }
            if (memory instanceof TimerNode.TimerNodeMemory) {
                return new TimerMemoryPrototype((TimerNode.TimerNodeMemory)memory);
            }
            if (memory instanceof AccumulateNode.AccumulateMemory) {
                return new AccumulateMemoryPrototype((AccumulateNode.AccumulateMemory)memory);
            }
            return null;
        }

        public abstract void populateMemory(InternalWorkingMemory var1, Memory var2);
    }

    public static class Prototype {
        private NetworkNode rootNode;
        private NetworkNode tipNode;
        private long linkedNodeMask;
        private long allLinkedMaskTest;
        private long segmentPosMaskBit;
        private int pos;
        private List<MemoryPrototype> memories = new ArrayList<MemoryPrototype>();
        private List<NetworkNode> nodesInSegment;

        private Prototype(SegmentMemory smem) {
            this.rootNode = smem.rootNode;
            this.tipNode = smem.tipNode;
            this.linkedNodeMask = smem.linkedNodeMask.get();
            this.allLinkedMaskTest = smem.allLinkedMaskTest;
            this.segmentPosMaskBit = smem.segmentPosMaskBit;
            this.pos = smem.pos;
            for (Memory mem = (Memory)smem.nodeMemories.getFirst(); mem != null; mem = (Memory)mem.getNext()) {
                this.memories.add(MemoryPrototype.get(mem));
            }
        }

        public SegmentMemory newSegmentMemory(InternalWorkingMemory wm) {
            SegmentMemory smem = new SegmentMemory(this.rootNode);
            smem.tipNode = this.tipNode;
            smem.linkedNodeMask = new AtomicBitwiseLong(this.linkedNodeMask);
            smem.allLinkedMaskTest = this.allLinkedMaskTest;
            smem.segmentPosMaskBit = this.segmentPosMaskBit;
            smem.pos = this.pos;
            int i = 0;
            for (NetworkNode node : this.getNodesInSegment(smem)) {
                MemoryPrototype proto;
                Memory mem = wm.getNodeMemory((MemoryFactory)((Object)node));
                mem.setSegmentMemory(smem);
                smem.getNodeMemories().add(mem);
                if ((proto = this.memories.get(i++)) == null) continue;
                proto.populateMemory(wm, mem);
            }
            return smem;
        }

        private List<NetworkNode> getNodesInSegment(SegmentMemory smem) {
            if (this.nodesInSegment == null) {
                this.nodesInSegment = smem.getNodesInSegment();
            }
            return this.nodesInSegment;
        }
    }
}

