/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.api.AttributesAware;
import org.jbpm.services.api.model.DeploymentUnit;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;

public class KModuleDeploymentUnit
implements DeploymentUnit,
AttributesAware,
Serializable {
    private static final long serialVersionUID = 1L;
    private String artifactId;
    private String groupId;
    private String version;
    private String kbaseName;
    private String ksessionName;
    private RuntimeStrategy strategy = RuntimeStrategy.SINGLETON;
    private MergeMode mergeMode = MergeMode.MERGE_COLLECTIONS;
    private DeploymentDescriptor deploymentDescriptor;
    private boolean deployed = false;
    private boolean strategyUnset = true;
    private Map<String, String> attributes = new HashMap<String, String>();

    public KModuleDeploymentUnit(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public KModuleDeploymentUnit(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        this(groupId, artifactId, version);
        this.kbaseName = kbaseName;
        this.ksessionName = ksessionName;
    }

    public KModuleDeploymentUnit(String groupId, String artifactId, String version, String kbaseName, String ksessionName, String strategy) {
        this(groupId, artifactId, version, kbaseName, ksessionName);
        this.strategy = RuntimeStrategy.valueOf((String)strategy);
        this.strategyUnset = false;
    }

    public String getIdentifier() {
        boolean ksessionFilled;
        String id = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
        boolean kbaseFilled = !StringUtils.isEmpty((CharSequence)this.kbaseName);
        boolean bl = ksessionFilled = !StringUtils.isEmpty((CharSequence)this.ksessionName);
        if (kbaseFilled || ksessionFilled) {
            id = id.concat(":");
            if (kbaseFilled) {
                id = id.concat(this.kbaseName);
            }
            if (ksessionFilled) {
                id = id.concat(":" + this.ksessionName);
            }
        }
        return id;
    }

    public RuntimeStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(RuntimeStrategy strategy) {
        if (this.strategyUnset) {
            this.strategy = strategy;
            this.strategyUnset = false;
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKsessionName() {
        return this.ksessionName;
    }

    public void setKsessionName(String ksessionName) {
        this.ksessionName = ksessionName;
    }

    public String getKbaseName() {
        return this.kbaseName;
    }

    public void setKbaseName(String kbaseName) {
        this.kbaseName = kbaseName;
    }

    public String toString() {
        return this.getIdentifier() + " [strategy=" + this.strategy + "]";
    }

    public MergeMode getMergeMode() {
        if (this.mergeMode == null) {
            this.mergeMode = MergeMode.MERGE_COLLECTIONS;
        }
        return this.mergeMode;
    }

    public void setMergeMode(MergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public void resetStrategy() {
        this.strategyUnset = true;
    }

    @Override
    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    @Override
    public String removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.attributes);
    }
}

