/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.LeftTupleSetsImpl;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNodeLeftTuple;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.AbductiveQuery;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.kie.api.runtime.rule.Variable;

public class QueryElementNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<QueryElementNodeMemory> {
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected QueryElement queryElement;
    private boolean tupleMemoryEnabled;
    protected boolean openQuery;
    private boolean dataDriven;
    private Object[] argsTemplate;

    public QueryElementNode() {
    }

    public QueryElementNode(int id, LeftTupleSource tupleSource, QueryElement queryElement, boolean tupleMemoryEnabled, boolean openQuery, BuildContext context) {
        super(id, context);
        this.setLeftTupleSource(tupleSource);
        this.queryElement = queryElement;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.openQuery = openQuery;
        this.dataDriven = context != null && context.getRule().isDataDriven();
        this.initMasks(context, tupleSource);
        this.initArgsTemplate(context);
    }

    private void initArgsTemplate(BuildContext context) {
        Object[] originalArgs = this.queryElement.getArgTemplate();
        this.argsTemplate = new Object[originalArgs.length];
        for (int i = 0; i < originalArgs.length; ++i) {
            if (originalArgs[i] instanceof Class) {
                try {
                    this.argsTemplate[i] = context.getKnowledgeBase().getRootClassLoader().loadClass(((Class)originalArgs[i]).getName());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.argsTemplate[i] = originalArgs[i];
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.queryElement = (QueryElement)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.openQuery = in.readBoolean();
        this.dataDriven = in.readBoolean();
        this.argsTemplate = (Object[])in.readObject();
        for (int i = 0; i < this.argsTemplate.length; ++i) {
            if (!(this.argsTemplate[i] instanceof Variable)) continue;
            this.argsTemplate[i] = Variable.v;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.queryElement);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.openQuery);
        out.writeBoolean(this.dataDriven);
        out.writeObject(this.argsTemplate);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    @Override
    public short getType() {
        return 165;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    public InternalFactHandle createFactHandle(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        Map map;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = ((ProtobufInputMarshaller.QueryElementContext)map.get((Object)PersisterHelper.createTupleKey((LeftTuple)leftTuple))).handle;
        }
        return _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), null, _handle.getRecency(), null, workingMemory, workingMemory) : workingMemory.getFactHandleFactory().newFactHandle(null, null, workingMemory, workingMemory);
    }

    public DroolsQuery createDroolsQuery(LeftTuple leftTuple, InternalFactHandle handle, StackEntry stackEntry, List<PathMemory> pmems, QueryElementNodeMemory qmem, LeftTupleSets trgLeftTuples, LeftTupleSink sink, InternalWorkingMemory workingMemory) {
        Object object;
        int[] varIndexes;
        int[] declIndexes;
        Object[] args = new Object[this.argsTemplate.length];
        System.arraycopy(this.argsTemplate, 0, args, 0, args.length);
        for (int declIndexe : declIndexes = this.queryElement.getDeclIndexes()) {
            Declaration declr = (Declaration)this.argsTemplate[declIndexe];
            Object tupleObject = leftTuple.get(declr).getObject();
            Object o = tupleObject instanceof DroolsQuery && declr.getExtractor() instanceof ArrayElementReader && ((DroolsQuery)tupleObject).getVariables()[declr.getExtractor().getIndex()] != null ? Variable.v : declr.getValue(workingMemory, tupleObject);
            if (o == null) {
                o = declr.getValue(workingMemory, tupleObject);
            }
            args[declIndexe] = o;
        }
        for (int varIndex : varIndexes = this.queryElement.getVariableIndexes()) {
            if (this.argsTemplate[varIndex] != Variable.v) continue;
            args[varIndex] = Variable.v;
        }
        UnificationNodeViewChangedEventListener collector = this.createCollector(leftTuple, varIndexes, this.tupleMemoryEnabled);
        boolean executeAsOpenQuery = this.openQuery;
        if (executeAsOpenQuery && (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            executeAsOpenQuery = false;
        }
        DroolsQuery queryObject = new DroolsQuery(this.queryElement.getQueryName(), args, collector, executeAsOpenQuery, stackEntry, pmems, trgLeftTuples, qmem, sink);
        collector.setFactHandle(handle);
        handle.setObject(queryObject);
        leftTuple.setObject(handle);
        return queryObject;
    }

    protected UnificationNodeViewChangedEventListener createCollector(LeftTuple leftTuple, int[] varIndexes, boolean tupleMemoryEnabled) {
        return new UnificationNodeViewChangedEventListener(leftTuple, varIndexes, this, tupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new QueryElementNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.openQuery ? 1231 : 1237);
        result = 31 * result + (this.queryElement == null ? 0 : this.queryElement.hashCode());
        result = 31 * result + (this.leftInput == null ? 0 : this.leftInput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryElementNode other = (QueryElementNode)obj;
        if (this.openQuery != other.openQuery) {
            return false;
        }
        if (!this.openQuery && this.dataDriven != other.dataDriven) {
            return false;
        }
        if (this.queryElement == null ? other.queryElement != null : !this.queryElement.equals(other.queryElement)) {
            return false;
        }
        return !(this.leftInput == null ? other.leftInput != null : !this.leftInput.equals(other.leftInput));
    }

    @Override
    public QueryElementNodeMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new QueryElementNodeMemory(this);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        QueryElementNodeLeftTuple peer = new QueryElementNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ", " + this.queryElement.getQueryName() + ")]";
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    public static class QueryElementNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private QueryElementNode node;
        private SegmentMemory smem;
        private SegmentMemory querySegmentMemory;
        private LeftTupleSets resultLeftTuples;
        private long nodePosMaskBit;

        public QueryElementNodeMemory(QueryElementNode node) {
            this.node = node;
            this.resultLeftTuples = new LeftTupleSetsImpl();
        }

        public QueryElementNode getNode() {
            return this.node;
        }

        @Override
        public short getNodeType() {
            return 165;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.smem = smem;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.smem;
        }

        public SegmentMemory getQuerySegmentMemory() {
            return this.querySegmentMemory;
        }

        public void setQuerySegmentMemory(SegmentMemory querySegmentMemory) {
            this.querySegmentMemory = querySegmentMemory;
        }

        public LeftTupleSets getResultLeftTuples() {
            return this.resultLeftTuples;
        }

        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        public void setNodePosMaskBit(long segmentPos) {
            this.nodePosMaskBit = segmentPos;
        }

        public void setNodeDirtyWithoutNotify() {
            this.smem.updateDirtyNodeMask(this.nodePosMaskBit);
        }

        public void setNodeCleanWithoutNotify() {
            this.smem.updateCleanNodeMask(this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.resultLeftTuples.resetAll();
        }
    }

    public static class UnificationNodeViewChangedEventListener
    implements InternalViewChangedEventListener {
        protected LeftTuple leftTuple;
        protected QueryElementNode node;
        protected InternalFactHandle factHandle;
        protected int[] variables;
        protected boolean tupleMemoryEnabled;

        public UnificationNodeViewChangedEventListener(LeftTuple leftTuple, int[] variables, QueryElementNode node, boolean tupleMemoryEnabled) {
            this.leftTuple = leftTuple;
            this.variables = variables;
            this.node = node;
            this.tupleMemoryEnabled = tupleMemoryEnabled;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public void setVariables(int[] variables) {
            this.variables = variables;
        }

        @Override
        public void rowAdded(RuleImpl rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            QueryImpl query = node.getQuery();
            Declaration[] decls = node.getDeclarations();
            DroolsQuery dquery = (DroolsQuery)this.factHandle.getObject();
            Object[] objects = new Object[this.determineResultSize(query, dquery)];
            for (int variable : this.variables) {
                Declaration decl = decls[variable];
                objects[variable] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle resultHandle = this.createQueryResultHandle(context, workingMemory, objects);
            RightTuple rightTuple = this.createResultRightTuple(resultHandle, resultLeftTuple, dquery.isOpen());
            boolean pass = true;
            if (query.isAbductive()) {
                AbductiveQuery aq = (AbductiveQuery)query;
                int numArgs = aq.getAbducibleArgs().length;
                Object[] constructorArgs = new Object[aq.getAbducibleArgs().length];
                for (int j = 0; j < numArgs; ++j) {
                    int k = aq.mapArgToParam(j);
                    if (objects[k] != null) {
                        constructorArgs[j] = objects[k];
                        continue;
                    }
                    if (dquery.getElements()[k] == null) continue;
                    constructorArgs[j] = dquery.getElements()[k];
                }
                Object abduced = aq.abduce(constructorArgs);
                if (abduced != null) {
                    BeliefSet bs;
                    boolean firstAssertion = true;
                    ObjectStore store = workingMemory.getObjectStore();
                    InternalFactHandle handle = store.getHandleForObject(abduced);
                    if (handle != null) {
                        abduced = handle.getObject();
                        firstAssertion = false;
                    } else {
                        handle = ((InternalWorkingMemoryActions)workingMemory).getTruthMaintenanceSystem().insert(abduced, JTMSBeliefSetImpl.MODE.POSITIVE.getId(), query, (RuleTerminalNodeLeftTuple)resultLeftTuple);
                    }
                    BeliefSet beliefSet = bs = handle.getEqualityKey() != null ? handle.getEqualityKey().getBeliefSet() : null;
                    if (bs == null) {
                        abduced = handle.getObject();
                    } else if (!bs.isPositive()) {
                        pass = false;
                    } else if (!firstAssertion) {
                        ((InternalWorkingMemoryActions)workingMemory).getTruthMaintenanceSystem().insert(abduced, JTMSBeliefSetImpl.MODE.POSITIVE.getId(), query, (RuleTerminalNodeLeftTuple)resultLeftTuple);
                    }
                }
                objects[objects.length - 1] = abduced;
            }
            if (pass) {
                LeftTupleSink sink = dquery.getLeftTupleSink();
                LeftTuple childLeftTuple = sink.createLeftTuple(this.leftTuple, rightTuple, sink);
                boolean stagedInsertWasEmpty = dquery.getResultLeftTupleSets().addInsert(childLeftTuple);
                if (stagedInsertWasEmpty) {
                    dquery.getQueryNodeMemory().setNodeDirtyWithoutNotify();
                }
            }
        }

        private int determineResultSize(QueryImpl query, DroolsQuery dquery) {
            int size = dquery.getElements().length;
            if (query.isAbductive() && ((AbductiveQuery)query).isReturnBound()) {
                ++size;
            }
            return size;
        }

        protected RightTuple createResultRightTuple(QueryElementFactHandle resultHandle, LeftTuple resultLeftTuple, boolean open) {
            RightTuple rightTuple = new RightTuple(resultHandle);
            if (open) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setObject(rightTuple);
            }
            rightTuple.setPropagationContext(resultLeftTuple.getPropagationContext());
            return rightTuple;
        }

        protected QueryElementFactHandle createQueryResultHandle(PropagationContext context, InternalWorkingMemory workingMemory, Object[] objects) {
            ProtobufInputMarshaller.QueryElementContext _context;
            Map map;
            ProtobufMessages.FactHandle _handle = null;
            if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.node.getId())) != null && (_context = (ProtobufInputMarshaller.QueryElementContext)map.get(PersisterHelper.createTupleKey(this.leftTuple))) != null) {
                _handle = _context.results.removeFirst();
            }
            return _handle != null ? new QueryElementFactHandle(objects, _handle.getId(), _handle.getRecency()) : new QueryElementFactHandle(objects, workingMemory.getFactHandleFactory().getAtomicId().incrementAndGet(), workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
        }

        @Override
        public void rowRemoved(RuleImpl rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getObject();
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setObject(null);
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            LeftTupleSets leftTuples = query.getResultLeftTupleSets();
            LeftTuple childLeftTuple = rightTuple.getFirstChild();
            RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, leftTuples, leftTuples);
        }

        @Override
        public void rowUpdated(RuleImpl rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getObject();
            if (rightTuple.getMemory() != null) {
                return;
            }
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setObject(null);
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            InternalFactHandle rootHandle = resultLeftTuple.get(0);
            DroolsQuery dquery = (DroolsQuery)rootHandle.getObject();
            Object[] objects = new Object[dquery.getElements().length];
            for (int variable : this.variables) {
                Declaration decl = decls[variable];
                objects[variable] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle handle = (QueryElementFactHandle)rightTuple.getFactHandle();
            handle.setRecency(workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            handle.setObject(objects);
            if (dquery.isOpen()) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setObject(rightTuple);
            }
            LeftTupleSets leftTuples = dquery.getResultLeftTupleSets();
            LeftTuple childLeftTuple = rightTuple.getFirstChild();
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    leftTuples.removeInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    leftTuples.removeUpdate(childLeftTuple);
                }
            }
            leftTuples.addUpdate(childLeftTuple);
        }

        public List<?> getResults() {
            throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support the getResults() method.");
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }
    }
}

