/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.query.jpa.impl.QueryCriteriaUtil;
import org.jbpm.services.task.audit.BAMTaskSummaryQueryBuilder;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.service.AuditTaskDeleteBuilderImpl;
import org.jbpm.services.task.audit.service.AuditTaskQueryBuilderImpl;
import org.jbpm.services.task.audit.service.BAMTaskSummaryQueryBuilderImpl;
import org.jbpm.services.task.audit.service.TaskAuditQueryCriteriaUtil;
import org.jbpm.services.task.audit.service.TaskEventDeleteBuilderImpl;
import org.jbpm.services.task.audit.service.TaskEventQueryBuilderImpl;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.query.AuditTaskDeleteBuilder;
import org.kie.internal.task.query.AuditTaskQueryBuilder;
import org.kie.internal.task.query.TaskEventDeleteBuilder;
import org.kie.internal.task.query.TaskEventQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskJPAAuditService
extends JPAAuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(TaskJPAAuditService.class);
    private final TaskAuditQueryCriteriaUtil queryCriteriaUtil = new TaskAuditQueryCriteriaUtil(this);

    public TaskJPAAuditService() {
    }

    public TaskJPAAuditService(EntityManagerFactory emf) {
        super(emf);
    }

    protected EntityManager getEntityManager() {
        return super.getEntityManager();
    }

    protected Object joinTransaction(EntityManager em) {
        return super.joinTransaction(em);
    }

    protected void closeEntityManager(EntityManager em, Object transaction) {
        super.closeEntityManager(em, transaction);
    }

    public AuditTaskDeleteBuilder auditTaskDelete() {
        return new AuditTaskDeleteBuilderImpl(this);
    }

    public TaskEventDeleteBuilder taskEventInstanceLogDelete() {
        return new TaskEventDeleteBuilderImpl(this);
    }

    public void clear() {
        try {
            super.clear();
        }
        catch (Exception e) {
            logger.warn("Unable to clear using {} due to {}", (Object)super.getClass().getName(), (Object)e.getMessage());
        }
        this.auditTaskDelete().build().execute();
        this.taskEventInstanceLogDelete().build().execute();
    }

    public AuditTaskQueryBuilder auditTaskQuery() {
        return new AuditTaskQueryBuilderImpl(this);
    }

    public BAMTaskSummaryQueryBuilder bamTaskSummaryQuery() {
        return new BAMTaskSummaryQueryBuilderImpl(this);
    }

    public TaskEventQueryBuilder taskEventQuery() {
        return new TaskEventQueryBuilderImpl(this);
    }

    protected QueryCriteriaUtil getQueryCriteriaUtil(Class queryType) {
        if (queryType.equals(AuditTaskImpl.class) || queryType.equals(TaskEventImpl.class) || queryType.equals(BAMTaskSummaryImpl.class)) {
            return this.queryCriteriaUtil;
        }
        return super.getQueryCriteriaUtil(queryType);
    }

    static {
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.CREATED_ON_LIST, (String)"l.createdOn", Date.class);
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, (String)"l.deploymentId", String.class);
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.TASK_EVENT_DATE_ID_LIST, (String)"l.logTime", Date.class);
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.TASK_ID_LIST, (String)"l.taskId", Long.class);
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.TASK_NAME_LIST, (String)"l.name", String.class);
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.TASK_DESCRIPTION_LIST, (String)"l.description", String.class);
        TaskJPAAuditService.addCriteria((String)QueryParameterIdentifiers.TASK_STATUS_LIST, (String)"l.status", String.class);
    }
}

