/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jbpm.services.task.identity.AbstractUserGroupInfo;
import org.kie.internal.task.api.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossUserGroupCallbackImpl
extends AbstractUserGroupInfo
implements UserGroupCallback {
    private String separator;
    private static final Logger logger = LoggerFactory.getLogger(JBossUserGroupCallbackImpl.class);
    private static final String DEFAULT_PROPERTIES_LOCATION = "file:" + System.getProperty("jboss.server.config.dir") + "/roles.properties";
    private Map<String, List<String>> groupStore = new HashMap<String, List<String>>();
    private Set<String> allgroups = new HashSet<String>();

    public JBossUserGroupCallbackImpl(boolean activate) {
        this(System.getProperty("jbpm.user.group.mapping"));
    }

    public JBossUserGroupCallbackImpl(String location) {
        Properties userGroups = this.readProperties(location, DEFAULT_PROPERTIES_LOCATION);
        logger.debug("Loaded properties {}", (Object)userGroups);
        this.init(userGroups);
    }

    public JBossUserGroupCallbackImpl(Properties userGroups) {
        this.init(userGroups);
    }

    protected void init(Properties userGroups) {
        if (userGroups == null) {
            throw new IllegalArgumentException("UserGroups properties cannot be null");
        }
        this.separator = System.getProperty("org.jbpm.ht.user.separator", ",");
        List<String> groups = null;
        for (String string : userGroups.keySet()) {
            groups = Arrays.asList(userGroups.getProperty(string, "").split(this.separator));
            this.groupStore.put(string, groups);
            this.allgroups.addAll(groups);
        }
        if (!this.groupStore.containsKey("Administrator")) {
            this.groupStore.put("Administrator", Collections.singletonList("Administrators"));
            this.allgroups.add("Administrators");
        }
    }

    public boolean existsUser(String userId) {
        return this.groupStore.containsKey(userId);
    }

    public boolean existsGroup(String groupId) {
        return this.allgroups.contains(groupId);
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        List<String> groups = this.groupStore.get(userId);
        if (groups == null) {
            groups = new ArrayList<String>(0);
        }
        return groups;
    }
}

