/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.impl.TaskResolverFactory;
import org.jbpm.services.task.internals.lifecycle.LifeCycleManager;
import org.jbpm.services.task.utils.ClassUtil;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Operation;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskInstanceServiceImpl
implements TaskInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(TaskInstanceServiceImpl.class);
    protected static final Pattern PARAMETER_MATCHER = Pattern.compile("\\$\\{([\\S&&[^\\}]]+)\\}", 32);
    private LifeCycleManager lifeCycleManager;
    private org.kie.internal.task.api.TaskContext context;
    private TaskPersistenceContext persistenceContext;
    private TaskEventSupport taskEventSupport;
    private Environment environment;

    public TaskInstanceServiceImpl() {
    }

    public TaskInstanceServiceImpl(org.kie.internal.task.api.TaskContext context, TaskPersistenceContext persistenceContext, LifeCycleManager lifeCycleManager, TaskEventSupport taskEventSupport, Environment environment) {
        this.context = context;
        this.persistenceContext = persistenceContext;
        this.lifeCycleManager = lifeCycleManager;
        this.taskEventSupport = taskEventSupport;
        this.environment = environment;
    }

    public void setLifeCycleManager(LifeCycleManager lifeCycleManager) {
        this.lifeCycleManager = lifeCycleManager;
    }

    public void setTaskEventSupport(TaskEventSupport taskEventSupport) {
        this.taskEventSupport = taskEventSupport;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public long addTask(Task task, Map<String, Object> params) {
        this.taskEventSupport.fireBeforeTaskAdded(task, this.context);
        this.persistenceContext.persistTask(task);
        this.resolveTaskDetailsForTaskProperties(task);
        if (params != null) {
            this.resolveTaskDetails(params, task);
            ContentData contentData = ContentMarshallerHelper.marshal(params, TaskContentRegistry.get().getMarshallerContext(task).getEnvironment());
            Content content = TaskModelProvider.getFactory().newContent();
            ((InternalContent)content).setContent(contentData.getContent());
            this.persistenceContext.persistContent(content);
            ((InternalTaskData)task.getTaskData()).setDocument(content.getId(), contentData);
        }
        this.taskEventSupport.fireAfterTaskAdded(task, this.context);
        return task.getId();
    }

    public long addTask(Task task, ContentData contentData) {
        this.taskEventSupport.fireBeforeTaskAdded(task, this.context);
        this.persistenceContext.persistTask(task);
        this.resolveTaskDetailsForTaskProperties(task);
        if (contentData != null) {
            Content content = TaskModelProvider.getFactory().newContent();
            ((InternalContent)content).setContent(contentData.getContent());
            this.persistenceContext.persistContent(content);
            ((InternalTaskData)task.getTaskData()).setDocument(content.getId(), contentData);
        }
        this.taskEventSupport.fireAfterTaskAdded(task, this.context);
        return task.getId();
    }

    public void activate(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Activate, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void claim(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Claim, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void claim(long taskId, String userId, List<String> groupIds) {
        this.lifeCycleManager.taskOperation(Operation.Claim, taskId, userId, null, null, groupIds, new OrganizationalEntity[0]);
    }

    public void claimNextAvailable(String userId) {
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List queryTasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatus", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status}), ClassUtil.castClass(List.class));
        if (queryTasks.size() > 0) {
            this.lifeCycleManager.taskOperation(Operation.Claim, ((TaskSummary)queryTasks.get(0)).getId(), userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
        } else {
            logger.info("No task available to assign for user {}", (Object)userId);
        }
    }

    public void claimNextAvailable(String userId, List<String> groupIds) {
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List queryTasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatusByGroup", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "groupIds", groupIds}), ClassUtil.castClass(List.class));
        if (queryTasks.size() > 0) {
            this.lifeCycleManager.taskOperation(Operation.Claim, ((TaskSummary)queryTasks.get(0)).getId(), userId, null, null, groupIds, new OrganizationalEntity[0]);
        } else {
            logger.info("No task available to assign for user {} and groups {}", (Object)userId, groupIds);
        }
    }

    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.lifeCycleManager.taskOperation(Operation.Complete, taskId, userId, null, data, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void delegate(long taskId, String userId, String targetUserId) {
        this.lifeCycleManager.taskOperation(Operation.Delegate, taskId, userId, targetUserId, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void deleteFault(long taskId, String userId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        long contentId = task.getTaskData().getFaultContentId();
        Content content = this.persistenceContext.findContent(Long.valueOf(contentId));
        FaultData data = TaskModelProvider.getFactory().newFaultData();
        this.persistenceContext.removeContent(content);
        ((InternalTaskData)task.getTaskData()).setFault(0L, data);
    }

    public void deleteOutput(long taskId, String userId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        long contentId = task.getTaskData().getOutputContentId();
        Content content = this.persistenceContext.findContent(Long.valueOf(contentId));
        ContentData data = TaskModelProvider.getFactory().newContentData();
        this.persistenceContext.removeContent(content);
        ((InternalTaskData)task.getTaskData()).setOutput(0L, data);
    }

    public void exit(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Exit, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.lifeCycleManager.taskOperation(Operation.Fail, taskId, userId, null, faultData, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.lifeCycleManager.taskOperation(Operation.Forward, taskId, userId, targetEntityId, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void release(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Release, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void remove(long taskId, String userId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        User user = this.persistenceContext.findUser(userId);
        if (!((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients().contains(user)) {
            throw new RuntimeException("Couldn't remove user " + userId + " since it isn't a notification recipient");
        }
        ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients().remove(user);
    }

    public void resume(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Resume, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void setFault(long taskId, String userId, FaultData fault) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        Content content = TaskModelProvider.getFactory().newContent();
        ((InternalContent)content).setContent(fault.getContent());
        this.persistenceContext.persistContent(content);
        ((InternalTaskData)task.getTaskData()).setFault(content.getId(), fault);
    }

    public void setOutput(long taskId, String userId, Object outputContentData) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ContentData contentData = ContentMarshallerHelper.marshal(outputContentData, this.environment);
        Content content = TaskModelProvider.getFactory().newContent();
        ((InternalContent)content).setContent(contentData.getContent());
        this.persistenceContext.persistContent(content);
        ((InternalTaskData)task.getTaskData()).setOutput(content.getId(), contentData);
    }

    public void setPriority(long taskId, int priority) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.taskEventSupport.fireBeforeTaskUpdated(task, this.context);
        ((InternalTask)task).setPriority(priority);
        this.taskEventSupport.fireAfterTaskUpdated(task, this.context);
    }

    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.taskEventSupport.fireBeforeTaskUpdated(task, this.context);
        ((InternalTask)task).setNames(taskNames);
        ((InternalTask)task).setName(taskNames.get(0).getText());
        this.taskEventSupport.fireAfterTaskUpdated(task, this.context);
    }

    public void skip(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Skip, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void start(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Start, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void stop(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Stop, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void suspend(long taskId, String userId) {
        this.lifeCycleManager.taskOperation(Operation.Suspend, taskId, userId, null, null, this.toGroups(null), new OrganizationalEntity[0]);
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.lifeCycleManager.taskOperation(Operation.Nominate, taskId, userId, null, null, this.toGroups(null), potentialOwners.toArray(new OrganizationalEntity[potentialOwners.size()]));
    }

    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTask)task).setSubTaskStrategy(strategy);
    }

    public void setExpirationDate(long taskId, Date date) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.taskEventSupport.fireBeforeTaskUpdated(task, this.context);
        ((InternalTaskData)task.getTaskData()).setExpirationTime(date);
        this.taskEventSupport.fireAfterTaskUpdated(task, this.context);
    }

    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.taskEventSupport.fireBeforeTaskUpdated(task, this.context);
        ((InternalTask)task).setDescriptions(descriptions);
        ((InternalTask)task).setDescription(descriptions.get(0).getText());
        this.taskEventSupport.fireAfterTaskUpdated(task, this.context);
    }

    public void setSkipable(long taskId, boolean skipable) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTaskData)task.getTaskData()).setSkipable(skipable);
    }

    public int getPriority(long taskId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        return task.getPriority();
    }

    public Date getExpirationDate(long taskId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        return task.getTaskData().getExpirationTime();
    }

    public List<I18NText> getDescriptions(long taskId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        return task.getDescriptions();
    }

    public boolean isSkipable(long taskId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        return task.getTaskData().isSkipable();
    }

    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        return ((InternalTask)task).getSubTaskStrategy();
    }

    public <T> T execute(Command<T> command) {
        return (T)((TaskCommand)command).execute((Context)new TaskContext());
    }

    public void setName(long taskId, String name) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTask)task).setName(name);
    }

    public void setDescription(long taskId, String description) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTask)task).setDescription(description);
    }

    public void setSubject(long taskId, String subject) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTask)task).setSubject(subject);
    }

    protected List<String> toGroups(List<String> groups) {
        if (groups == null) {
            return (List)this.context.get("local:groups");
        }
        return groups;
    }

    protected Map<String, Object> resolveTaskDetails(Map<String, Object> parameters, Task task) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                try {
                    Object variableValue = MVELSafeHelper.getEvaluator().eval(paramName, (VariableResolverFactory)new TaskResolverFactory(task));
                    String variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    logger.error("Continuing without setting parameter.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("${" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            parameters.put(entry.getKey(), s);
        }
        return parameters;
    }

    protected void resolveTaskDetailsForTaskProperties(Task task) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", task.getName());
        parameters.put("description", task.getDescription());
        parameters.put("subject", task.getSubject());
        parameters.put("formName", ((InternalTask)task).getFormName());
        Map<String, Object> replacements = this.resolveTaskDetails(parameters, task);
        ((InternalTask)task).setName((String)replacements.get("name"));
        ((InternalTask)task).setDescription((String)replacements.get("description"));
        ((InternalTask)task).setSubject((String)replacements.get("subject"));
        ((InternalTask)task).setFormName((String)replacements.get("formName"));
    }
}

