/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.query.jpa.impl.QueryAndParameterAppender;
import org.jbpm.query.jpa.service.QueryModificationService;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryContext;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.query.data.QueryData;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.InternalTaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueryServiceImpl
implements TaskQueryService {
    private static final Logger logger = LoggerFactory.getLogger(TaskQueryServiceImpl.class);
    private TaskPersistenceContext persistenceContext;
    private UserGroupCallback userGroupCallback;
    private static final List<Status> allActiveStatus = new ArrayList<Status>(){
        {
            this.add(Status.Created);
            this.add(Status.Ready);
            this.add(Status.Reserved);
            this.add(Status.InProgress);
            this.add(Status.Suspended);
        }
    };
    public static Map<String, Class<?>> criteriaFieldClasses = new ConcurrentHashMap();
    public static Map<String, String> criteriaFields = new ConcurrentHashMap<String, String>();
    public static Map<String, String> criteriaFieldJoinClauses = new ConcurrentHashMap<String, String>();
    public static String TASKSUMMARY_SELECT;
    public static String TASKSUMMARY_FROM;
    public static String TASKSUMMARY_WHERE;
    private static String[] userParameterIds;
    private static String[] groupParameterIds;

    protected List<?> adoptList(List<?> source, List<?> values) {
        if (source == null || source.isEmpty()) {
            ArrayList data = new ArrayList();
            for (Object value : values) {
                data.add(value);
            }
            return data;
        }
        return source;
    }

    protected void applyQueryFilter(Map<String, Object> params, QueryFilter queryFilter) {
        if (queryFilter != null) {
            this.applyQueryContext(params, (QueryContext)queryFilter);
            if (queryFilter.getFilterParams() != null && !queryFilter.getFilterParams().isEmpty()) {
                params.put("filter", queryFilter.getFilterParams());
                for (String key : queryFilter.getParams().keySet()) {
                    params.put(key, queryFilter.getParams().get(key));
                }
            }
        }
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            Integer count;
            Integer offset = queryContext.getOffset();
            if (offset != null && offset > 0) {
                params.put("firstResult", offset);
            }
            if ((count = queryContext.getCount()) != null && count > 0) {
                params.put("maxResults", count);
            }
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending() != null) {
                    if (queryContext.isAscending().booleanValue()) {
                        params.put("orderType", "ASC");
                    } else {
                        params.put("orderType", "DESC");
                    }
                }
            }
        }
    }

    public TaskQueryServiceImpl() {
    }

    public TaskQueryServiceImpl(TaskPersistenceContext persistenceContext, UserGroupCallback userGroupCallback) {
        this.persistenceContext = persistenceContext;
        this.userGroupCallback = userGroupCallback;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId) {
        return this.getTasksAssignedAsBusinessAdministratorByStatus(userId, allActiveStatus);
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsExcludedOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return this.getTasksAssignedAsPotentialOwner(userId);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", groupIds);
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId) {
        if (groupId == null || groupId.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroup", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupId", groupId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDateOptional(List<String> groupIds, Date expirationDate) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
        return this.collectTasksByPotentialOwners(tasksByGroups);
    }

    protected List<TaskSummary> collectTasksByPotentialOwners(List<Object[]> tasksByGroups) {
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        Iterator<Object[]> i$ = tasksByGroups.iterator();
        while (i$.hasNext()) {
            Object[] o;
            Object[] get = o = i$.next();
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            for (TaskSummary ts : tasks) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDate(List<String> groupIds, Date expirationDate) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
        return this.collectTasksByPotentialOwners(tasksByGroups);
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds}), ClassUtil.castClass(List.class));
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        for (Object o : tasksByGroups) {
            Object[] get = (Object[])o;
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            for (TaskSummary ts : tasks) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public Map<Long, List<OrganizationalEntity>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        List potentialOwners = (List)this.persistenceContext.queryWithParametersInTransaction("GetPotentialOwnersForTaskIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", taskIds}), ClassUtil.castClass(List.class));
        HashMap<Long, List<OrganizationalEntity>> potentialOwnersMap = new HashMap<Long, List<OrganizationalEntity>>();
        Long currentTaskId = 0L;
        for (Object[] item : potentialOwners) {
            Long taskId = (Long)item[0];
            OrganizationalEntity potentialOwner = (OrganizationalEntity)item[1];
            if (currentTaskId != taskId) {
                currentTaskId = taskId;
            }
            if (potentialOwnersMap.get(currentTaskId) == null) {
                potentialOwnersMap.put(currentTaskId, new ArrayList());
            }
            ((List)potentialOwnersMap.get(currentTaskId)).add(potentialOwner);
        }
        return potentialOwnersMap;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, int firstResult, int maxResults) {
        if (groupIds == null || groupIds.isEmpty()) {
            return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "firstResult", firstResult, "maxResults", maxResults}), ClassUtil.castClass(List.class));
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "firstResult", firstResult, "maxResults", maxResults}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsRecipient", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsTaskInitiator", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsTaskStakeholder", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwned(String userId) {
        return this.getTasksOwned(userId, null, null);
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status) {
        List<TaskSummary> taskOwned = this.getTasksOwned(userId, null, null);
        if (!taskOwned.isEmpty()) {
            HashSet<Long> tasksIds = new HashSet<Long>();
            for (TaskSummary ts : taskOwned) {
                tasksIds.add(ts.getId());
            }
            List tasksPotentialOwners = (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedPotentialOwnersByTaskIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            HashMap potentialOwners = new HashMap();
            for (Object o : tasksPotentialOwners) {
                Object[] get = (Object[])o;
                tasksIds.add((Long)get[0]);
                if (potentialOwners.get((Long)get[0]) == null) {
                    potentialOwners.put((Long)get[0], new ArrayList());
                }
                ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
            }
            for (TaskSummary ts : taskOwned) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
        } else {
            return new ArrayList<TaskSummary>(0);
        }
        return taskOwned;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status) {
        return this.getTasksAssignedAsPotentialOwner(userId, null, status, null);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", this.adoptList(status, allActiveStatus));
        params.put("groupIds", this.adoptList(groupIds, Collections.singletonList("")));
        this.applyQueryFilter(params, filter);
        return (List)this.persistenceContext.queryWithParametersInTransaction("NewTasksAssignedAsPotentialOwner", params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        if (status == null) {
            status = new ArrayList<Status>();
            status.add(Status.Reserved);
            status.add(Status.InProgress);
        }
        params.put("status", status);
        this.applyQueryFilter(params, filter);
        return (List)this.persistenceContext.queryWithParametersInTransaction("NewTasksOwned", params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("SubTasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId, "userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId}), ClassUtil.castClass(List.class));
    }

    public int getPendingSubTasksByParent(long parentId) {
        return ((List)this.persistenceContext.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId}), ClassUtil.castClass(List.class))).size();
    }

    public Task getTaskInstanceById(long taskId) {
        Task taskInstance = this.persistenceContext.findTask(Long.valueOf(taskId));
        return taskInstance;
    }

    public Task getTaskByWorkItemId(long workItemId) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskByWorkItemId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"workItemId", workItemId, "maxResults", 1}), ClassUtil.castClass(List.class));
        if (tasks.isEmpty()) {
            return null;
        }
        return (Task)tasks.get(0);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<String> groupIds, List<Status> status, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, status, new QueryFilter("t.taskData.expirationTime = :expirationDate", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<String> groupIds, List<Status> status, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, status, new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksOwned(userId, status, new QueryFilter("t.taskData.expirationTime = :expirationDate", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksOwned(userId, status, new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateBeforeSpecifiedDate(String userId, List<Status> status, Date date) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDateBeforeSpecifiedDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "date", date}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(long processInstanceId, List<Status> status) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceIdByTaskName(long processInstanceId, List<Status> status, String taskName) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessIdByTaskName", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status, "taskName", taskName}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByProcessInstanceId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", "", "status", status, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", "", "status", status, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
    }

    @Deprecated
    public List<TaskSummary> getTasksByVariousFields(String userId, List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> status, boolean union, Integer maxResults) {
        HashMap params = new HashMap();
        params.put(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, workItemIds);
        params.put(QueryParameterIdentifiers.TASK_ID_LIST, taskIds);
        params.put(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, procInstIds);
        params.put(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, busAdmins);
        params.put(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, potOwners);
        params.put(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, taskOwners);
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        params.put(QueryParameterIdentifiers.TASK_STATUS_LIST, status);
        if (maxResults != null) {
            if (maxResults <= 0) {
                return new ArrayList<TaskSummary>();
            }
            Integer[] maxResultsArr = new Integer[]{maxResults};
            params.put("maxResults", Arrays.asList(maxResultsArr));
        }
        return this.getTasksByVariousFields(userId, params, union);
    }

    @Deprecated
    public List<TaskSummary> getTasksByVariousFields(String userId, Map<String, List<?>> parameters, boolean union) {
        Object maxResults;
        List<?> maxResultsList;
        QueryData queryData = new QueryData();
        QueryContext queryContext = queryData.getQueryContext();
        if (queryContext.getOrderBy() == null || queryContext.getOrderBy().isEmpty()) {
            queryContext.setOrderBy("Id");
        }
        if (queryContext.isAscending() == null) {
            queryContext.setAscending(Boolean.valueOf(true));
        }
        if ((maxResultsList = parameters.remove("maxResults")) != null && !maxResultsList.isEmpty() && (maxResults = maxResultsList.get(0)) instanceof Integer) {
            queryContext.setCount((Integer)maxResults);
        }
        if (union) {
            queryData.setToUnion();
        } else {
            queryData.setToIntersection();
        }
        for (Map.Entry<String, List<?>> paramEntry : parameters.entrySet()) {
            List<?> paramList = paramEntry.getValue();
            if (paramList == null || paramList.isEmpty()) continue;
            queryData.addAppropriateParam(paramEntry.getKey(), this.convertToTypedArray(paramList, paramList.get(0)));
        }
        return this.query(userId, queryData);
    }

    private <T> T[] convertToTypedArray(List<?> paramList, T ... firstElem) {
        return paramList.toArray(firstElem);
    }

    public int getCompletedTaskByUserId(String userId) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Completed);
        List<TaskSummary> tasksCompleted = this.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses);
        return tasksCompleted.size();
    }

    public int getPendingTaskByUserId(String userId) {
        List<TaskSummary> tasksAssigned = this.getTasksAssignedAsPotentialOwner(userId, null, null, null);
        return tasksAssigned.size();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", this.adoptList(status, allActiveStatus));
        params.put("groupIds", this.adoptList(groupIds, Collections.singletonList("")));
        return (List)this.persistenceContext.queryWithParametersInTransaction("QuickTasksAssignedAsPotentialOwnerWithGroupsByStatus", params, ClassUtil.castClass(List.class));
    }

    private static void addCriteria(String listId, String fieldName, Class type) {
        TaskQueryServiceImpl.addCriteria(listId, fieldName, type, null);
    }

    private static void addCriteria(String listId, String fieldName, Class type, String joinClause) {
        if (criteriaFields.put(listId, fieldName) != null) {
            throw new IllegalStateException("Duplicate field added for " + listId);
        }
        if (criteriaFieldClasses.put(listId, type) != null) {
            throw new IllegalStateException("Duplicate field class added for " + listId);
        }
        if (joinClause != null && criteriaFieldJoinClauses.put(listId, joinClause) != null) {
            throw new IllegalStateException("Duplicate field join clause added for " + listId);
        }
    }

    public List<TaskSummary> query(String userId, QueryData queryData) {
        String joinClause;
        String jpqlField;
        String joinClause2;
        String jpqlField2;
        Class<?> criteriaFieldClass;
        String listId;
        StringBuilder queryBuilder = new StringBuilder(TASKSUMMARY_SELECT).append(TASKSUMMARY_FROM);
        ServiceLoader<QueryModificationService> queryModServiceLdr = ServiceLoader.load(QueryModificationService.class);
        for (QueryModificationService queryModService : queryModServiceLdr) {
            queryModService.addTablesToQuery(queryBuilder, queryData);
        }
        queryBuilder.append(TASKSUMMARY_WHERE);
        HashMap<String, Object> params = new HashMap<String, Object>();
        QueryAndParameterAppender queryAppender = new QueryAndParameterAppender(queryBuilder, params);
        GroupIdsCache groupIds = new GroupIdsCache(userId);
        boolean existingParametersUsedToLimitToAllowedResults = this.useExistingUserGroupIdToLimitResults(userId, queryData, groupIds);
        for (QueryModificationService queryModificationService : queryModServiceLdr) {
            queryModificationService.addCriteriaToQuery(queryData, queryAppender);
        }
        if (!queryData.unionParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getUnionParameters().entrySet()) {
                listId = (String)entry.getKey();
                criteriaFieldClass = criteriaFieldClasses.get(listId);
                assert (criteriaFieldClass != null) : listId + ": criteria field class not found";
                String jpqlField22 = criteriaFields.get(listId);
                assert (jpqlField22 != null) : listId + ": criteria field not found";
                String joinClause22 = criteriaFieldJoinClauses.get(listId);
                queryAppender.addQueryParameters((List)entry.getValue(), listId, criteriaFieldClass, jpqlField22, joinClause22, true);
            }
        }
        if (!queryData.intersectParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getIntersectParameters().entrySet()) {
                listId = (String)entry.getKey();
                criteriaFieldClass = criteriaFieldClasses.get(listId);
                QueryAndParameterAppender.debugQueryParametersIdentifiers();
                assert (criteriaFieldClass != null) : listId + ": criteria field class not found";
                jpqlField2 = criteriaFields.get(listId);
                assert (jpqlField2 != null) : listId + ": criteria field not found";
                joinClause2 = criteriaFieldJoinClauses.get(listId);
                queryAppender.addQueryParameters((List)entry.getValue(), listId, criteriaFieldClass, jpqlField2, joinClause2, false);
            }
        }
        if (!queryData.unionRangeParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getUnionRangeParameters().entrySet()) {
                listId = (String)entry.getKey();
                criteriaFieldClass = criteriaFieldClasses.get(listId);
                assert (criteriaFieldClass != null) : listId + ": criteria field class not found";
                jpqlField2 = criteriaFields.get(listId);
                assert (jpqlField2 != null) : listId + ": criteria field not found";
                joinClause2 = criteriaFieldJoinClauses.get(listId);
                queryAppender.addRangeQueryParameters((List)entry.getValue(), listId, criteriaFieldClass, jpqlField2, joinClause2, true);
            }
        }
        if (!queryData.intersectRangeParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getIntersectRangeParameters().entrySet()) {
                listId = (String)entry.getKey();
                criteriaFieldClass = criteriaFieldClasses.get(listId);
                assert (criteriaFieldClass != null) : listId + ": criteria field class not found";
                jpqlField2 = criteriaFields.get(listId);
                assert (jpqlField2 != null) : listId + ": criteria field not found";
                joinClause2 = criteriaFieldJoinClauses.get(listId);
                queryAppender.addRangeQueryParameters((List)entry.getValue(), listId, criteriaFieldClass, jpqlField2, joinClause2, false);
            }
        }
        if (!queryData.unionRegexParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getUnionRegexParameters().entrySet()) {
                listId = (String)entry.getKey();
                jpqlField = criteriaFields.get(listId);
                assert (jpqlField != null) : listId + ": criteria field not found";
                joinClause = criteriaFieldJoinClauses.get(listId);
                queryAppender.addRegexQueryParameters((List)entry.getValue(), listId, jpqlField, joinClause, true);
            }
        }
        if (!queryData.intersectRegexParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getIntersectRegexParameters().entrySet()) {
                listId = (String)entry.getKey();
                jpqlField = criteriaFields.get(listId);
                assert (jpqlField != null) : listId + ": criteria field not found";
                joinClause = criteriaFieldJoinClauses.get(listId);
                queryAppender.addRegexQueryParameters((List)entry.getValue(), listId, jpqlField, joinClause, false);
            }
        }
        while (queryAppender.getParenthesesNesting() > 0) {
            queryAppender.closeParentheses();
        }
        if (!existingParametersUsedToLimitToAllowedResults) {
            this.addPossibleUserRolesQueryClause(userId, groupIds, params, queryAppender);
        }
        String query = queryBuilder.toString();
        this.applyQueryContext(params, queryData.getQueryContext());
        return (List)this.persistenceContext.queryStringWithParametersInTransaction(query, params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministratorByStatus(String userId, List<Status> status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", status);
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsBusinessAdministratorByStatus", params, ClassUtil.castClass(List.class));
    }

    private boolean useExistingUserGroupIdToLimitResults(String userId, QueryData queryData, GroupIdsCache groupIds) {
        if (userId == null) {
            return true;
        }
        if (queryData.intersectParametersAreEmpty()) {
            return false;
        }
        boolean usedExistingParameters = true;
        usedExistingParameters = this.useExistingUserGroupIdAsParameter(userParameterIds, queryData, userId);
        if (!usedExistingParameters) {
            String[] userIdsArr = new String[groupIds.size() + 1];
            userIdsArr[0] = userId;
            System.arraycopy(groupIds.toArray(), 0, userIdsArr, 1, groupIds.size());
            usedExistingParameters = this.useExistingUserGroupIdAsParameter(groupParameterIds, queryData, userIdsArr);
        }
        return usedExistingParameters;
    }

    private boolean useExistingUserGroupIdAsParameter(String[] userGroupParamListIds, QueryData queryData, String ... userGroupIds) {
        for (String listId : userGroupParamListIds) {
            List intersectListUserIds = (List)queryData.getIntersectParameters().get(listId);
            if (intersectListUserIds == null) continue;
            for (String groupId : userGroupIds) {
                if (!intersectListUserIds.contains(groupId)) continue;
                return true;
            }
        }
        return false;
    }

    private void addPossibleUserRolesQueryClause(String userId, GroupIdsCache groupIdsCache, Map<String, Object> params, QueryAndParameterAppender queryAppender) {
        StringBuilder rolesQueryPhraseBuilder = new StringBuilder("( ");
        String userIdParamName = queryAppender.generateParamName();
        params.put(userIdParamName, userId);
        String groupIdsParamName = queryAppender.generateParamName();
        ArrayList<String> userAndGroupIds = new ArrayList<String>(1 + groupIdsCache.size());
        userAndGroupIds.add(userId);
        userAndGroupIds.addAll(groupIdsCache.getGroupIds());
        params.put(groupIdsParamName, userAndGroupIds);
        rolesQueryPhraseBuilder.append("( ").append("t.taskData.createdBy.id = :").append(userIdParamName).append("\n OR ").append("( stakeHolders.id in :").append(groupIdsParamName).append(" and\n").append("  stakeHolders in elements ( t.peopleAssignments.taskStakeholders ) )").append("\n OR ").append("( potentialOwners.id in :").append(groupIdsParamName).append(" and\n").append("  potentialOwners in elements ( t.peopleAssignments.potentialOwners ) )").append("\n OR ").append("t.taskData.actualOwner.id = :").append(userIdParamName).append("\n OR ").append("( businessAdministrators.id in :").append(groupIdsParamName).append(" and\n").append("  businessAdministrators in elements ( t.peopleAssignments.businessAdministrators ) )").append(" )\n");
        rolesQueryPhraseBuilder.append(") ");
        queryAppender.addToQueryBuilder(rolesQueryPhraseBuilder.toString(), false);
    }

    static {
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.PROCESS_ID_LIST, "t.taskData.processId", String.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "t.taskData.processInstanceId", Long.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "t.taskData.workItemId", Long.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.TASK_ID_LIST, "t.id", Long.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, "t.taskData.deploymentId.id", String.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.TASK_STATUS_LIST, "t.taskData.status", Status.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.CREATED_BY_LIST, "t.taskData.createdBy.id", String.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, "t.taskData.actualOwner.id", String.class);
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, "stakeHolders.id", String.class, "stakeHolders in elements ( t.peopleAssignments.taskStakeholders )");
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, "potentialOwners.id", String.class, "potentialOwners in elements ( t.peopleAssignments.potentialOwners )");
        TaskQueryServiceImpl.addCriteria(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, "businessAdministrators.id", String.class, "businessAdministrators in elements ( t.peopleAssignments.businessAdministrators )");
        TASKSUMMARY_SELECT = "SELECT distinct new org.jbpm.services.task.query.TaskSummaryImpl(\n       t.id,\n       t.name,\n       t.description,\n       t.taskData.status,\n       t.priority,\n       t.taskData.actualOwner.id,\n       t.taskData.createdBy.id,\n       t.taskData.createdOn,\n       t.taskData.activationTime,\n       t.taskData.expirationTime,\n       t.taskData.processId,\n       t.taskData.processInstanceId,\n       t.taskData.parentId,\n       t.taskData.deploymentId )\n";
        TASKSUMMARY_FROM = "FROM TaskImpl t,\n     OrganizationalEntityImpl stakeHolders,\n     OrganizationalEntityImpl potentialOwners,\n     OrganizationalEntityImpl businessAdministrators\n";
        TASKSUMMARY_WHERE = "WHERE t.archived = 0\n";
        userParameterIds = new String[]{QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, QueryParameterIdentifiers.CREATED_BY_LIST};
        groupParameterIds = new String[]{QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST};
    }

    private class GroupIdsCache {
        private final String userId;
        private boolean groupsRetrieved = false;
        private List<String> groupIds;

        private GroupIdsCache(String userId) {
            this.userId = userId;
        }

        private List<String> getGroupIds() {
            if (!this.groupsRetrieved) {
                this.groupsRetrieved = true;
                this.groupIds = TaskQueryServiceImpl.this.userGroupCallback.getGroupsForUser(this.userId, null, null);
            }
            return this.groupIds;
        }

        public String[] toArray() {
            this.getGroupIds();
            return this.groupIds.toArray(new String[this.groupIds.size()]);
        }

        public int size() {
            this.getGroupIds();
            return this.groupIds.size();
        }
    }
}

