/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.runtime.KieRuntime;

public class WorkflowProcessInstanceUpgrader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeProcessInstance(KieRuntime kruntime, long processInstanceId, String processId, Map<String, Long> nodeMapping) {
        WorkflowProcessInstanceImpl processInstance;
        if (nodeMapping == null) {
            nodeMapping = new HashMap<String, Long>();
        }
        if ((processInstance = (WorkflowProcessInstanceImpl)kruntime.getProcessInstance(processInstanceId)) == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        if (processId == null) {
            throw new IllegalArgumentException("Null process id");
        }
        WorkflowProcess process = (WorkflowProcess)kruntime.getKieBase().getProcess(processId);
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processId);
        }
        if (processInstance.getProcessId().equals(processId)) {
            return;
        }
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = processInstance;
        synchronized (workflowProcessInstanceImpl) {
            Process oldProcess = processInstance.getProcess();
            processInstance.disconnect();
            processInstance.setProcess(oldProcess);
            WorkflowProcessInstanceUpgrader.updateNodeInstances(processInstance, nodeMapping);
            processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)kruntime);
            processInstance.setProcess((Process)process);
            processInstance.reconnect();
        }
    }

    public static void upgradeProcessInstanceByNodeNames(KieRuntime kruntime, Long fromProcessId, String toProcessId, Map<String, String> nodeNamesMapping) {
        HashMap<String, Long> nodeIdMapping = new HashMap<String, Long>();
        String fromProcessIdString = kruntime.getProcessInstance(fromProcessId.longValue()).getProcessId();
        Process processFrom = kruntime.getKieBase().getProcess(fromProcessIdString);
        Process processTo = kruntime.getKieBase().getProcess(toProcessId);
        for (Map.Entry<String, String> entry : nodeNamesMapping.entrySet()) {
            String from = null;
            Long to = null;
            if (processFrom instanceof WorkflowProcess) {
                from = WorkflowProcessInstanceUpgrader.getNodeId(((WorkflowProcess)processFrom).getNodes(), entry.getKey(), true);
            } else if (processFrom instanceof RuleFlowProcess) {
                from = WorkflowProcessInstanceUpgrader.getNodeId(((RuleFlowProcessInstance)processFrom).getWorkflowProcess().getNodes(), entry.getKey(), true);
            } else {
                if (processFrom != null) {
                    throw new IllegalArgumentException("Suported processes are WorkflowProcess and RuleFlowProcess, it was:" + processFrom.getClass());
                }
                throw new IllegalArgumentException("Can not find process with id: " + fromProcessIdString);
            }
            if (processTo instanceof WorkflowProcess) {
                to = Long.valueOf(WorkflowProcessInstanceUpgrader.getNodeId(((WorkflowProcess)processTo).getNodes(), entry.getValue(), false));
            } else if (processTo instanceof RuleFlowProcess) {
                to = Long.valueOf(WorkflowProcessInstanceUpgrader.getNodeId(((RuleFlowProcessInstance)processTo).getWorkflowProcess().getNodes(), entry.getValue(), false));
            } else {
                if (processTo != null) {
                    throw new IllegalArgumentException("Suported processes are WorkflowProcess and RuleFlowProcess, it was:" + processTo.getClass());
                }
                throw new IllegalArgumentException("Can not find process with id: " + toProcessId);
            }
            nodeIdMapping.put(from, to);
        }
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance(kruntime, fromProcessId, toProcessId, nodeIdMapping);
    }

    private static String getNodeId(Node[] nodes, String nodeName, boolean unique) {
        Stack<Node> nodeStack = new Stack<Node>();
        for (Node node : nodes) {
            nodeStack.push(node);
        }
        Node match = null;
        while (!nodeStack.isEmpty()) {
            Node topNode = (Node)nodeStack.pop();
            if (topNode.getName().compareTo(nodeName) == 0) {
                match = topNode;
                break;
            }
            if (!(topNode instanceof NodeContainer)) continue;
            for (Node node : ((NodeContainer)topNode).getNodes()) {
                nodeStack.push(node);
            }
        }
        if (match == null) {
            throw new IllegalArgumentException("No node with name " + nodeName);
        }
        String id = "";
        if (unique) {
            while (!(match.getNodeContainer() instanceof Process)) {
                id = ":" + match.getId() + id;
                match = (Node)match.getNodeContainer();
            }
        }
        id = match.getId() + id;
        return id;
    }

    private static void updateNodeInstances(NodeInstanceContainer nodeInstanceContainer, Map<String, Long> nodeMapping) {
        for (org.kie.api.runtime.process.NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            String oldNodeId = ((NodeImpl)((NodeInstance)nodeInstance).getNode()).getUniqueId();
            Long newNodeId = nodeMapping.get(oldNodeId);
            if (newNodeId == null) {
                newNodeId = nodeInstance.getNodeId();
            }
            Map<String, Integer> iterLevels = ((WorkflowProcessInstanceImpl)nodeInstance.getProcessInstance()).getIterationLevels();
            String uniqueId = (String)((NodeImpl)nodeInstance.getNode()).getMetaData("UniqueId");
            iterLevels.remove(uniqueId);
            ((NodeInstanceImpl)nodeInstance).setNodeId(newNodeId);
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            WorkflowProcessInstanceUpgrader.updateNodeInstances((NodeInstanceContainer)nodeInstance, nodeMapping);
        }
    }
}

