/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Version;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;

@Entity
@SequenceGenerator(name="correlationKeyInfoIdSeq", sequenceName="CORRELATION_KEY_ID_SEQ")
public class CorrelationKeyInfo
implements CorrelationKey,
Serializable {
    private static final long serialVersionUID = 4469298702447675428L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="correlationKeyInfoIdSeq")
    @Column(name="keyId")
    private long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private long processInstanceId;
    private String name;
    @OneToMany(mappedBy="correlationKey", cascade={CascadeType.ALL})
    private List<CorrelationPropertyInfo> properties;

    public String getName() {
        return this.name;
    }

    public List<CorrelationProperty<?>> getProperties() {
        return new ArrayList(this.properties);
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addProperty(CorrelationPropertyInfo property) {
        if (this.properties == null) {
            this.properties = new ArrayList<CorrelationPropertyInfo>();
        }
        property.setCorrelationKey(this);
        this.properties.add(property);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationKeyInfo other = (CorrelationKeyInfo)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "CorrelationKey [name=" + this.name + ", properties=" + this.properties + "]";
    }

    public long getId() {
        return this.id;
    }

    public String toExternalForm() {
        StringBuilder builder = new StringBuilder();
        for (CorrelationPropertyInfo property : this.properties) {
            builder.append(property.getValue());
            builder.append(":");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

