/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.PriorityQueue;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.Behavior;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.PointInTimeTrigger;

public class SlidingTimeWindow
implements Externalizable,
Behavior {
    protected long size;
    private static final BehaviorJob job = new BehaviorJob();
    protected int nodeId;

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
        this.nodeId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
        out.writeInt(this.nodeId);
    }

    @Override
    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public void setWindowNode(WindowNode windowNode) {
        this.nodeId = windowNode.getId();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public Object createContext() {
        return new SlidingTimeWindowContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean assertFact(Object context, InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        long currentTime = workingMemory.getTimerService().getCurrentTime();
        if (this.isExpired(currentTime, handle)) {
            return false;
        }
        PriorityQueue<EventFactHandle> priorityQueue = queue.queue;
        synchronized (priorityQueue) {
            queue.queue.add(handle);
            if (queue.queue.peek() == handle) {
                this.updateNextExpiration(handle, pctx, workingMemory, queue, this.nodeId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retractFact(Object context, InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        PriorityQueue<EventFactHandle> priorityQueue = queue.queue;
        synchronized (priorityQueue) {
            if (queue.expiringHandle != handle) {
                if (queue.queue.peek() == handle) {
                    queue.queue.poll();
                    this.updateNextExpiration(queue.queue.peek(), pctx, workingMemory, queue, this.nodeId);
                } else {
                    queue.queue.remove(handle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireFacts(Object context, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        PriorityQueue<EventFactHandle> priorityQueue = queue.queue;
        synchronized (priorityQueue) {
            EventFactHandle handle = queue.queue.peek();
            while (handle != null && this.isExpired(currentTime, handle)) {
                queue.expiringHandle = handle;
                queue.queue.remove();
                if (handle.isValid()) {
                    PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
                    PropagationContext expiresPctx = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 5, null, null, handle);
                    ObjectTypeNode.doRetractObject(handle, expiresPctx, workingMemory);
                    expiresPctx.evaluateActionQueue(workingMemory);
                }
                queue.expiringHandle = null;
                handle = queue.queue.peek();
            }
            this.updateNextExpiration(handle, pctx, workingMemory, queue, this.nodeId);
        }
    }

    private boolean isExpired(long currentTime, EventFactHandle handle) {
        return handle.getStartTimestamp() + this.size <= currentTime;
    }

    protected void updateNextExpiration(InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory, Object context, int nodeId) {
        TimerService clock = workingMemory.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((EventFactHandle)fact).getStartTimestamp() + this.getSize();
            if (nextTimestamp < clock.getCurrentTime()) {
                workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(nodeId, this, context, pctx));
            } else {
                BehaviorJobContext jobctx = new BehaviorJobContext(nodeId, workingMemory, this, context, pctx);
                JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
                jobctx.setJobHandle(handle);
            }
        }
    }

    @Override
    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    public static class BehaviorExpireWMAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private final Behavior behavior;
        private final Object context;
        private final int nodeId;
        private final PropagationContext pctx;

        public BehaviorExpireWMAction(int nodeId, Behavior behavior, Object context, PropagationContext pctx) {
            this.nodeId = nodeId;
            this.behavior = behavior;
            this.context = context;
            this.pctx = pctx;
        }

        public BehaviorExpireWMAction(MarshallerReaderContext inCtx) throws IOException {
            this.nodeId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(this.nodeId);
            WindowNode.WindowMemory memory = (WindowNode.WindowMemory)inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])memory.behaviorContext;
            int i = inCtx.readInt();
            this.behavior = (SlidingTimeWindow)windowNode.getBehaviors()[i];
            this.context = (SlidingTimeWindowContext)behaviorContext[i];
            this.pctx = null;
        }

        public BehaviorExpireWMAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.nodeId = _action.getBehaviorExpire().getNodeId();
            WindowNode windowNode = (WindowNode)context.sinks.get(this.nodeId);
            WindowNode.WindowMemory memory = (WindowNode.WindowMemory)context.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])memory.behaviorContext;
            int i = 0;
            this.behavior = (SlidingTimeWindow)windowNode.getBehaviors()[i];
            this.context = (SlidingTimeWindowContext)behaviorContext[i];
            this.pctx = null;
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.behavior.expireFacts(this.context, null, workingMemory);
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext outputCtx) {
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)this.context;
            ProtobufMessages.ActionQueue.BehaviorExpire _be = ProtobufMessages.ActionQueue.BehaviorExpire.newBuilder().setNodeId(this.nodeId).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.BEHAVIOR_EXPIRE).setBehaviorExpire(_be).build();
        }
    }

    public static class BehaviorJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(context.nodeId, context.behavior, context.behaviorContext, context.pctx));
        }
    }

    public static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public InternalWorkingMemory workingMemory;
        public int nodeId;
        public Behavior behavior;
        public Object behaviorContext;
        public JobHandle handle;
        public final PropagationContext pctx;

        public BehaviorJobContext(int nodeId, InternalWorkingMemory workingMemory, Behavior behavior, Object behaviorContext, PropagationContext pctx) {
            this.nodeId = nodeId;
            this.workingMemory = workingMemory;
            this.behavior = behavior;
            this.behaviorContext = behaviorContext;
            this.pctx = pctx;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            int sinkId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(sinkId);
            WindowNode.WindowMemory memory = (WindowNode.WindowMemory)inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])memory.behaviorContext;
            int i = inCtx.readInt();
        }

        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            int i = _timer.getBehavior().getHandleId();
        }
    }

    public static class BehaviorJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(51);
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.getQueue().peek();
            outputCtx.writeInt(handle.getId());
        }

        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.getQueue().peek();
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.BEHAVIOR).setBehavior(ProtobufMessages.Timers.BehaviorTimer.newBuilder().setHandleId(handle.getId()).build()).build();
        }
    }

    public static class SlidingTimeWindowContext
    implements Externalizable {
        public PriorityQueue<EventFactHandle> queue = new PriorityQueue(16);
        public EventFactHandle expiringHandle;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
            this.expiringHandle = (EventFactHandle)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.expiringHandle);
        }

        public PriorityQueue<EventFactHandle> getQueue() {
            return this.queue;
        }

        public void setQueue(PriorityQueue<EventFactHandle> queue) {
            this.queue = queue;
        }

        public EventFactHandle getExpiringHandle() {
            return this.expiringHandle;
        }

        public void setExpiringTuple(EventFactHandle expiringHandle) {
            this.expiringHandle = expiringHandle;
        }
    }
}

