/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.CallActivityHandler;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GetReusableSubProcessesHandler
extends CallActivityHandler {
    private ProcessDescriptionRepository repository;
    private BPMN2DataServiceSemanticModule module;

    public GetReusableSubProcessesHandler(BPMN2DataServiceSemanticModule module) {
        this.module = module;
        this.repository = module.getRepo();
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        String mainProcessId = this.module.getRepoHelper().getProcess().getId();
        SubProcessNode subProcess = (SubProcessNode)node;
        String processId = subProcess.getProcessId();
        ProcessDescRepoHelper helper = this.repository.getProcessDesc(mainProcessId);
        if (processId != null) {
            helper.getReusableSubProcesses().add(processId);
        } else {
            helper.addReusableSubProcessName(subProcess.getProcessName());
        }
    }

    public void setRepository(ProcessDescriptionRepository repository) {
        this.repository = repository;
    }
}

