/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.cmd;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class StartProcessInstanceWithParentCommand
implements GenericCommand<ProcessInstance> {
    @XmlAttribute(required=true)
    private Long processInstanceId;
    @XmlAttribute(required=true)
    private Long parentProcessInstanceId;

    public StartProcessInstanceWithParentCommand() {
    }

    public StartProcessInstanceWithParentCommand(Long processInstanceId, Long parentProcessInstanceId) {
        this.processInstanceId = processInstanceId;
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId.longValue());
        if (this.parentProcessInstanceId > 0L) {
            ((ProcessInstanceImpl)processInstance).setMetaData("ParentProcessInstanceId", (Object)this.parentProcessInstanceId);
        }
        return ksession.startProcessInstance(this.processInstanceId.longValue());
    }

    public Long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(Long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }
}

