/*
 * Copyright 2014 JBoss by Red Hat.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.services.cdi.producer;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;

import org.jbpm.services.cdi.Selectable;
import org.jbpm.services.task.identity.DBUserGroupCallbackImpl;
import org.jbpm.services.task.identity.DBUserInfoImpl;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.UserInfo;

@ApplicationScoped
@Alternative
@Selectable
public class DBUserGroupInfoProducer implements UserGroupInfoProducer {

	private UserGroupCallback callback = new DBUserGroupCallbackImpl(true);
	private UserInfo userInfo = new DBUserInfoImpl(true);
	
	@Override
	@Produces
	public UserGroupCallback produceCallback() {
		return callback;
	}

	@Override
	@Produces
	public UserInfo produceUserInfo() {
		return userInfo;
	}

}
