/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.CommonUtils;
import org.jbpm.kie.services.impl.VariablesAware;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.AccessType;
import org.kie.internal.task.api.model.InternalAttachment;
import org.kie.internal.task.api.model.InternalComment;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalI18NText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskServiceImpl
implements UserTaskService,
VariablesAware {
    private static final Logger logger = LoggerFactory.getLogger(UserTaskServiceImpl.class);
    private DeploymentService deploymentService;
    private RuntimeDataService dataService;
    private InternalTaskService nonProcessScopedTaskService;

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setDataService(RuntimeDataService dataService) {
        this.dataService = dataService;
    }

    public void setNonProcessScopedTaskService(InternalTaskService nonProcessScopedTaskService) {
        this.nonProcessScopedTaskService = nonProcessScopedTaskService;
    }

    protected InternalTaskService getInternalTaskService() {
        return this.nonProcessScopedTaskService;
    }

    protected RuntimeManager getRuntimeManager(UserTaskInstanceDesc task) {
        if (task != null && task.getDeploymentId() != null) {
            return this.deploymentService.getRuntimeManager(task.getDeploymentId());
        }
        InternalTaskService internalTaskService = this.getInternalTaskService();
        if (internalTaskService != null) {
            return new FalbackRuntimeManager(internalTaskService);
        }
        return null;
    }

    protected RuntimeManager getRuntimeManager(String deploymentId, Command<?> command) {
        RuntimeManager manager;
        Long taskId;
        if (deploymentId == null && command instanceof TaskCommand && (taskId = ((TaskCommand)command).getTaskId()) != null) {
            UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
            deploymentId = task.getDeploymentId();
        }
        if ((manager = this.deploymentService.getRuntimeManager(deploymentId)) == null) {
            InternalTaskService internalTaskService = this.getInternalTaskService();
            if (internalTaskService != null) {
                manager = new FalbackRuntimeManager(internalTaskService);
            } else {
                logger.warn("Cannot find runtime manager for deployment {}", (Object)deploymentId);
                return null;
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.activate(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claim(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.claim(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Long taskId, String userId, Map<String, Object> params) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        if (manager instanceof InternalRuntimeManager) {
            params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.complete(taskId.longValue(), userId, params);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delegate(Long taskId, String userId, String targetUserId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.delegate(taskId.longValue(), userId, targetUserId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.exit(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(Long taskId, String userId, Map<String, Object> faultData) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        if (manager instanceof InternalRuntimeManager) {
            faultData = this.process(faultData, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.fail(taskId.longValue(), userId, faultData);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(Long taskId, String userId, String targetEntityId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.forward(taskId.longValue(), userId, targetEntityId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.release(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.resume(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skip(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.skip(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.start(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.stop(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Long taskId, String userId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.suspend(taskId.longValue(), userId);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nominate(Long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            taskService.nominate(taskId.longValue(), userId, potentialOwners);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(Long taskId, int priority) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).setPriority(taskId.longValue(), priority);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpirationDate(Long taskId, Date date) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).setExpirationDate(taskId.longValue(), date);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipable(Long taskId, boolean skipable) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).setSkipable(taskId.longValue(), skipable);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(Long taskId, String name) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            InternalI18NText text = (InternalI18NText)TaskModelProvider.getFactory().newI18NText();
            text.setLanguage("en-UK");
            text.setText(name);
            ArrayList<InternalI18NText> names = new ArrayList<InternalI18NText>();
            names.add(text);
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).setTaskNames(taskId.longValue(), names);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(Long taskId, String description) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            InternalI18NText text = (InternalI18NText)TaskModelProvider.getFactory().newI18NText();
            text.setLanguage("en-UK");
            text.setText(description);
            ArrayList<InternalI18NText> names = new ArrayList<InternalI18NText>();
            names.add(text);
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).setDescriptions(taskId.longValue(), names);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long saveContent(Long taskId, Map<String, Object> values) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        if (manager instanceof InternalRuntimeManager) {
            values = this.process(values, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Long l = ((InternalTaskService)taskService).addContent(taskId.longValue(), values);
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContent(Long taskId, Long contentId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).deleteContent(taskId.longValue(), contentId.longValue());
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTaskOutputContentByTaskId(Long taskId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Task taskInstanceById = taskService.getTaskById(taskId.longValue());
            long documentContentId = taskInstanceById.getTaskData().getOutputContentId();
            if (documentContentId > 0L) {
                Content contentById = taskService.getContentById(documentContentId);
                if (contentById == null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                ContentMarshallerContext ctx = TaskContentRegistry.get().getMarshallerContext(task.getDeploymentId());
                Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), (Environment)ctx.getEnvironment(), (ClassLoader)ctx.getClassloader());
                Map map = (Map)unmarshall;
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            return hashMap;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTaskInputContentByTaskId(Long taskId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Task taskInstanceById = taskService.getTaskById(taskId.longValue());
            long documentContentId = taskInstanceById.getTaskData().getDocumentContentId();
            if (documentContentId > 0L) {
                Content contentById = taskService.getContentById(documentContentId);
                if (contentById == null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                ContentMarshallerContext ctx = TaskContentRegistry.get().getMarshallerContext(task.getDeploymentId());
                Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), (Environment)ctx.getEnvironment(), (ClassLoader)ctx.getClassloader());
                Map map = (Map)unmarshall;
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            return hashMap;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addComment(Long taskId, String text, String addedBy, Date addedOn) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            InternalComment comment = (InternalComment)TaskModelProvider.getFactory().newComment();
            comment.setText(text);
            comment.setAddedAt(addedOn);
            comment.setAddedBy(TaskModelProvider.getFactory().newUser(addedBy));
            Long l = ((InternalTaskService)taskService).addComment(taskId.longValue(), (Comment)comment);
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteComment(Long taskId, Long commentId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).deleteComment(taskId.longValue(), commentId.longValue());
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Comment> getCommentsByTaskId(Long taskId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return Collections.emptyList();
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            List list = ((InternalTaskService)taskService).getAllCommentsByTaskId(taskId.longValue());
            return list;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comment getCommentById(Long taskId, Long commentId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Comment comment = ((InternalTaskService)taskService).getCommentById(commentId.longValue());
            return comment;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addAttachment(Long taskId, String userId, Object attachment) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        if (manager instanceof InternalRuntimeManager) {
            attachment = this.process(attachment, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            InternalAttachment att = (InternalAttachment)TaskModelProvider.getFactory().newAttachment();
            att.setAccessType(AccessType.Inline);
            att.setAttachedAt(new Date());
            att.setAttachedBy(TaskModelProvider.getFactory().newUser(userId));
            att.setContentType(attachment.getClass().getName());
            Content content = TaskModelProvider.getFactory().newContent();
            ContentMarshallerContext ctx = TaskContentRegistry.get().getMarshallerContext(task.getDeploymentId());
            ((InternalContent)content).setContent(ContentMarshallerHelper.marshallContent((Object)attachment, (Environment)ctx.getEnvironment()));
            Long l = ((InternalTaskService)taskService).addAttachment(taskId.longValue(), (Attachment)att, content);
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttachment(Long taskId, Long attachmentId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            ((InternalTaskService)taskService).deleteAttachment(taskId.longValue(), attachmentId.longValue());
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment getAttachmentById(Long taskId, Long attachmentId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Attachment attachment = ((InternalTaskService)taskService).getAttachmentById(attachmentId.longValue());
            return attachment;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttachmentContentById(Long taskId, Long attachmentId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Attachment attachment = ((InternalTaskService)taskService).getAttachmentById(attachmentId.longValue());
            long documentContentId = attachment.getAttachmentContentId();
            if (documentContentId > 0L) {
                Object unmarshall;
                Content contentById = taskService.getContentById(documentContentId);
                if (contentById == null) {
                    Object var11_11 = null;
                    return var11_11;
                }
                ContentMarshallerContext ctx = TaskContentRegistry.get().getMarshallerContext(task.getDeploymentId());
                Object object = unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), (Environment)ctx.getEnvironment(), (ClassLoader)ctx.getClassloader());
                return object;
            }
            Object var10_10 = null;
            return var10_10;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attachment> getAttachmentsByTaskId(Long taskId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " was not found");
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return Collections.emptyList();
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            List list = ((InternalTaskService)taskService).getAllAttachmentsByTaskId(taskId.longValue());
            return list;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String deploymentId, Command<T> command) {
        Long processInstanceId = CommonUtils.getProcessInstanceId(command);
        RuntimeManager manager = this.getRuntimeManager(deploymentId, command);
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            TaskService taskService = engine.getTaskService();
            Object object = taskService.execute(command);
            return (T)object;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String deploymentId, Context<?> context, Command<T> command) {
        RuntimeManager manager = this.getRuntimeManager(deploymentId, command);
        RuntimeEngine engine = manager.getRuntimeEngine(context);
        try {
            TaskService taskService = engine.getTaskService();
            Object object = taskService.execute(command);
            return (T)object;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(Long taskId) {
        UserTaskInstanceDesc task = this.dataService.getTaskById(taskId);
        if (task == null) {
            return null;
        }
        RuntimeManager manager = this.getRuntimeManager(task);
        if (manager == null) {
            logger.warn("Cannot find runtime manager for task {}", (Object)taskId);
            return null;
        }
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
        try {
            TaskService taskService = engine.getTaskService();
            Task task2 = ((InternalTaskService)taskService).getTaskById(taskId.longValue());
            return task2;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    @Override
    public <T> T process(T variables, ClassLoader cl) {
        return variables;
    }

    protected void disposeRuntimeEngine(RuntimeManager manager, RuntimeEngine engine) {
        manager.disposeRuntimeEngine(engine);
    }

    private class FalbackRuntimeManager
    implements RuntimeManager {
        private InternalTaskService taskService;

        public FalbackRuntimeManager(InternalTaskService taskService) {
            this.taskService = taskService;
        }

        public RuntimeEngine getRuntimeEngine(Context<?> context) {
            return new RuntimeEngine(){

                public TaskService getTaskService() {
                    return FalbackRuntimeManager.this.taskService;
                }

                public KieSession getKieSession() {
                    throw new UnsupportedOperationException("Not supported in this impl");
                }

                public AuditService getAuditService() {
                    throw new UnsupportedOperationException("Not supported in this impl");
                }
            };
        }

        public String getIdentifier() {
            return "fallback task service manager";
        }

        public void disposeRuntimeEngine(RuntimeEngine runtime) {
        }

        public void close() {
        }

        public void signalEvent(String type, Object event) {
        }
    }
}

