/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.drools.core.command.CommandService;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.jpa.JPAExecutorStoreService;
import org.jbpm.executor.impl.mem.InMemoryExecutorAdminServiceImpl;
import org.jbpm.executor.impl.mem.InMemoryExecutorQueryServiceImpl;
import org.jbpm.executor.impl.mem.InMemoryExecutorStoreService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.internal.executor.api.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceFactory {
    private static final String mode = System.getProperty("org.jbpm.cdi.executor.mode", "singleton");
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServiceFactory.class);
    private static ExecutorService serviceInstance;

    public static synchronized ExecutorService newExecutorService(EntityManagerFactory emf) {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure(emf);
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure(emf);
    }

    public static synchronized ExecutorService newExecutorService() {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure();
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure();
    }

    public static synchronized void resetExecutorService(ExecutorService executorService) {
        if (executorService.equals(serviceInstance)) {
            serviceInstance = null;
        }
    }

    private static ExecutorService configure(EntityManagerFactory emf) {
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        ExecutorImpl executor = new ExecutorImpl();
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        storeService.setCommandService((CommandService)commandService);
        storeService.setEmf(emf);
        executor.setExecutorStoreService(storeService);
        queryService.setCommandService((CommandService)commandService);
        adminService.setCommandService((CommandService)commandService);
        ExecutorServiceImpl service = new ExecutorServiceImpl(executor);
        service.setQueryService(queryService);
        service.setExecutor(executor);
        service.setAdminService(adminService);
        return service;
    }

    private static ExecutorService configure() {
        InMemoryExecutorQueryServiceImpl queryService = new InMemoryExecutorQueryServiceImpl(true);
        ExecutorImpl executor = new ExecutorImpl();
        InMemoryExecutorAdminServiceImpl adminService = new InMemoryExecutorAdminServiceImpl(true);
        InMemoryExecutorStoreService storeService = new InMemoryExecutorStoreService(true);
        executor.setExecutorStoreService(storeService);
        queryService.setStoreService(storeService);
        adminService.setStoreService(storeService);
        ExecutorServiceImpl service = new ExecutorServiceImpl(executor);
        service.setQueryService(queryService);
        service.setExecutor(executor);
        service.setAdminService(adminService);
        return service;
    }

    public static ExecutorRunnable buildRunable(EntityManagerFactory emf) {
        ExecutorRunnable runnable = new ExecutorRunnable();
        AvailableJobsExecutor jobExecutor = null;
        try {
            jobExecutor = (AvailableJobsExecutor)InitialContext.doLookup("java:module/AvailableJobsExecutor");
        }
        catch (Exception e) {
            jobExecutor = ExecutorServiceFactory.buildJobExecutor(emf);
        }
        runnable.setAvailableJobsExecutor(jobExecutor);
        return runnable;
    }

    private static AvailableJobsExecutor buildJobExecutor(EntityManagerFactory emf) {
        AvailableJobsExecutor jobExecutor = new AvailableJobsExecutor();
        ClassCacheManager classCacheManager = new ClassCacheManager();
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        TransactionalCommandService cmdService = new TransactionalCommandService(emf);
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        storeService.setCommandService((CommandService)cmdService);
        storeService.setEmf(emf);
        queryService.setCommandService((CommandService)cmdService);
        jobExecutor.setClassCacheManager(classCacheManager);
        jobExecutor.setQueryService(queryService);
        jobExecutor.setExecutorStoreService(storeService);
        try {
            Object beanManager = InitialContext.doLookup("java:comp/BeanManager");
            jobExecutor.addContextData("BeanManager", beanManager);
        }
        catch (NamingException ex) {
            logger.debug("CDI beans cannot be used in executor commands, because no CDI manager has been found in JNDI.");
        }
        return jobExecutor;
    }

    public static ExecutorRunnable buildRunable() {
        ExecutorRunnable runnable = new ExecutorRunnable();
        AvailableJobsExecutor jobExecutor = null;
        try {
            jobExecutor = (AvailableJobsExecutor)InitialContext.doLookup("java:module/AvailableJobsExecutor");
        }
        catch (Exception e) {
            jobExecutor = new AvailableJobsExecutor();
            ClassCacheManager classCacheManager = new ClassCacheManager();
            InMemoryExecutorStoreService storeService = new InMemoryExecutorStoreService(true);
            InMemoryExecutorQueryServiceImpl queryService = new InMemoryExecutorQueryServiceImpl(true);
            queryService.setStoreService(storeService);
            jobExecutor.setClassCacheManager(classCacheManager);
            jobExecutor.setQueryService(queryService);
            jobExecutor.setExecutorStoreService(storeService);
            try {
                Object beanManager = InitialContext.doLookup("java:comp/BeanManager");
                jobExecutor.addContextData("BeanManager", beanManager);
            }
            catch (NamingException ex) {
                logger.debug("CDI beans cannot be used in executor commands, because no CDI manager has been found in JNDI.");
            }
        }
        runnable.setAvailableJobsExecutor(jobExecutor);
        return runnable;
    }
}

