/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="process-sub-task-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ProcessSubTaskCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1315897796195789680L;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement
    protected Map<String, Object> data;

    public ProcessSubTaskCommand() {
    }

    public ProcessSubTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public ProcessSubTaskCommand(long taskId, String userId, Map<String, Object> data) {
        this.taskId = taskId;
        this.userId = userId;
        this.data = data;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public Void execute(Context cntxt) {
        List subTasks;
        TaskContext context = (TaskContext)cntxt;
        TaskInstanceService instanceService = context.getTaskInstanceService();
        TaskQueryService queryService = context.getTaskQueryService();
        Task task = queryService.getTaskInstanceById(this.taskId.longValue());
        if (task == null) {
            return null;
        }
        Task parentTask = null;
        if (task.getTaskData().getParentId() != -1L) {
            parentTask = queryService.getTaskInstanceById(task.getTaskData().getParentId());
        }
        if (parentTask != null && ((InternalTask)parentTask).getSubTaskStrategy() != null && ((InternalTask)parentTask).getSubTaskStrategy().equals((Object)SubTasksStrategy.EndParentOnAllSubTasksEnd) && ((subTasks = queryService.getSubTasksByParent(parentTask.getId().longValue())).isEmpty() || subTasks.size() == 1 && ((TaskSummary)subTasks.get(0)).getId().equals(this.taskId))) {
            instanceService.complete(parentTask.getId().longValue(), "Administrator", this.data);
        }
        if (((InternalTask)task).getSubTaskStrategy() != null && ((InternalTask)task).getSubTaskStrategy().equals((Object)SubTasksStrategy.SkipAllSubTasksOnParentSkip)) {
            subTasks = queryService.getSubTasksByParent(task.getId().longValue());
            for (TaskSummary taskSummary : subTasks) {
                Task subTask = queryService.getTaskInstanceById(taskSummary.getId().longValue());
                instanceService.skip(subTask.getId().longValue(), "Administrator");
            }
        }
        return null;
    }
}

