/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.LeftTupleSetsImpl;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;

public class PhreakAccumulateNode {
    public void doNode(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTuple next;
        RightTupleSets srcRightTuples = am.getBetaMemory().getStagedRightTuples().takeAll();
        LeftTupleSetsImpl tempLeftTuples = new LeftTupleSetsImpl();
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(accNode, am, wm, srcLeftTuples, trgLeftTuples);
        }
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(accNode, am, wm, srcRightTuples, tempLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderLeftMemory(am.getBetaMemory(), srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderRightMemory(am.getBetaMemory(), srcRightTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(accNode, am, wm, srcRightTuples, tempLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(accNode, am, wm, srcLeftTuples, tempLeftTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(accNode, am, wm, srcRightTuples, tempLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(accNode, am, wm, srcLeftTuples, tempLeftTuples);
        }
        Accumulate accumulate = accNode.getAccumulate();
        LeftTuple leftTuple = tempLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), wm, am, (AccumulateNode.AccumulateContext)leftTuple.getObject(), trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = tempLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), wm, am, (AccumulateNode.AccumulateContext)leftTuple.getObject(), trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        Accumulate accumulate = accNode.getAccumulate();
        BetaMemory bm = am.getBetaMemory();
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        boolean leftTupleMemoryEnabled = accNode.isLeftTupleMemoryEnabled();
        if (leftTupleMemoryEnabled && srcLeftTuples.insertSize() > 32 && ltm instanceof AbstractHashTable) {
            ((AbstractHashTable)((Object)ltm)).ensureCapacity(srcLeftTuples.insertSize());
        }
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            boolean useLeftMemory;
            LeftTuple next = leftTuple.getStagedNext();
            boolean bl = useLeftMemory = leftTupleMemoryEnabled || RuleNetworkEvaluator.useLeftMemory(accNode, leftTuple);
            if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            AccumulateNode.AccumulateContext accresult = new AccumulateNode.AccumulateContext();
            leftTuple.setObject(accresult);
            accresult.context = accumulate.createContext();
            accumulate.init(am.workingMemoryContext, accresult.context, leftTuple, wm);
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            FastIterator rightIt = accNode.getRightIterator(rtm);
            RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
            while (rightTuple != null) {
                RightTuple nextRightTuple = (RightTuple)rightIt.next(rightTuple);
                InternalFactHandle handle = rightTuple.getFactHandle();
                if (constraints.isAllowedCachedLeft(contextEntry, handle)) {
                    PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accresult, useLeftMemory);
                    if (!useLeftMemory && accNode.isRightInputIsRiaNode()) {
                        rtm.remove(rightTuple);
                    }
                }
                rightTuple = nextRightTuple;
            }
            leftTuple.clearStaged();
            trgLeftTuples.addInsert(leftTuple);
            constraints.resetTuple(contextEntry);
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
        Accumulate accumulate = accNode.getAccumulate();
        BetaMemory bm = am.getBetaMemory();
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        if (srcRightTuples.insertSize() > 32 && rtm instanceof AbstractHashTable) {
            ((AbstractHashTable)((Object)rtm)).ensureCapacity(srcRightTuples.insertSize());
        }
        RightTuple rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm != null && ltm.size() > 0) {
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                FastIterator leftIt = accNode.getLeftIterator(ltm);
                LeftTuple leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftUpdates(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        BetaMemory bm = am.getBetaMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        Accumulate accumulate = accNode.getAccumulate();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            FastIterator rightIt = accNode.getRightIterator(rtm);
            RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            if (childLeftTuple != null && rtm.isIndexed() && !rightIt.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accumulate, leftTuple, wm, am, accctx, true);
                childLeftTuple = null;
            }
            if (rightTuple != null) {
                this.doLeftUpdatesProcessChildren(accNode, am, wm, bm, accumulate, constraints, rightIt, leftTuple, accctx, rightTuple, childLeftTuple);
            }
            leftTuple.clearStaged();
            trgLeftTuples.addUpdate(leftTuple);
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    private void doLeftUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, BetaMemory bm, Accumulate accumulate, BetaConstraints constraints, FastIterator rightIt, LeftTuple leftTuple, AccumulateNode.AccumulateContext accctx, RightTuple rightTuple, LeftTuple childLeftTuple) {
        if (childLeftTuple == null) {
            while (rightTuple != null) {
                InternalFactHandle handle = rightTuple.getFactHandle();
                if (constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                    PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                }
                rightTuple = (RightTuple)rightIt.next(rightTuple);
            }
        } else {
            boolean isDirty = false;
            while (rightTuple != null) {
                LeftTuple temp;
                InternalFactHandle handle = rightTuple.getFactHandle();
                if (constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                    if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, childLeftTuple, null, wm, am, accctx, true);
                    } else {
                        temp = childLeftTuple.getLeftParentNext();
                        childLeftTuple.reAddRight();
                        childLeftTuple = temp;
                        isDirty = accumulate.hasRequiredDeclarations();
                    }
                } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                    temp = childLeftTuple.getLeftParentNext();
                    PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, false);
                    childLeftTuple = temp;
                    isDirty = !accumulate.supportsReverse();
                }
                rightTuple = (RightTuple)rightIt.next(rightTuple);
            }
            if (isDirty) {
                PhreakAccumulateNode.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx);
            }
        }
    }

    public void doRightUpdates(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
        BetaMemory bm = am.getBetaMemory();
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        Accumulate accumulate = accNode.getAccumulate();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                FastIterator leftIt = accNode.getLeftIterator(ltm);
                LeftTuple leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                if (childLeftTuple != null && ltm.isIndexed() && !leftIt.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    PhreakAccumulateNode.removePreviousMatchesForRightTuple(accNode, accumulate, rightTuple, wm, am, childLeftTuple, trgLeftTuples);
                    childLeftTuple = null;
                }
                if (leftTuple != null) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    this.doRightUpdatesProcessChildren(accNode, am, wm, bm, constraints, accumulate, leftIt, rightTuple, childLeftTuple, leftTuple, trgLeftTuples);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    private void doRightUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, BetaMemory bm, BetaConstraints constraints, Accumulate accumulate, FastIterator leftIt, RightTuple rightTuple, LeftTuple childLeftTuple, LeftTuple leftTuple, LeftTupleSets trgLeftTuples) {
        if (childLeftTuple == null) {
            while (leftTuple != null) {
                if (constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                    PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                }
                leftTuple = (LeftTuple)leftIt.next(leftTuple);
            }
        } else {
            while (leftTuple != null) {
                if (constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                    LeftTuple temp = null;
                    if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        temp = childLeftTuple.getRightParentNext();
                        childLeftTuple.reAddLeft();
                        PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, true);
                        childLeftTuple = temp;
                    }
                    PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, childLeftTuple, wm, am, accctx, true);
                    if (temp != null) {
                        childLeftTuple = temp;
                    }
                } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    LeftTuple temp = childLeftTuple.getRightParentNext();
                    AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                    PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, true);
                    childLeftTuple = temp;
                }
                leftTuple = (LeftTuple)leftIt.next(leftTuple);
            }
        }
    }

    public void doLeftDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        BetaMemory bm = am.getBetaMemory();
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        Accumulate accumulate = accNode.getAccumulate();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                leftTuple.setObject(null);
                PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accumulate, leftTuple, wm, am, accctx, false);
                if (accctx.propagated) {
                    trgLeftTuples.addDelete(accctx.resultLeftTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
        RightTupleMemory rtm = am.getBetaMemory().getRightTupleMemory();
        Accumulate accumulate = accNode.getAccumulate();
        RightTuple rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
                if (rightTuple.getFirstChild() != null) {
                    LeftTuple match = rightTuple.getFirstChild();
                    while (match != null) {
                        LeftTuple nextLeft = match.getRightParentNext();
                        LeftTuple leftTuple = match.getLeftParent();
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, match, wm, am, accctx, true);
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        match = nextLeft;
                    }
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }

    private void evaluateResultConstraints(AccumulateNode accNode, LeftTupleSink sink, Accumulate accumulate, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        Object result = accumulate.getResult(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        if (result == null) {
            return;
        }
        if (accctx.getResultFactHandle() == null) {
            InternalFactHandle handle = accNode.createResultFactHandle(context, workingMemory, leftTuple, result);
            accctx.setResultFactHandle(handle);
            accctx.setResultLeftTuple(sink.createLeftTuple(handle, leftTuple, sink));
        } else {
            accctx.getResultFactHandle().setObject(result);
        }
        AlphaNodeFieldConstraint[] resultConstraints = accNode.getResultConstraints();
        BetaConstraints resultBinder = accNode.getResultBinder();
        boolean isAllowed = true;
        int length = resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (resultConstraints[i].isAllowed(accctx.resultFactHandle, workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (!resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.getResultFactHandle())) {
                isAllowed = false;
            }
            resultBinder.resetTuple(memory.resultsContext);
        }
        LeftTuple childLeftTuple = accctx.getResultLeftTuple();
        if (accctx.getPropagationContext() != null) {
            childLeftTuple.setPropagationContext(accctx.getPropagationContext());
            accctx.setPropagationContext(null);
        } else {
            childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
        }
        if (accctx.propagated) {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
            if (isAllowed) {
                trgLeftTuples.addUpdate(childLeftTuple);
            } else {
                trgLeftTuples.addDelete(childLeftTuple);
                accctx.propagated = false;
            }
        } else if (isAllowed) {
            trgLeftTuples.addInsert(childLeftTuple);
            accctx.propagated = true;
        }
    }

    private static void addMatch(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx, boolean useLeftMemory) {
        LeftTuple tuple = leftTuple;
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (accNode.isUnwrapRightObject()) {
            tuple = (LeftTuple)handle.getObject();
        }
        accctx.setPropagationContext(rightTuple.getPropagationContext());
        accumulate.accumulate(am.workingMemoryContext, accctx.context, tuple, handle, wm);
        if (useLeftMemory) {
            accNode.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, accNode, true);
        }
    }

    private static void removeMatch(AccumulateNode accNode, Accumulate accumulate, RightTuple rightTuple, LeftTuple match, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx, boolean reaccumulate) {
        LeftTuple leftTuple = match.getLeftParent();
        match.unlinkFromLeftParent();
        match.unlinkFromRightParent();
        InternalFactHandle handle = rightTuple.getFactHandle();
        LeftTuple tuple = leftTuple;
        if (accNode.isUnwrapRightObject()) {
            tuple = (LeftTuple)handle.getObject();
        }
        if (accumulate.supportsReverse()) {
            accumulate.reverse(am.workingMemoryContext, accctx.context, tuple, handle, wm);
        } else if (reaccumulate) {
            PhreakAccumulateNode.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx);
        }
    }

    private static void reaccumulateForLeftTuple(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx) {
        accumulate.init(am.workingMemoryContext, accctx.context, leftTuple, wm);
        for (LeftTuple childMatch = leftTuple.getFirstChild(); childMatch != null; childMatch = childMatch.getLeftParentNext()) {
            InternalFactHandle childHandle = childMatch.getRightParent().getFactHandle();
            LeftTuple tuple = leftTuple;
            if (accNode.isUnwrapRightObject()) {
                tuple = (LeftTuple)childHandle.getObject();
            }
            accumulate.accumulate(am.workingMemoryContext, accctx.context, tuple, childHandle, wm);
        }
    }

    private static void removePreviousMatchesForRightTuple(AccumulateNode accNode, Accumulate accumulate, RightTuple rightTuple, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, LeftTuple firstChild, LeftTupleSets trgLeftTuples) {
        LeftTuple match = firstChild;
        while (match != null) {
            LeftTuple next = match.getRightParentNext();
            LeftTuple leftTuple = match.getLeftParent();
            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
            PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, match, workingMemory, memory, accctx, true);
            if (leftTuple.getStagedType() == 0) {
                trgLeftTuples.addUpdate(leftTuple);
            }
            match = next;
        }
    }

    private static void removePreviousMatchesForLeftTuple(Accumulate accumulate, LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean reInit) {
        LeftTuple match = leftTuple.getFirstChild();
        while (match != null) {
            LeftTuple next = match.getLeftParentNext();
            match.unlinkFromRightParent();
            match.unlinkFromLeftParent();
            match = next;
        }
        if (reInit) {
            accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        }
    }
}

