/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.Date;
import java.util.List;
import org.drools.core.command.CommandService;
import org.jbpm.query.jpa.builder.impl.AbstractQueryBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.services.task.commands.TaskQueryWhereCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.kie.internal.task.query.TaskQueryBuilder;

public class TaskQueryBuilderImpl
extends AbstractQueryBuilderImpl<TaskQueryBuilder>
implements TaskQueryBuilder {
    private final CommandService executor;
    private final String userId;

    public TaskQueryBuilderImpl(String userId, CommandService taskCmdService) {
        this.executor = taskCmdService;
        this.userId = userId;
        this.queryWhere.setAscending(QueryParameterIdentifiers.TASK_ID_LIST);
    }

    public TaskQueryBuilder activationTime(Date ... activationTime) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, "activation time", activationTime);
        return this;
    }

    public TaskQueryBuilder activationTimeRange(Date activationTimeMin, Date activationTimeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, "activation time range", activationTimeMin, activationTimeMax);
        return this;
    }

    public TaskQueryBuilder actualOwner(String ... taskOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, "task owner id", taskOwnerId);
        return this;
    }

    public TaskQueryBuilder archived(boolean archived) {
        Short realValue = archived ? new Short(1) : new Short(0);
        this.addObjectParameter(QueryParameterIdentifiers.ARCHIVED, "archived", new Short[]{realValue});
        return this;
    }

    public TaskQueryBuilder businessAdmin(String ... businessAdminId) {
        this.addObjectParameter(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, "business administrator id", businessAdminId);
        return this;
    }

    public TaskQueryBuilder createdBy(String ... createdById) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_BY_LIST, "created by id", createdById);
        return this;
    }

    public TaskQueryBuilder createdOn(Date ... createdOnDate) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_ON_LIST, "created on", createdOnDate);
        return this;
    }

    public TaskQueryBuilder createdOnRange(Date createdOnMin, Date createdOnMax) {
        this.addRangeParameters(QueryParameterIdentifiers.CREATED_ON_LIST, "created on range", createdOnMin, createdOnMax);
        return this;
    }

    public TaskQueryBuilder deploymentId(String ... deploymentId) {
        this.addObjectParameter(QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, "deployment id", deploymentId);
        return this;
    }

    public TaskQueryBuilder description(String ... description) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_DESCRIPTION_LIST, "description", description);
        return this;
    }

    public TaskQueryBuilder expirationTime(Date ... expirationTime) {
        this.addObjectParameter(QueryParameterIdentifiers.EXPIRATION_TIME_LIST, "expiration time", expirationTime);
        return this;
    }

    public TaskQueryBuilder expirationTimeRange(Date expirationTimeMin, Date expirationTimeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.EXPIRATION_TIME_LIST, "expiration time range", expirationTimeMin, expirationTimeMax);
        return this;
    }

    public TaskQueryBuilder formName(String ... formName) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_FORM_NAME_LIST, "form name", formName);
        return this;
    }

    public TaskQueryBuilder potentialOwner(String ... potentialOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, "potential owner id", potentialOwnerId);
        return this;
    }

    public TaskQueryBuilder processInstanceId(long ... processInstanceId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return this;
    }

    public TaskQueryBuilder name(String ... name) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_NAME_LIST, "task name", name);
        return this;
    }

    public TaskQueryBuilder priority(int ... priority) {
        this.addIntParameter(QueryParameterIdentifiers.TASK_PRIORITY_LIST, "priority", priority);
        return this;
    }

    public TaskQueryBuilder processId(String ... processId) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, "process id", processId);
        return this;
    }

    public TaskQueryBuilder processInstanceIdRange(Long processInstanceIdMin, Long processInstanceIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id range", processInstanceIdMin, processInstanceIdMax);
        return this;
    }

    public TaskQueryBuilder processSessionId(long ... processSessionId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_SESSION_ID_LIST, "process session id", processSessionId);
        return this;
    }

    public TaskQueryBuilder skippable(boolean skippable) {
        this.addObjectParameter(QueryParameterIdentifiers.SKIPPABLE, "skippable", new Boolean[]{skippable});
        return this;
    }

    public TaskQueryBuilder stakeHolder(String ... stakeHolderId) {
        this.addObjectParameter(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, "stakeholder id", stakeHolderId);
        return this;
    }

    public TaskQueryBuilder status(Status ... status) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_STATUS_LIST, "status", status);
        return this;
    }

    public TaskQueryBuilder subject(String ... subject) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_SUBJECT_LIST, "subject", subject);
        return this;
    }

    public TaskQueryBuilder subTaskStrategy(SubTasksStrategy ... subTasksStrategy) {
        this.addObjectParameter(QueryParameterIdentifiers.SUB_TASKS_STRATEGY, "sub tasks strategy", subTasksStrategy);
        return this;
    }

    public TaskQueryBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public TaskQueryBuilder taskIdRange(Long taskIdMin, Long taskIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ID_LIST, "task id range", taskIdMin, taskIdMax);
        return this;
    }

    public TaskQueryBuilder taskParentId(long ... taskParentId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_PARENT_ID_LIST, "task parent id", taskParentId);
        return this;
    }

    public TaskQueryBuilder taskType(String ... taskType) {
        this.addObjectParameter(QueryParameterIdentifiers.TYPE_LIST, "created on", taskType);
        return this;
    }

    public TaskQueryBuilder workItemId(long ... workItemId) {
        this.addLongParameter(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "work item id", workItemId);
        return this;
    }

    public TaskQueryBuilder clear() {
        super.clear();
        this.getQueryWhere().setAscending(QueryParameterIdentifiers.TASK_ID_LIST);
        return this;
    }

    public TaskQueryBuilder ascending(TaskQueryBuilder.OrderBy field) {
        String listId = this.getOrderByListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public TaskQueryBuilder descending(TaskQueryBuilder.OrderBy field) {
        String listId = this.getOrderByListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String getOrderByListId(TaskQueryBuilder.OrderBy field) {
        String orderByString;
        if (field == null) {
            throw new IllegalArgumentException("A null order by criteria is invalid.");
        }
        switch (field) {
            case taskId: {
                orderByString = QueryParameterIdentifiers.TASK_ID_LIST;
                break;
            }
            case processInstanceId: {
                orderByString = QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST;
                break;
            }
            case taskName: {
                orderByString = QueryParameterIdentifiers.TASK_NAME_LIST;
                break;
            }
            case taskStatus: {
                orderByString = QueryParameterIdentifiers.TASK_STATUS_LIST;
                break;
            }
            case createdOn: {
                orderByString = QueryParameterIdentifiers.CREATED_ON_LIST;
                break;
            }
            case createdBy: {
                orderByString = QueryParameterIdentifiers.CREATED_BY_LIST;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported order by arqument: " + field.toString());
            }
        }
        return orderByString;
    }

    public ParametrizedQuery<TaskSummary> build() {
        return new ParametrizedQuery<TaskSummary>(){
            private QueryWhere queryWhere;
            {
                this.queryWhere = new QueryWhere(TaskQueryBuilderImpl.this.getQueryWhere());
            }

            public List<TaskSummary> getResultList() {
                TaskQueryWhereCommand cmd = new TaskQueryWhereCommand(this.queryWhere);
                cmd.setUserId(TaskQueryBuilderImpl.this.userId);
                return (List)TaskQueryBuilderImpl.this.executor.execute((Command)cmd);
            }
        };
    }
}

