/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSetsImpl;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.RightTupleSets;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRemoveRule {
    private static final Logger log = LoggerFactory.getLogger(AddRemoveRule.class);

    public static void addRule(TerminalNode tn, InternalWorkingMemory[] wms, InternalKnowledgeBase kBase) {
        if (log.isTraceEnabled()) {
            log.trace("Adding Rule {}", (Object)tn.getRule().getName());
        }
        LeftTupleSource splitStartLeftTupleSource = AddRemoveRule.getNetworkSplitPoint(tn);
        kBase.invalidateSegmentPrototype(splitStartLeftTupleSource, false);
        for (InternalWorkingMemory wm : wms) {
            if (splitStartLeftTupleSource.getAssociations().size() > 1) {
                ArrayList<PathMemory> pathMems = new ArrayList<PathMemory>();
                AddRemoveRule.collectRtnPathMemories(splitStartLeftTupleSource, wm, pathMems, tn);
                PathMemory newPmem = (PathMemory)wm.getNodeMemory(tn);
                int s = AddRemoveRule.getSegmentPos(splitStartLeftTupleSource, null);
                LeftTupleSink[] sinks = splitStartLeftTupleSource.getSinkPropagator().getSinks();
                if (sinks.length == 2 || sinks.length == 3 && NodeTypeEnums.isBetaNode(sinks[2]) && ((BetaNode)sinks[2]).isRightInputIsRiaNode()) {
                    List<SegmentMemory[]> previousSmems = AddRemoveRule.reInitPathMemories(wm, pathMems, null);
                    int p = 0;
                    SegmentMemory splitSmem = null;
                    for (PathMemory pmem : pathMems) {
                        SegmentMemory[] smems = previousSmems.get(p);
                        for (int i = 0; i < smems.length; ++i) {
                            SegmentMemory sm = smems[i];
                            if (sm == null) continue;
                            if (i < s) {
                                AddRemoveRule.correctSegmentBeforeSplitOnAdd(wm, newPmem, p, pmem, sm);
                                continue;
                            }
                            if (i == s) {
                                splitSmem = AddRemoveRule.correctSegmentOnSplitOnAdd(splitStartLeftTupleSource, wm, newPmem, p, splitSmem, pmem, sm);
                                continue;
                            }
                            if (i <= s) continue;
                            AddRemoveRule.correctSegmentAfterSplitOnAdd(wm, pmem, i, sm);
                        }
                        ++p;
                    }
                } else {
                    SegmentMemory sm = ((PathMemory)pathMems.get(0)).getSegmentMemories()[s];
                    if (sm == null) continue;
                    AddRemoveRule.initNewSegment(splitStartLeftTupleSource, wm, sm);
                    AddRemoveRule.correctSegmentBeforeSplitOnAdd(wm, newPmem, 0, (PathMemory)pathMems.get(0), sm);
                }
            }
            if (120 == splitStartLeftTupleSource.getType() && splitStartLeftTupleSource.getAssociations().size() == 1) {
                AddRemoveRule.insertLiaFacts(splitStartLeftTupleSource, wm);
            }
            AddRemoveRule.insertFacts(splitStartLeftTupleSource.getSinkPropagator().getLastLeftTupleSink(), wm);
        }
    }

    public static void removeRule(TerminalNode tn, InternalWorkingMemory[] wms, InternalKnowledgeBase kBase) {
        if (log.isTraceEnabled()) {
            log.trace("Removing Rule {}", (Object)tn.getRule().getName());
        }
        LeftTupleSource splitStartNode = AddRemoveRule.getNetworkSplitPoint(tn);
        kBase.invalidateSegmentPrototype(splitStartNode, true);
        for (InternalWorkingMemory wm : wms) {
            LeftTupleSink sink;
            SegmentMemory sm;
            PathMemory removedPmem = (PathMemory)wm.getNodeMemory(tn);
            int s = AddRemoveRule.getSegmentPos(splitStartNode, null);
            AddRemoveRule.flushSegmentIfMerge(wm, tn, splitStartNode, s);
            AddRemoveRule.flushStagedTuples(splitStartNode, removedPmem, wm, true);
            wm.flushPropagations();
            if (120 == splitStartNode.getType() && splitStartNode.getAssociations().size() == 1) {
                AddRemoveRule.deleteLiaFacts(splitStartNode, wm);
            }
            if (splitStartNode.getAssociations().size() == 1) {
                sm = removedPmem.getSegmentMemories()[s];
                if (sm == null) continue;
                sink = ((LeftInputAdapterNode)sm.getRootNode()).getSinkPropagator().getFirstLeftTupleSink();
            } else {
                sm = removedPmem.getSegmentMemories()[s + 1];
                if (sm == null) continue;
                sink = (LeftTupleSink)removedPmem.getSegmentMemories()[s + 1].getRootNode();
            }
            AddRemoveRule.deleteFacts(sink, wm);
            if (splitStartNode.getAssociations().size() > 1) {
                int i;
                SegmentMemory[] smems;
                int p;
                ArrayList<PathMemory> pathMems = new ArrayList<PathMemory>();
                AddRemoveRule.collectRtnPathMemories(splitStartNode, wm, pathMems, tn);
                List<SegmentMemory[]> previousSmems = AddRemoveRule.reInitPathMemories(wm, pathMems, tn.getRule());
                if (splitStartNode.getSinkPropagator().size() == 2) {
                    p = 0;
                    for (PathMemory pmem : pathMems) {
                        smems = previousSmems.get(p);
                        for (i = 0; i < smems.length; ++i) {
                            SegmentMemory sm2 = smems[i];
                            if (sm2 == null) continue;
                            if (i < s) {
                                AddRemoveRule.correctSegmentBeforeSplitOnRemove(wm, removedPmem, pmem, sm2, p);
                                continue;
                            }
                            if (i == s) {
                                if (smems[i + 1] == null) continue;
                                AddRemoveRule.correctSegmentOnSplitOnRemove(wm, sm2, smems[i + 1], pmem, removedPmem, p);
                                ++i;
                                continue;
                            }
                            if (i <= s) continue;
                            AddRemoveRule.correctSegmentAfterSplitOnRemove(wm, pmem, i, sm2);
                        }
                        ++p;
                    }
                } else {
                    p = 0;
                    for (PathMemory pmem : pathMems) {
                        smems = previousSmems.get(p++);
                        for (i = 0; i < pmem.getSegmentMemories().length; ++i) {
                            if (smems[i] == null) continue;
                            smems[i].getPathMemories().remove(removedPmem);
                            pmem.getSegmentMemories()[i] = smems[i];
                        }
                    }
                }
            }
            if (removedPmem.getRuleAgendaItem() == null || !removedPmem.getRuleAgendaItem().isQueued()) continue;
            removedPmem.getRuleAgendaItem().dequeue();
        }
    }

    private static void flushSegmentIfMerge(InternalWorkingMemory wm, TerminalNode tn, LeftTupleSource splitStartNode, int segmentPos) {
        if (splitStartNode.getAssociations().size() == 2) {
            PathMemory pmem = AddRemoveRule.getFirstRtnPathMemory(splitStartNode, wm, tn);
            SegmentMemory[] smems = pmem.getSegmentMemories();
            SegmentMemory sm1 = smems[segmentPos];
            SegmentMemory sm2 = smems[segmentPos + 1];
            if (sm1 != null && sm2 != null) {
                if (sm1.getRootNode() == sm1.getTipNode() && 120 == sm1.getTipNode().getType()) {
                    sm1.setStagedTuples(sm2.getStagedLeftTuples());
                } else if (!sm2.getStagedLeftTuples().isEmpty()) {
                    AddRemoveRule.flushStagedTuples(splitStartNode, pmem, wm, false);
                }
            }
        }
    }

    private static void flushStagedTuples(LeftTupleSource splitStartNode, PathMemory pmem, InternalWorkingMemory wm, boolean removeTuples) {
        Memory mem;
        LeftTupleSink sink;
        SegmentMemory sm;
        int smemIndex = AddRemoveRule.getSegmentPos(splitStartNode, null);
        SegmentMemory[] smems = pmem.getSegmentMemories();
        long bit = 1L;
        if (smems.length == 1) {
            sm = smems[0];
            if (sm == null) {
                return;
            }
            sink = ((LeftInputAdapterNode)sm.getRootNode()).getSinkPropagator().getFirstLeftTupleSink();
            mem = sm.getNodeMemories().get(1);
            bit = 2L;
        } else {
            sm = smems[smemIndex + 1];
            if (sm == null) {
                return;
            }
            sink = (LeftTupleSink)sm.getRootNode();
            mem = sm.getNodeMemories().get(0);
        }
        if (removeTuples) {
            AddRemoveRule.processLeftTuples(splitStartNode, sink, sm, wm, false);
        }
        if (!sm.getStagedLeftTuples().isEmpty() && pmem.isRuleLinked()) {
            new RuleNetworkEvaluator().outerEval((LeftInputAdapterNode)smems[0].getRootNode(), pmem, sink, bit, mem, smems, smemIndex, sm.getStagedLeftTuples().takeAll(), wm, new LinkedList<StackEntry>(), true, pmem.getRuleAgendaItem().getRuleExecutor());
        }
    }

    public static void forceFlushLeftTuple(PathMemory pmem, SegmentMemory sm, InternalWorkingMemory wm, LeftTuple leftTuple) {
        Memory mem;
        LeftTupleSink sink;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        if (smems[0] == null) {
            return;
        }
        int smemIndex = sm.getPos();
        long bit = 1L;
        if (sm.getRootNode() instanceof LeftInputAdapterNode) {
            sink = ((LeftInputAdapterNode)sm.getRootNode()).getSinkPropagator().getFirstLeftTupleSink();
            mem = sm.getNodeMemories().get(1);
            bit = 2L;
        } else {
            sink = (LeftTupleSink)sm.getRootNode();
            mem = sm.getNodeMemories().get(0);
        }
        LeftTupleSetsImpl leftTupleSets = new LeftTupleSetsImpl();
        if (leftTuple != null) {
            leftTupleSets.addInsert(leftTuple);
        }
        new RuleNetworkEvaluator().outerEval((LeftInputAdapterNode)smems[0].getRootNode(), pmem, sink, bit, mem, smems, smemIndex, leftTupleSets, wm, new LinkedList<StackEntry>(), true, pmem.getOrCreateRuleAgendaItem(wm).getRuleExecutor());
    }

    private static List<SegmentMemory[]> reInitPathMemories(InternalWorkingMemory wm, List<PathMemory> pathMems, RuleImpl removingRule) {
        ArrayList<SegmentMemory[]> previousSmems = new ArrayList<SegmentMemory[]>();
        for (PathMemory pmem : pathMems) {
            LeftTupleSource lts;
            previousSmems.add(pmem.getSegmentMemories());
            LeftTupleSource startRianLts = null;
            if (NodeTypeEnums.isTerminalNode(pmem.getNetworkNode())) {
                lts = ((TerminalNode)pmem.getNetworkNode()).getLeftTupleSource();
            } else {
                RightInputAdapterNode rian = (RightInputAdapterNode)pmem.getNetworkNode();
                startRianLts = rian.getStartTupleSource();
                lts = rian.getLeftTupleSource();
            }
            AbstractTerminalNode.initPathMemory(pmem, lts, startRianLts, wm, removingRule);
        }
        return previousSmems;
    }

    private static void correctSegmentBeforeSplitOnAdd(InternalWorkingMemory wm, PathMemory newPmem, int p, PathMemory pmem, SegmentMemory sm) {
        pmem.getSegmentMemories()[sm.getPos()] = sm;
        if (p == 0) {
            newPmem.getSegmentMemories()[sm.getPos()] = sm;
            sm.getPathMemories().add(newPmem);
            sm.notifyRuleLinkSegment(wm);
        }
    }

    private static void correctSegmentBeforeSplitOnRemove(InternalWorkingMemory wm, PathMemory removedPmem, PathMemory pmem, SegmentMemory sm, int p) {
        pmem.getSegmentMemories()[sm.getPos()] = sm;
        if (p == 0) {
            sm.getPathMemories().remove(removedPmem);
            sm.notifyRuleLinkSegment(wm);
        }
    }

    private static SegmentMemory correctSegmentOnSplitOnAdd(LeftTupleSource splitStartLeftTupleSource, InternalWorkingMemory wm, PathMemory newPmem, int p, SegmentMemory splitSmem, PathMemory pmem, SegmentMemory sm) {
        if (p == 0) {
            splitSmem = AddRemoveRule.splitSegment(sm, splitStartLeftTupleSource);
            AddRemoveRule.correctSegmentMemoryAfterSplitOnAdd(splitSmem);
            pmem.getSegmentMemories()[sm.getPos()] = sm;
            pmem.getSegmentMemories()[splitSmem.getPos()] = splitSmem;
            newPmem.getSegmentMemories()[sm.getPos()] = sm;
            newPmem.getSegmentMemories()[splitSmem.getPos()] = splitSmem;
            sm.getPathMemories().add(newPmem);
            splitSmem.getPathMemories().add(newPmem);
            sm.notifyRuleLinkSegment(wm);
            splitSmem.notifyRuleLinkSegment(wm);
            AddRemoveRule.initNewSegment(splitStartLeftTupleSource, wm, sm);
        } else {
            pmem.getSegmentMemories()[sm.getPos()] = sm;
            pmem.getSegmentMemories()[splitSmem.getPos()] = splitSmem;
        }
        return splitSmem;
    }

    private static void initNewSegment(LeftTupleSource splitStartLeftTupleSource, InternalWorkingMemory wm, SegmentMemory sm) {
        LeftTupleSinkNode peerLts = splitStartLeftTupleSource.getSinkPropagator().getLastLeftTupleSink();
        if (NodeTypeEnums.isBetaNode(peerLts) && ((BetaNode)peerLts).isRightInputIsRiaNode()) {
            LeftTupleSinkNode subNetworkLts = peerLts.getPreviousLeftTupleSinkNode();
            Memory memory = wm.getNodeMemory((MemoryFactory)((Object)subNetworkLts));
            SegmentMemory newSmem = SegmentUtilities.createChildSegment(wm, peerLts, memory);
            sm.add(newSmem);
        }
        Memory memory = wm.getNodeMemory((MemoryFactory)((Object)peerLts));
        SegmentMemory newSmem = SegmentUtilities.createChildSegment(wm, peerLts, memory);
        sm.add(newSmem);
        LeftTupleSource lts = NodeTypeEnums.isTerminalNode(sm.getTipNode()) ? ((TerminalNode)sm.getTipNode()).getLeftTupleSource() : (LeftTupleSource)sm.getTipNode();
        AddRemoveRule.processLeftTuples(lts, peerLts, newSmem, wm, true);
    }

    private static void correctSegmentOnSplitOnRemove(InternalWorkingMemory wm, SegmentMemory sm1, SegmentMemory sm2, PathMemory pmem, PathMemory removedPmem, int p) {
        if (p == 0) {
            AddRemoveRule.mergeSegment(sm1, sm2);
            pmem.getSegmentMemories()[sm1.getPos()] = sm1;
            sm1.getPathMemories().remove(removedPmem);
            sm1.remove(removedPmem.getSegmentMemories()[sm1.getPos() + 1]);
            sm1.notifyRuleLinkSegment(wm);
        } else {
            pmem.getSegmentMemories()[sm1.getPos()] = sm1;
        }
    }

    private static void correctSegmentAfterSplitOnAdd(InternalWorkingMemory wm, PathMemory pmem, int i, SegmentMemory sm) {
        if (sm.getPos() == i) {
            AddRemoveRule.correctSegmentMemoryAfterSplitOnAdd(sm);
            sm.notifyRuleLinkSegment(wm);
        }
        pmem.getSegmentMemories()[sm.getPos()] = sm;
    }

    private static void correctSegmentAfterSplitOnRemove(InternalWorkingMemory wm, PathMemory pmem, int i, SegmentMemory sm) {
        if (sm.getPos() == i) {
            AddRemoveRule.correctSegmentMemoryAfterSplitOnRemove(sm);
            sm.notifyRuleLinkSegment(wm);
        }
        pmem.getSegmentMemories()[sm.getPos()] = sm;
    }

    public static void correctSegmentMemoryAfterSplitOnAdd(SegmentMemory sm) {
        sm.setPos(sm.getPos() + 1);
        sm.setSegmentPosMaskBit(sm.getSegmentPosMaskBit() << 1);
    }

    public static void correctSegmentMemoryAfterSplitOnRemove(SegmentMemory sm) {
        sm.setPos(sm.getPos() - 1);
        sm.setSegmentPosMaskBit(sm.getSegmentPosMaskBit() >> 1);
    }

    public static int getSegmentPos(LeftTupleSource lts, RuleImpl removingRule) {
        int counter = 0;
        while (lts.getType() != 120) {
            if (!SegmentUtilities.parentInSameSegment(lts, removingRule)) {
                ++counter;
            }
            lts = lts.getLeftTupleSource();
        }
        return counter;
    }

    private static void insertLiaFacts(LeftTupleSource startNode, InternalWorkingMemory wm) {
        PropagationContextFactory pctxFactory = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), 3, null, null, null);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)startNode;
        LeftInputAdapterNode.RightTupleSinkAdapter liaAdapter = new LeftInputAdapterNode.RightTupleSinkAdapter(lian);
        lian.getObjectSource().updateSink(liaAdapter, pctx, wm);
    }

    private static void insertFacts(LeftTupleSink startNode, InternalWorkingMemory wm) {
        LeftTupleSink lts = startNode;
        PropagationContextFactory pctxFactory = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
        while (!NodeTypeEnums.isTerminalNode(lts) && lts.getLeftTupleSource().getType() != 71) {
            if (NodeTypeEnums.isBetaNode(lts)) {
                BetaNode bn = (BetaNode)lts;
                if (!bn.isRightInputIsRiaNode()) {
                    PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), 3, null, null, null);
                    bn.getRightInput().updateSink(bn, pctx, wm);
                } else {
                    AddRemoveRule.insertSubnetworkFacts(bn, wm);
                }
            } else if (lts.getType() == 71) {
                return;
            }
            lts = ((LeftTupleSource)((Object)lts)).getSinkPropagator().getFirstLeftTupleSink();
        }
    }

    private static void insertSubnetworkFacts(BetaNode bn, InternalWorkingMemory wm) {
        RightInputAdapterNode rian = (RightInputAdapterNode)bn.getRightInput();
        LeftTupleSource subLts = rian.getLeftTupleSource();
        while (subLts.getLeftTupleSource() != rian.getStartTupleSource()) {
            subLts = subLts.getLeftTupleSource();
        }
        AddRemoveRule.insertFacts((LeftTupleSink)((Object)subLts), wm);
    }

    private static void deleteLiaFacts(LeftTupleSource startNode, InternalWorkingMemory wm) {
        LeftInputAdapterNode lian = (LeftInputAdapterNode)startNode;
        ObjectSource os = lian.getObjectSource();
        while (os.getType() != 30) {
            os = os.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)os;
        ObjectTypeNode.ObjectTypeNodeMemory omem = (ObjectTypeNode.ObjectTypeNodeMemory)wm.getNodeMemory(otn);
        Iterator<InternalFactHandle> it = omem.iterator();
        while (it.hasNext()) {
            InternalFactHandle fh = it.next();
            LeftTuple childLt = fh.getFirstLeftTuple();
            while (childLt != null) {
                LeftTuple next = childLt.getLeftParentNext();
                if (childLt.getSink() == lian) {
                    fh.removeLeftTuple(childLt);
                }
                childLt = next;
            }
        }
    }

    public static void deleteFacts(LeftTupleSink startNode, InternalWorkingMemory wm) {
        LeftTupleSink lts = startNode;
        while (!NodeTypeEnums.isTerminalNode(lts) && lts.getLeftTupleSource().getType() != 71) {
            if (NodeTypeEnums.isBetaNode(lts)) {
                BetaNode bn = (BetaNode)lts;
                if (!bn.isRightInputIsRiaNode()) {
                    BetaMemory bm = bn.getType() == 211 ? ((AccumulateNode.AccumulateMemory)wm.getNodeMemory(bn)).getBetaMemory() : (BetaMemory)wm.getNodeMemory(bn);
                    RightTupleMemory rtm = bm.getRightTupleMemory();
                    FastIterator it = rtm.fullFastIterator();
                    RightTuple rightTuple = BetaNode.getFirstRightTuple(rtm, it);
                    while (rightTuple != null) {
                        RightTuple next = (RightTuple)it.next(rightTuple);
                        rtm.remove(rightTuple);
                        rightTuple.unlinkFromRightParent();
                        rightTuple = next;
                    }
                    RightTupleSets srcRightTuples = bm.getStagedRightTuples().takeAll();
                    AddRemoveRule.unlinkRightTuples(srcRightTuples.getInsertFirst());
                    AddRemoveRule.unlinkRightTuples(srcRightTuples.getUpdateFirst());
                    AddRemoveRule.unlinkRightTuples(srcRightTuples.getDeleteFirst());
                    AddRemoveRule.deleteFactsFromRightInput(bn, wm);
                } else {
                    AddRemoveRule.deleteSubnetworkFacts(bn, wm);
                }
            } else if (lts.getType() == 71) {
                return;
            }
            lts = ((LeftTupleSource)((Object)lts)).getSinkPropagator().getFirstLeftTupleSink();
        }
    }

    private static void deleteFactsFromRightInput(BetaNode bn, InternalWorkingMemory wm) {
        ObjectSource source = bn.getRightInput();
        if (source instanceof WindowNode) {
            WindowNode.WindowMemory memory = (WindowNode.WindowMemory)wm.getNodeMemory((WindowNode)source);
            for (EventFactHandle factHandle : memory.getFactHandles()) {
                RightTuple rightTuple = factHandle.getFirstRightTuple();
                while (rightTuple != null) {
                    RightTuple nextRightTuple = rightTuple.getHandleNext();
                    if (source.equals(rightTuple.getRightTupleSink())) {
                        rightTuple.unlinkFromRightParent();
                    }
                    rightTuple = nextRightTuple;
                }
            }
        }
    }

    private static void unlinkRightTuples(RightTuple rightTuple) {
        RightTuple rt = rightTuple;
        while (rt != null) {
            RightTuple next = rt.getStagedNext();
            if (rt.getFactHandle() != null) {
                rt.unlinkFromRightParent();
            }
            rt = next;
        }
    }

    private static void deleteSubnetworkFacts(BetaNode bn, InternalWorkingMemory wm) {
        RightInputAdapterNode rian = (RightInputAdapterNode)bn.getRightInput();
        LeftTupleSource subLts = rian.getLeftTupleSource();
        while (subLts.getLeftTupleSource() != rian.getStartTupleSource()) {
            subLts = subLts.getLeftTupleSource();
        }
        AddRemoveRule.deleteFacts((LeftTupleSink)((Object)subLts), wm);
    }

    public static void processLeftTuples(LeftTupleSource node, LeftTupleSink peerNode, SegmentMemory smem, InternalWorkingMemory wm, boolean insert) {
        ArrayList<LeftTupleSink> sinks = new ArrayList<LeftTupleSink>();
        sinks.add(peerNode);
        while (120 != node.getType()) {
            Memory memory = wm.getNodeMemory((MemoryFactory)((Object)node));
            if (memory.getSegmentMemory() == null) {
                return;
            }
            if (NodeTypeEnums.isBetaNode(node)) {
                if (211 == node.getType()) {
                    AccumulateNode.AccumulateMemory am = (AccumulateNode.AccumulateMemory)memory;
                    BetaMemory bm = am.getBetaMemory();
                    FastIterator it = bm.getLeftTupleMemory().fullFastIterator();
                    LeftTuple lt = BetaNode.getFirstLeftTuple(bm.getLeftTupleMemory(), it);
                    while (lt != null) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)lt.getObject();
                        AddRemoveRule.followPeer(accctx.getResultLeftTuple(), smem, sinks, sinks.size() - 1, insert);
                        lt = (LeftTuple)it.next(lt);
                    }
                } else if (201 == node.getType()) {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator it = bm.getRightTupleMemory().fullFastIterator();
                    RightTuple rt = BetaNode.getFirstRightTuple(bm.getRightTupleMemory(), it);
                    while (rt != null) {
                        for (LeftTuple lt = rt.getBlocked(); lt != null; lt = lt.getBlockedNext()) {
                            if (lt.getFirstChild() == null) continue;
                            AddRemoveRule.followPeer(lt.getFirstChild(), smem, sinks, sinks.size() - 1, insert);
                        }
                        rt = (RightTuple)it.next(rt);
                    }
                } else {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator it = bm.getLeftTupleMemory().fullFastIterator();
                    LeftTuple lt = BetaNode.getFirstLeftTuple(bm.getLeftTupleMemory(), it);
                    while (lt != null) {
                        if (lt.getFirstChild() != null) {
                            AddRemoveRule.followPeerFromLeftInput(lt.getFirstChild(), smem, sinks, insert);
                        }
                        lt = (LeftTuple)it.next(lt);
                    }
                }
                return;
            }
            if (151 == node.getType()) {
                FromNode.FromMemory fm = (FromNode.FromMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                LeftTupleMemory ltm = fm.getBetaMemory().getLeftTupleMemory();
                FastIterator it = ltm.fullFastIterator();
                LeftTuple lt = ltm.getFirst(null);
                while (lt != null) {
                    if (lt.getFirstChild() != null) {
                        AddRemoveRule.followPeerFromLeftInput(lt.getFirstChild(), smem, sinks, insert);
                    }
                    lt = (LeftTuple)it.next(lt);
                }
                return;
            }
            sinks.add((LeftTupleSink)((Object)node));
            node = node.getLeftTupleSource();
        }
        LeftInputAdapterNode lian = (LeftInputAdapterNode)node;
        Memory memory = wm.getNodeMemory((MemoryFactory)((Object)node));
        if (memory.getSegmentMemory() == null) {
            return;
        }
        ObjectSource os = lian.getObjectSource();
        while (os.getType() != 30) {
            os = os.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)os;
        ObjectTypeNode.ObjectTypeNodeMemory omem = (ObjectTypeNode.ObjectTypeNodeMemory)wm.getNodeMemory(otn);
        LeftTupleSinkNode firstLiaSink = lian.getSinkPropagator().getFirstLeftTupleSink();
        Iterator<InternalFactHandle> it = omem.iterator();
        while (it.hasNext()) {
            InternalFactHandle fh = it.next();
            if (fh.getFirstLeftTuple() == null) continue;
            for (LeftTuple childLt = fh.getFirstLeftTuple(); childLt != null; childLt = childLt.getLeftParentNext()) {
                if (childLt.getSink() != firstLiaSink) continue;
                AddRemoveRule.followPeer(childLt, smem, sinks, sinks.size() - 1, insert);
            }
        }
    }

    private static void followPeerFromLeftInput(LeftTuple lt, SegmentMemory smem, List<LeftTupleSink> sinks, boolean insert) {
        while (lt != null) {
            AddRemoveRule.followPeer(lt, smem, sinks, sinks.size() - 1, insert);
            lt = lt.getLeftParentNext();
        }
    }

    private static void followPeer(LeftTuple lt, SegmentMemory smem, List<LeftTupleSink> sinks, int i, boolean insert) {
        LeftTupleSink sink = sinks.get(i);
        if (i == 0) {
            if (insert) {
                BetaNode bn;
                if (NodeTypeEnums.isBetaNode(sink) && (bn = (BetaNode)sink).isRightInputIsRiaNode()) {
                    SegmentMemory subSmem = smem.getPrevious();
                    AddRemoveRule.insertPeerLeftTuple(lt, (LeftTupleSink)subSmem.getRootNode(), subSmem);
                }
                AddRemoveRule.insertPeerLeftTuple(lt, sink, smem);
            } else {
                BetaNode bn;
                if (NodeTypeEnums.isBetaNode(sink) && (bn = (BetaNode)sink).isRightInputIsRiaNode()) {
                    SegmentMemory subSmem = smem.getPrevious();
                    AddRemoveRule.deletePeerLeftTuple(lt, (LeftTupleSink)subSmem.getRootNode(), subSmem);
                }
                AddRemoveRule.deletePeerLeftTuple(lt, sink, smem);
            }
        } else {
            LeftTuple peer = lt;
            while (peer.getSink() != sink) {
                peer = peer.getPeer();
            }
            if (211 == peer.getLeftTupleSink().getType()) {
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)peer.getObject();
                AddRemoveRule.followPeer(accctx.getResultLeftTuple(), smem, sinks, i - 1, insert);
            } else if (peer.getFirstChild() != null) {
                for (LeftTuple childLt = peer.getFirstChild(); childLt != null; childLt = childLt.getLeftParentNext()) {
                    AddRemoveRule.followPeer(childLt, smem, sinks, i - 1, insert);
                }
            }
        }
    }

    private static void deletePeerLeftTuple(LeftTuple lt, LeftTupleSink newNode, SegmentMemory smem) {
        LeftTuple peer = lt;
        LeftTuple previousPeer = null;
        while (peer.getSink() != newNode) {
            previousPeer = peer;
            peer = peer.getPeer();
        }
        switch (peer.getStagedType()) {
            case 1: {
                smem.getStagedLeftTuples().removeInsert(peer);
                break;
            }
            case 2: {
                smem.getStagedLeftTuples().removeUpdate(peer);
            }
            case 0: {
                smem.getStagedLeftTuples().addDelete(peer);
            }
        }
        if (previousPeer == null) {
            LeftTuple leftPrevious = peer.getLeftParentPrevious();
            LeftTuple leftNext = peer.getLeftParentNext();
            LeftTuple rightPrevious = peer.getRightParentPrevious();
            LeftTuple rightNext = peer.getRightParentNext();
            LeftTuple newPeer = peer.getPeer();
            if (newPeer != null) {
                AddRemoveRule.replaceChildLeftTuple(peer, leftPrevious, leftNext, rightPrevious, rightNext, newPeer);
            } else {
                lt.unlinkFromLeftParent();
                lt.unlinkFromRightParent();
            }
        } else {
            previousPeer.setPeer(peer.getPeer());
        }
    }

    private static void replaceChildLeftTuple(LeftTuple peer, LeftTuple leftPrevious, LeftTuple leftNext, LeftTuple rightPrevious, LeftTuple rightNext, LeftTuple newPeer) {
        boolean isHandle = peer.getLeftParent() == null;
        InternalFactHandle fh = peer.getLastHandle();
        LeftTuple leftParent = peer.getLeftParent();
        RightTuple rightParent = peer.getRightParent();
        newPeer.setLeftParent(peer.getLeftParent());
        newPeer.setRightParent(peer.getRightParent());
        if (leftPrevious == null && leftNext == null) {
            if (isHandle) {
                fh.removeLeftTuple(peer);
                fh.addFirstLeftTuple(newPeer);
            } else {
                peer.unlinkFromLeftParent();
                leftParent.setFirstChild(newPeer);
                leftParent.setLastChild(newPeer);
            }
        } else if (leftNext != null) {
            newPeer.setLeftParentNext(leftNext);
            leftNext.setLeftParentPrevious(newPeer);
            if (isHandle) {
                fh.setFirstLeftTuple(newPeer);
            } else {
                leftParent.setFirstChild(newPeer);
            }
        } else {
            newPeer.setLeftParentPrevious(leftPrevious);
            leftPrevious.setLeftParentNext(newPeer);
            if (isHandle) {
                fh.setLastLeftTuple(newPeer);
            } else {
                leftParent.setLastChild(newPeer);
            }
        }
        if (rightParent != null) {
            if (rightPrevious == null && rightNext == null) {
                peer.unlinkFromRightParent();
                rightParent.setFirstChild(newPeer);
                rightParent.setLastChild(newPeer);
            } else if (rightNext != null) {
                newPeer.setRightParentNext(rightNext);
                rightNext.setRightParentPrevious(newPeer);
                rightParent.setFirstChild(newPeer);
            } else {
                newPeer.setRightParentPrevious(rightPrevious);
                rightPrevious.setRightParentNext(newPeer);
                rightParent.setLastChild(newPeer);
            }
        }
    }

    private static void insertPeerLeftTuple(LeftTuple lt, LeftTupleSink newNode, SegmentMemory smem) {
        LeftTuple peer = lt;
        while (peer.getPeer() != null) {
            peer = peer.getPeer();
        }
        LeftTuple newPeer = newNode.createPeer(peer);
        smem.getStagedLeftTuples().addInsert(newPeer);
    }

    private static void collectRtnPathMemories(LeftTupleSource lt, InternalWorkingMemory wm, List<PathMemory> pathMems, TerminalNode excludeTerminalNode) {
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (sink == excludeTerminalNode) continue;
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                AddRemoveRule.collectRtnPathMemories((LeftTupleSource)((Object)sink), wm, pathMems, excludeTerminalNode);
                continue;
            }
            if (NodeTypeEnums.isTerminalNode(sink)) {
                PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                pathMems.add(pmem);
                continue;
            }
            if (71 == sink.getType()) {
                RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                pathMems.add(riaMem.getRiaPathMemory());
                continue;
            }
            throw new RuntimeException("Error: Unknown Node. Defensive programming test..");
        }
    }

    private static PathMemory getFirstRtnPathMemory(LeftTupleSource lt, InternalWorkingMemory wm, TerminalNode excludeTerminalNode) {
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (sink == excludeTerminalNode) continue;
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                PathMemory result = AddRemoveRule.getFirstRtnPathMemory((LeftTupleSource)((Object)sink), wm, excludeTerminalNode);
                if (result == null) continue;
                return result;
            }
            if (NodeTypeEnums.isTerminalNode(sink)) {
                return (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
            }
            if (71 == sink.getType()) {
                RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                return riaMem.getRiaPathMemory();
            }
            throw new RuntimeException("Error: Unknown Node. Defensive programming test..");
        }
        return null;
    }

    private static LeftTupleSource getNetworkSplitPoint(TerminalNode tn) {
        LeftTupleSource lt = tn.getLeftTupleSource();
        while (lt.getType() != 120 && lt.getAssociations().size() == 1) {
            lt = lt.getLeftTupleSource();
        }
        return lt;
    }

    public static SegmentMemory splitSegment(SegmentMemory sm1, LeftTupleSource splitNode) {
        SegmentMemory sm2 = new SegmentMemory(splitNode.getSinkPropagator().getFirstLeftTupleSink());
        if (sm1.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm1.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm1.remove(sm);
                sm2.add(sm);
                sm = next;
            }
        }
        sm1.add(sm2);
        sm2.setPos(sm1.getPos());
        sm2.setSegmentPosMaskBit(sm1.getSegmentPosMaskBit());
        sm2.setLinkedNodeMask(sm1.getLinkedNodeMask());
        sm2.getPathMemories().addAll(sm1.getPathMemories());
        sm2.setTipNode(sm1.getTipNode());
        sm1.setTipNode(splitNode);
        if (sm1.getTipNode().getType() == 120 && !sm1.getStagedLeftTuples().isEmpty()) {
            sm2.getStagedLeftTuples().addAll(sm1.getStagedLeftTuples());
        }
        int pos = AddRemoveRule.nodeSegmentPosition(sm1, splitNode);
        AddRemoveRule.splitNodeMemories(sm1, sm2, pos);
        AddRemoveRule.splitBitMasks(sm1, sm2, pos);
        return sm2;
    }

    public static void mergeSegment(SegmentMemory sm1, SegmentMemory sm2) {
        sm1.remove(sm2);
        if (sm2.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm2.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm1.add(sm);
                sm2.remove(sm);
                sm = next;
            }
        }
        sm1.setTipNode(sm2.getTipNode());
        AddRemoveRule.mergeNodeMemories(sm1, sm2);
        AddRemoveRule.mergeBitMasks(sm1, sm2);
    }

    private static void splitBitMasks(SegmentMemory sm1, SegmentMemory sm2, int pos) {
        int splitPos = pos + 1;
        long currentAllLinkedMaskTest = sm1.getAllLinkedMaskTest();
        long currentLinkedNodeMask = sm1.getLinkedNodeMask();
        long mask = (1L << splitPos) - 1L;
        sm1.setAllLinkedMaskTest(mask & currentAllLinkedMaskTest);
        sm1.setLinkedNodeMask(sm1.getLinkedNodeMask() & sm1.getAllLinkedMaskTest());
        mask = currentAllLinkedMaskTest >> splitPos;
        sm2.setAllLinkedMaskTest(mask);
        sm2.setLinkedNodeMask(mask & currentLinkedNodeMask >> splitPos);
    }

    private static void mergeBitMasks(SegmentMemory sm1, SegmentMemory sm2) {
        LinkedList<Memory> smNodeMemories2 = sm2.getNodeMemories();
        long mask = sm2.getAllLinkedMaskTest() << smNodeMemories2.size();
        sm1.setAllLinkedMaskTest(mask & sm1.getAllLinkedMaskTest());
        mask = sm2.getAllLinkedMaskTest() << smNodeMemories2.size();
        sm1.setLinkedNodeMask(mask & sm1.getLinkedNodeMask());
    }

    private static void splitNodeMemories(SegmentMemory sm1, SegmentMemory sm2, int pos) {
        LinkedList<Memory> smNodeMemories1 = sm1.getNodeMemories();
        LinkedList<Memory> smNodeMemories2 = sm2.getNodeMemories();
        Memory mem = smNodeMemories1.getFirst();
        int nodePosMask = 1;
        int length = smNodeMemories1.size();
        for (int i = 0; i < length; ++i) {
            Memory next = (Memory)mem.getNext();
            if (i > pos) {
                smNodeMemories1.remove(mem);
                smNodeMemories2.add(mem);
                mem.setSegmentMemory(sm2);
                BetaMemory bm = null;
                if (mem instanceof AccumulateNode.AccumulateMemory) {
                    bm = ((AccumulateNode.AccumulateMemory)mem).getBetaMemory();
                } else if (mem instanceof BetaMemory) {
                    bm = (BetaMemory)mem;
                }
                if (bm != null) {
                    bm.setNodePosMaskBit(nodePosMask);
                }
                nodePosMask <<= 1;
            }
            mem = next;
        }
    }

    private static void mergeNodeMemories(SegmentMemory sm1, SegmentMemory sm2) {
        LinkedList<Memory> smNodeMemories1 = sm1.getNodeMemories();
        LinkedList<Memory> smNodeMemories2 = sm2.getNodeMemories();
        int nodePosMask = 1;
        int length = smNodeMemories1.size();
        for (int i = 0; i < length; ++i) {
            nodePosMask >>= 1;
        }
        Memory mem = smNodeMemories2.getFirst();
        while (mem != null) {
            Memory next = (Memory)mem.getNext();
            smNodeMemories2.remove(mem);
            smNodeMemories1.add(mem);
            mem.setSegmentMemory(sm1);
            BetaMemory bm = null;
            if (mem instanceof AccumulateNode.AccumulateMemory) {
                bm = ((AccumulateNode.AccumulateMemory)mem).getBetaMemory();
            } else if (mem instanceof BetaMemory) {
                bm = (BetaMemory)mem;
            }
            if (bm != null) {
                bm.setNodePosMaskBit(nodePosMask);
            }
            nodePosMask >>= 1;
            mem = next;
        }
    }

    private static int nodeSegmentPosition(SegmentMemory sm1, LeftTupleSource splitNode) {
        LeftTupleSource lt = splitNode;
        int nodePos = 0;
        while (lt != sm1.getRootNode()) {
            lt = lt.getLeftTupleSource();
            ++nodePos;
        }
        return nodePos;
    }
}

