/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.spi.Salience;

public class PhreakBranchNode {
    public void doNode(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(branchNode, cbm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(branchNode, cbm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(branchNode, cbm, sink, wm, srcLeftTuples, trgLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        int salienceInt = 0;
        Salience salience = ruleAgendaItem.getRule().getSalience();
        if (!salience.isDynamic()) {
            salienceInt = ruleAgendaItem.getRule().getSalience().getValue();
            salience = null;
        }
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            boolean breaking = false;
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, wm, cbm.context);
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(branchNode, leftTuple);
            if (conditionalExecution != null) {
                RuleTerminalNode rtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                LeftTuple branchedLeftTuple = rtn.createLeftTuple(leftTuple, rtn, leftTuple.getPropagationContext(), useLeftMemory);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, executor, wm.getAgenda(), executor.getRuleAgendaItem(), salienceInt, salience, branchedLeftTuple, wm);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        int salienceInt = 0;
        Salience salience = ruleAgendaItem.getRule().getSalience();
        if (!salience.isDynamic()) {
            salienceInt = ruleAgendaItem.getRule().getSalience().getValue();
            salience = null;
        }
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple rtnLeftTuple = null;
            LeftTuple mainLeftTuple = null;
            LeftTuple child = leftTuple.getFirstChild();
            if (child != null) {
                if (child.getSink() == sink) {
                    mainLeftTuple = child;
                } else {
                    rtnLeftTuple = child;
                }
                child = child.getLeftParentNext();
                if (child != null) {
                    if (child.getSink() == sink) {
                        mainLeftTuple = child;
                    } else {
                        rtnLeftTuple = child;
                    }
                }
            }
            RuleTerminalNode oldRtn = null;
            if (rtnLeftTuple != null) {
                oldRtn = (RuleTerminalNode)rtnLeftTuple.getSink();
            }
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, wm, cbm.context);
            RuleTerminalNode newRtn = null;
            boolean breaking = false;
            if (conditionalExecution != null) {
                newRtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                breaking = conditionalExecution.isBreaking();
            }
            if (oldRtn != null) {
                if (newRtn == null) {
                    if (rtnLeftTuple.getMemory() != null) {
                        executor.removeLeftTuple(rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(wm, executor, rtnLeftTuple);
                } else if (newRtn == oldRtn) {
                    PhreakRuleTerminalNode.doLeftTupleUpdate(newRtn, executor, wm.getAgenda(), salienceInt, salience, rtnLeftTuple, wm);
                } else {
                    if (rtnLeftTuple.getMemory() != null) {
                        executor.removeLeftTuple(rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(wm, executor, rtnLeftTuple);
                    rtnLeftTuple = newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                    PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, wm.getAgenda(), executor.getRuleAgendaItem(), salienceInt, salience, rtnLeftTuple, wm);
                }
            } else if (newRtn != null) {
                rtnLeftTuple = newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, wm.getAgenda(), executor.getRuleAgendaItem(), salienceInt, salience, rtnLeftTuple, wm);
            }
            if (mainLeftTuple != null) {
                switch (mainLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(mainLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(mainLeftTuple);
                    }
                }
                if (!breaking) {
                    trgLeftTuples.addUpdate(mainLeftTuple);
                } else {
                    trgLeftTuples.addDelete(mainLeftTuple);
                }
            } else if (!breaking) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, RuleExecutor executor) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple rtnLeftTuple = (LeftTuple)leftTuple.getObject();
            LeftTuple mainLeftTuple = leftTuple.getFirstChild();
            if (rtnLeftTuple != null) {
                if (rtnLeftTuple.getMemory() != null) {
                    executor.removeLeftTuple(rtnLeftTuple);
                }
                PhreakRuleTerminalNode.doLeftDelete(wm, executor, rtnLeftTuple);
            }
            if (mainLeftTuple != null) {
                switch (mainLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(mainLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(mainLeftTuple);
                    }
                }
                trgLeftTuples.addDelete(mainLeftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }
}

