/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.SegmentMemory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ConcurrentNodeMemories
implements NodeMemories {
    private AtomicReferenceArray<Memory> memories;
    private Lock lock;
    private InternalKnowledgeBase kBase;

    public ConcurrentNodeMemories(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.memories = new AtomicReferenceArray(this.kBase.getNodeCount());
        this.lock = new ReentrantLock();
    }

    @Override
    public void clearNodeMemory(MemoryFactory node) {
        this.memories.set(node.getId(), null);
    }

    @Override
    public void clear() {
        this.memories = new AtomicReferenceArray(this.kBase.getNodeCount());
    }

    @Override
    public void resetAllMemories(StatefulKnowledgeSession session) {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)session.getKieBase();
        HashSet<SegmentMemory> smems = new HashSet<SegmentMemory>();
        for (int i = 0; i < this.memories.length(); ++i) {
            Memory memory = this.memories.get(i);
            if (memory == null) continue;
            if (memory.getSegmentMemory() != null) {
                smems.add(memory.getSegmentMemory());
            }
            memory.reset();
        }
        for (SegmentMemory smem : smems) {
            smem.reset(kBase.getSegmentPrototype(smem));
            if (!smem.isSegmentLinked()) continue;
            smem.notifyRuleLinkSegment((InternalWorkingMemory)session);
        }
    }

    public Memory getNodeMemory(MemoryFactory node, InternalWorkingMemory wm) {
        Memory memory;
        if (node.getId() >= this.memories.length()) {
            this.resize(node);
        }
        if ((memory = this.memories.get(node.getId())) == null) {
            memory = this.createNodeMemory(node, wm);
        }
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memory createNodeMemory(MemoryFactory node, InternalWorkingMemory wm) {
        try {
            this.lock.lock();
            Memory memory = this.memories.get(node.getId());
            if (memory == null) {
                memory = node.createMemory(this.kBase.getConfiguration(), wm);
                if (!this.memories.compareAndSet(node.getId(), null, memory)) {
                    memory = this.memories.get(node.getId());
                }
            }
            Memory memory2 = memory;
            return memory2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(MemoryFactory node) {
        try {
            this.lock.lock();
            if (node.getId() >= this.memories.length()) {
                int size = Math.max(this.kBase.getNodeCount(), node.getId() + 32);
                AtomicReferenceArray<Memory> newMem = new AtomicReferenceArray<Memory>(size);
                for (int i = 0; i < this.memories.length(); ++i) {
                    newMem.set(i, this.memories.get(i));
                }
                this.memories = newMem;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setKnowledgeBaseReference(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
    }

    @Override
    public Memory peekNodeMemory(int nodeId) {
        return this.memories.get(nodeId);
    }

    @Override
    public int length() {
        return this.memories.length();
    }
}

