/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.LeftTupleSets;
import org.drools.core.reteoo.LeftTuple;

public class LeftTupleSetsImpl
implements LeftTupleSets {
    private LeftTuple insertFirst;
    private LeftTuple deleteFirst;
    private LeftTuple updateFirst;
    private LeftTuple normalizedDeleteFirst;

    public LeftTupleSetsImpl() {
    }

    LeftTupleSetsImpl(LeftTuple insertFirst, LeftTuple updateFirst, LeftTuple deleteFirst, LeftTuple normalizedDeleteFirst) {
        this.insertFirst = insertFirst;
        this.updateFirst = updateFirst;
        this.deleteFirst = deleteFirst;
        this.normalizedDeleteFirst = normalizedDeleteFirst;
    }

    @Override
    public LeftTuple getInsertFirst() {
        return this.insertFirst;
    }

    @Override
    public LeftTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    @Override
    public LeftTuple getUpdateFirst() {
        return this.updateFirst;
    }

    @Override
    public LeftTuple getNormalizedDeleteFirst() {
        return this.normalizedDeleteFirst;
    }

    @Override
    public void resetAll() {
        this.insertFirst = null;
        this.deleteFirst = null;
        this.updateFirst = null;
        this.normalizedDeleteFirst = null;
    }

    @Override
    public boolean addInsert(LeftTuple leftTuple) {
        if (leftTuple.getStagedType() == 2) {
            return false;
        }
        leftTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = leftTuple;
            return true;
        }
        leftTuple.setStagedNext(this.insertFirst);
        this.insertFirst.setStagePrevious(leftTuple);
        this.insertFirst = leftTuple;
        return false;
    }

    @Override
    public boolean addDelete(LeftTuple leftTuple) {
        switch (leftTuple.getStagedType()) {
            case 1: {
                this.removeInsert(leftTuple);
                return this.deleteFirst == null;
            }
            case 2: {
                this.removeUpdate(leftTuple);
            }
        }
        leftTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = leftTuple;
            return true;
        }
        leftTuple.setStagedNext(this.deleteFirst);
        this.deleteFirst.setStagePrevious(leftTuple);
        this.deleteFirst = leftTuple;
        return false;
    }

    @Override
    public boolean addNormalizedDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)4);
        if (this.normalizedDeleteFirst == null) {
            this.normalizedDeleteFirst = leftTuple;
            return true;
        }
        leftTuple.setStagedNext(this.normalizedDeleteFirst);
        this.normalizedDeleteFirst.setStagePrevious(leftTuple);
        this.normalizedDeleteFirst = leftTuple;
        return false;
    }

    @Override
    public boolean addUpdate(LeftTuple leftTuple) {
        if (leftTuple.getStagedType() == 1) {
            return false;
        }
        leftTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = leftTuple;
            return true;
        }
        leftTuple.setStagedNext(this.updateFirst);
        this.updateFirst.setStagePrevious(leftTuple);
        this.updateFirst = leftTuple;
        return false;
    }

    @Override
    public void removeInsert(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.insertFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
    }

    @Override
    public void removeDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.deleteFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
    }

    @Override
    public void removeUpdate(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.updateFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
    }

    @Override
    public void addAllInserts(LeftTupleSets tupleSets) {
        LeftTupleSetsImpl tupleSetsImpl = (LeftTupleSetsImpl)tupleSets;
        if (tupleSetsImpl.getInsertFirst() != null) {
            if (this.insertFirst == null) {
                this.insertFirst = tupleSetsImpl.getInsertFirst();
            } else {
                LeftTuple last = null;
                for (LeftTuple current = this.insertFirst; current != null; current = current.getStagedNext()) {
                    last = current;
                }
                LeftTuple leftTuple = tupleSetsImpl.getInsertFirst();
                last.setStagedNext(leftTuple);
                leftTuple.setStagePrevious(last);
            }
            tupleSetsImpl.insertFirst = null;
        }
    }

    @Override
    public void addAllDeletes(LeftTupleSets tupleSets) {
        if (tupleSets.getDeleteFirst() != null) {
            if (this.deleteFirst == null) {
                this.deleteFirst = tupleSets.getDeleteFirst();
            } else {
                LeftTuple last = null;
                for (LeftTuple current = this.deleteFirst; current != null; current = current.getStagedNext()) {
                    last = current;
                }
                LeftTuple leftTuple = tupleSets.getDeleteFirst();
                last.setStagedNext(leftTuple);
                leftTuple.setStagePrevious(last);
            }
            ((LeftTupleSetsImpl)tupleSets).deleteFirst = null;
        }
    }

    @Override
    public void addAllUpdates(LeftTupleSets tupleSets) {
        LeftTupleSetsImpl tupleSetsImpl = (LeftTupleSetsImpl)tupleSets;
        if (tupleSetsImpl.getUpdateFirst() != null) {
            if (this.updateFirst == null) {
                this.updateFirst = tupleSetsImpl.getUpdateFirst();
            } else {
                LeftTuple last = null;
                for (LeftTuple current = this.updateFirst; current != null; current = current.getStagedNext()) {
                    last = current;
                }
                LeftTuple leftTuple = tupleSetsImpl.getUpdateFirst();
                last.setStagedNext(leftTuple);
                leftTuple.setStagePrevious(last);
            }
            tupleSetsImpl.updateFirst = null;
        }
    }

    @Override
    public void addAll(LeftTupleSets source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    @Override
    public LeftTupleSets takeAll() {
        LeftTupleSetsImpl clone = new LeftTupleSetsImpl(this.insertFirst, this.updateFirst, this.deleteFirst, this.normalizedDeleteFirst);
        this.resetAll();
        return clone;
    }

    public void clear() {
        this.clear(this.getInsertFirst());
        this.clear(this.getDeleteFirst());
        this.clear(this.getUpdateFirst());
        this.clear(this.getNormalizedDeleteFirst());
        this.resetAll();
    }

    private void clear(LeftTuple leftTuple) {
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.insertFirst == null && this.deleteFirst == null && this.updateFirst == null && this.normalizedDeleteFirst == null;
    }

    @Override
    public String toStringSizes() {
        return "TupleSets[hasInsert=" + (this.insertFirst != null) + ", hasDelete=" + (this.deleteFirst != null) + ", hasUpdate=" + (this.updateFirst != null) + "]";
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        this.appendSet(sbuilder, this.getInsertFirst());
        sbuilder.append("Deleted:\n");
        this.appendSet(sbuilder, this.getDeleteFirst());
        sbuilder.append("Updated:\n");
        this.appendSet(sbuilder, this.getUpdateFirst());
        sbuilder.append("Normalized Deleted:\n");
        this.appendSet(sbuilder, this.getNormalizedDeleteFirst());
        return sbuilder.toString();
    }

    private void appendSet(StringBuilder sbuilder, LeftTuple leftTuple) {
        while (leftTuple != null) {
            sbuilder.append(" ").append(leftTuple).append("\n");
            leftTuple = leftTuple.getStagedNext();
        }
    }
}

